% FilesApi - 
%
% FilesApi Properties:
%    apiClient - ApiClient instance
%
% FilesApi Methods
%    addFileTags        - Add list of tags on a file.
%    deleteFile         - Delete a File
%    deleteFileTags     - Remove the specified tags from most recent file version
%    deleteFilesByIds   - Delete multiple files by ID list
%    deleteFilesByQuery - Delete multiple files by query
%    getAllFiles        - Return all files
%    getFile            - Get File
%    getFileTags        - Return a file tags, from any version
%    getFileVersions    - Get Versions
%    getFileZipInfo     - Get Zip Info
%    moveFile           - Move and/or rename a file
%    restoreFile        - Restore a File
%    setFileTags        - Set list of tags on a file.
%    upsertFile         - Upsert a File
classdef FilesApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = FilesApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addFileTags(obj, fileId, body, varargin)
            % Add list of tags on a file.
            % fileId (char)
            % body (vector[char])
            % returns: [vector[char], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/files/{file_id}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteFile(obj, fileId, varargin)
            % Delete a File
            % fileId (char)
            % version (integer):Version of the file to delete (defaults to current version)
            % deleteReason (ContainerDeleteReason):A reason for deletion when audit-trail is enabled
            % force (logical):Force deletion of the file even if some checks fail. Deprecated, will be removed in a future release.
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            if (ismember('force',x__inp.UsingDefaults)), addParameter(x__inp, 'force', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end
            if ~isempty(x__inp.Results.force)
                queryParams = [queryParams, 'force', flywheel.ApiClient.castParam(x__inp.Results.force, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/files/{file_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteFileTags(obj, fileId, varargin)
            % Remove the specified tags from most recent file version
            % fileId (char)
            % body (vector[char]):List of application-specific tags
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('body',x__inp.UsingDefaults)), addParameter(x__inp, 'body', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/files/{file_id}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteFilesByIds(obj, body, varargin)
            % Delete multiple files by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteFilesByQuery(obj, body, varargin)
            % Delete multiple files by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/files/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllFiles(obj, varargin)
            % Return all files
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % returns: [PageGenericFileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.PageGenericFileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getFile(obj, fileId, varargin)
            % Get File
            % fileId (char)
            % version (integer)
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/files/{file_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getFileTags(obj, fileId, varargin)
            % Return a file tags, from any version
            % fileId (char)
            % version (integer)
            % returns: [vector[char], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/files/{file_id}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getFileVersions(obj, fileId, varargin)
            % Get Versions
            % fileId (char)
            % returns: [vector[FileVersionOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/files/{file_id}/versions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileVersionOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getFileZipInfo(obj, fileId, varargin)
            % Get Zip Info
            % fileId (char)
            % version (integer)
            % ticket (char)
            % returns: [ZipfileInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/files/{file_id}/zip_info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ZipfileInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = moveFile(obj, fileId, body, varargin)
            % Move and/or rename a file
            % fileId (char)
            % body (FileMoveInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileMoveInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/files/{file_id}/move', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = restoreFile(obj, fileId, version, evaluateGearRules, varargin)
            % Restore a File
            % fileId (char)
            % version (integer)
            % evaluateGearRules (logical):Specify if gear rules should be reevaluated on the newly created file version
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('version',x__inp.UsingDefaults)), addRequired(x__inp, 'version'); end
            if (ismember('evaluateGearRules',x__inp.UsingDefaults)), addRequired(x__inp, 'evaluateGearRules'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, version, evaluateGearRules, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.evaluateGearRules)
                queryParams = [queryParams, 'evaluate_gear_rules', flywheel.ApiClient.castParam(x__inp.Results.evaluateGearRules, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/files/{file_id}/restore', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = setFileTags(obj, fileId, body, varargin)
            % Set list of tags on a file.
            % fileId (char)
            % body (vector[char]):List of application-specific tags
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('fileId',x__inp.UsingDefaults)), addRequired(x__inp, 'fileId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, fileId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.fileId)
                pathParams = [pathParams, 'file_id', x__inp.Results.fileId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/files/{file_id}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = upsertFile(obj, body, varargin)
            % Upsert a File
            % body (FileUpsertInput)
            % forceUpdate (logical)
            % returns: [FileUpsertOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('forceUpdate',x__inp.UsingDefaults)), addParameter(x__inp, 'forceUpdate', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.forceUpdate)
                queryParams = [queryParams, 'force_update', flywheel.ApiClient.castParam(x__inp.Results.forceUpdate, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileUpsertInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileUpsertOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
