% GroupsApi - 
%
% GroupsApi Properties:
%    apiClient - ApiClient instance
%
% GroupsApi Methods
%    addGroup                          - Add a group
%    addGroupPermission                - Add a permission
%    addGroupPermissionTemplate        - Add a permission template
%    addGroupTag                       - Add a tag to a(n) group.
%    addGroupTags                      - Add multiple tags to a(n) group
%    addRoleToGroup                    - Add a role to the pool of roles in a group
%    deleteGroup                       - Delete group
%    deleteGroupTag                    - Delete a tag
%    deleteGroupTags                   - Delete multiple tags from a(n) group
%    deleteGroupUserPermission         - Delete a permission
%    deleteGroupUserPermissionTemplate - Delete a permission
%    deleteGroupsByIds                 - Delete multiple groups by ID list
%    deleteGroupsByQuery               - Delete multiple groups by query
%    getAllGroupRoles                  - Get list of group roles
%    getAllGroups                      - List all groups
%    getGroup                          - Get group info
%    getGroupProjects                  - Get all projects in a group
%    getGroupRole                      - Return the role identified by the RoleId
%    getGroupTag                       - Get the value of a tag, by name.
%    getGroupUserPermission            - List a user's permissions for this group.
%    getGroupUserPermissionTemplate    - List a user's permissions for this group.
%    modifyGroup                       - Update group
%    modifyGroupUserPermission         - Update a user's permission for this group.
%    modifyGroupUserPermissionTemplate - Update a user's permission for this group.
%    removeRoleFromGroup               - Remove the role from the group
%    renameGroupTag                    - Rename a tag.
classdef GroupsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = GroupsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addGroup(obj, body, varargin)
            % Add a group
            % body (GroupInput)
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.GroupInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/groups', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addGroupPermission(obj, groupId, body, varargin)
            % Add a permission
            % groupId (char)
            % body (AccessPermission)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AccessPermission.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/groups/{group_id}/permissions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addGroupPermissionTemplate(obj, groupId, body, varargin)
            % Add a permission template
            % groupId (char)
            % body (RolePermission)
            % propagate (logical)
            % xAcceptFeature (vector[Object])
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('propagate',x__inp.UsingDefaults)), addParameter(x__inp, 'propagate', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.propagate)
                queryParams = [queryParams, 'propagate', flywheel.ApiClient.castParam(x__inp.Results.propagate, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.RolePermission.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/groups/{group_id}/permissions/templates', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addGroupTag(obj, cid, body, varargin)
            % Add a tag to a(n) group.
            % cid (char)
            % body (Tag)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/groups/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addGroupTags(obj, cid, body, varargin)
            % Add multiple tags to a(n) group
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/groups/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addRoleToGroup(obj, groupId, body, varargin)
            % Add a role to the pool of roles in a group
            % groupId (char)
            % body (GroupRole)
            % returns: [RoleOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.GroupRole.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/groups/{group_id}/roles', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RoleOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroup(obj, groupId, varargin)
            % Delete group
            % groupId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/groups/{group_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupTag(obj, cid, value, varargin)
            % Delete a tag
            % cid (char)
            % value (char):The tag to interact with
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/groups/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupTags(obj, cid, body, varargin)
            % Delete multiple tags from a(n) group
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/groups/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupUserPermission(obj, groupId, userId, varargin)
            % Delete a permission
            % groupId (char)
            % userId (char)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/groups/{group_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupUserPermissionTemplate(obj, groupId, userId, varargin)
            % Delete a permission
            % groupId (char)
            % userId (char)
            % propagate (logical)
            % xAcceptFeature (vector[Object])
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            if (ismember('propagate',x__inp.UsingDefaults)), addParameter(x__inp, 'propagate', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.propagate)
                queryParams = [queryParams, 'propagate', flywheel.ApiClient.castParam(x__inp.Results.propagate, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/groups/{group_id}/permissions/templates/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupsByIds(obj, body, varargin)
            % Delete multiple groups by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/groups', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteGroupsByQuery(obj, body, varargin)
            % Delete multiple groups by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/groups/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllGroupRoles(obj, groupId, varargin)
            % Get list of group roles
            % groupId (char)
            % returns: [vector[RoleOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}/roles', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.RoleOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllGroups(obj, varargin)
            % List all groups
            % exhaustive (logical):Set to return a complete list regardless of permissions
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroup(obj, groupId, varargin)
            % Get group info
            % groupId (char)
            % returns: [GroupOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.GroupOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroupProjects(obj, groupId, varargin)
            % Get all projects in a group
            % groupId (char)
            % exhaustive (logical)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}/projects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroupRole(obj, groupId, roleId, varargin)
            % Return the role identified by the RoleId
            % groupId (char)
            % roleId (char)
            % returns: [RoleOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('roleId',x__inp.UsingDefaults)), addRequired(x__inp, 'roleId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, roleId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.roleId)
                pathParams = [pathParams, 'role_id', x__inp.Results.roleId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}/roles/{role_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RoleOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroupTag(obj, cid, value, varargin)
            % Get the value of a tag, by name.
            % cid (char)
            % value (char):The tag to interact with
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroupUserPermission(obj, groupId, userId, varargin)
            % List a user's permissions for this group.
            % groupId (char)
            % userId (char)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getGroupUserPermissionTemplate(obj, groupId, userId, varargin)
            % List a user's permissions for this group.
            % groupId (char)
            % userId (char)
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/groups/{group_id}/permissions/templates/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyGroup(obj, groupId, body, varargin)
            % Update group
            % groupId (char)
            % body (GroupUpdate)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.GroupUpdate.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/groups/{group_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyGroupUserPermission(obj, groupId, userId, body, varargin)
            % Update a user's permission for this group.
            % groupId (char)
            % userId (char)
            % body (AccessPermissionUpdate)
            % returns: [AccessPermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AccessPermissionUpdate.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/groups/{group_id}/permissions/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.AccessPermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyGroupUserPermissionTemplate(obj, groupId, userId, body, varargin)
            % Update a user's permission for this group.
            % groupId (char)
            % userId (char)
            % body (RolePermissionUpdate)
            % propagate (logical)
            % xAcceptFeature (vector[Object])
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('userId',x__inp.UsingDefaults)), addRequired(x__inp, 'userId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('propagate',x__inp.UsingDefaults)), addParameter(x__inp, 'propagate', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, userId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.userId)
                pathParams = [pathParams, 'user_id', x__inp.Results.userId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.propagate)
                queryParams = [queryParams, 'propagate', flywheel.ApiClient.castParam(x__inp.Results.propagate, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.RolePermissionUpdate.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/groups/{group_id}/permissions/templates/{user_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = removeRoleFromGroup(obj, groupId, roleId, varargin)
            % Remove the role from the group
            % groupId (char)
            % roleId (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('groupId',x__inp.UsingDefaults)), addRequired(x__inp, 'groupId'); end
            if (ismember('roleId',x__inp.UsingDefaults)), addRequired(x__inp, 'roleId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, groupId, roleId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.groupId)
                pathParams = [pathParams, 'group_id', x__inp.Results.groupId];
            end
            if ~isempty(x__inp.Results.roleId)
                pathParams = [pathParams, 'role_id', x__inp.Results.roleId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/groups/{group_id}/roles/{role_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = renameGroupTag(obj, cid, value, body, varargin)
            % Rename a tag.
            % cid (char)
            % value (char):The tag to interact with
            % body (Tag)
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/groups/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
