% JupyterlabServersApi - 
%
% JupyterlabServersApi Properties:
%    apiClient - ApiClient instance
%
% JupyterlabServersApi Methods
%    getJupyterlabServer    - Get jupyterlab server
%    modifyJupyterlabServer - Update a jupyterlab server
classdef JupyterlabServersApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = JupyterlabServersApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = getJupyterlabServer(obj, jupyterlabServerId, varargin)
            % Get jupyterlab server
            % jupyterlabServerId (char)
            % returns: [JupyterlabServerResponse, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('jupyterlabServerId',x__inp.UsingDefaults)), addRequired(x__inp, 'jupyterlabServerId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, jupyterlabServerId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.jupyterlabServerId)
                pathParams = [pathParams, 'jupyterlab_server_id', x__inp.Results.jupyterlabServerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/jupyterlab_servers/{jupyterlab_server_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.JupyterlabServerResponse.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyJupyterlabServer(obj, jupyterlabServerId, body, varargin)
            % Update a jupyterlab server
            % jupyterlabServerId (char)
            % body (JupyterlabServerModify)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('jupyterlabServerId',x__inp.UsingDefaults)), addRequired(x__inp, 'jupyterlabServerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, jupyterlabServerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.jupyterlabServerId)
                pathParams = [pathParams, 'jupyterlab_server_id', x__inp.Results.jupyterlabServerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.JupyterlabServerModify.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/jupyterlab_servers/{jupyterlab_server_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
