% ProjectsApi - 
%
% ProjectsApi Properties:
%    apiClient - ApiClient instance
%
% ProjectsApi Methods
%    addProject                             - Create a new project
%    addProjectAnalysis                     - Create an analysis and upload files.
%    addProjectAnalysisNote                 - Add a note to a(n) project analysis.
%    addProjectNote                         - Add a note to a(n) project.
%    addProjectPermission                   - Add a permission
%    addProjectRule                         - Create a new rule for a project.
%    addProjectTag                          - Add a tag to a(n) project.
%    addProjectTags                         - Add multiple tags to a(n) project
%    catalogList                            - Catalog List
%    deleteProject                          - Delete a project
%    deleteProjectAnalysis                  - Delete an analysis
%    deleteProjectAnalysisNote              - Remove a note from a(n) project analysis.
%    deleteProjectFile                      - Delete a file
%    deleteProjectNote                      - Remove a note from a(n) project
%    deleteProjectTag                       - Delete a tag
%    deleteProjectTags                      - Delete multiple tags from a(n) project
%    deleteProjectUserPermission            - Delete a permission
%    deleteProjectsByIds                    - Delete multiple projects by ID list
%    deleteProjectsByQuery                  - Delete multiple projects by query
%    downloadFileFromProject                - Download a file.
%    getProjectFileZipInfo                  - Retrieve the zip info of a child file by name.
%    getProjectDownloadTicket               - Get a signed URL to download a named child file.
%    downloadInputFromProjectAnalysis       - Download analysis inputs with filter.
%    getProjectAnalysisInputZipInfo         - Retrieve the zip info of a child file by name.
%    getProjectAnalysisInputDownloadTicket  - Get a signed URL to download a named child file.
%    downloadOutputFromProjectAnalysis      - Download analysis outputs with filter.
%    getProjectAnalysisOutputZipInfo        - Retrieve the zip info of a child file by name.
%    getProjectAnalysisOutputDownloadTicket - Get a signed URL to download a named child file.
%    endProjectPackfileUpload               - End a packfile upload
%    getAllProjects                         - Get a list of projects
%    getAllProjectsGroups                   - List all groups which have a project in them
%    getCatalogListFilterOptions            - Get all filter options for sharing a project
%    getProject                             - Get a single project
%    getProjectAcquisitions                 - List all acquisitions for the given project.
%    getProjectAnalyses                     - Get analyses for a(n) project.
%    getProjectAnalysis                     - Get an analysis.
%    getProjectFileInfo                     - Get info for a particular file.
%    getProjectNote                         - Get a note of a(n) project.
%    getProjectRule                         - Get a project rule.
%    getProjectRules                        - List all rules for a project.
%    getProjectSessions                     - List all sessions for the given project.
%    getProjectSettings                     - Get a(n) project settings
%    getProjectSubjects                     - List all subjects for the given project.
%    getProjectTag                          - Get the value of a tag, by name.
%    getProjectUserPermission               - List a user's permissions for this project.
%    modifyProject                          - Update a project
%    modifyProjectAnalysis                  - Modify an analysis.
%    modifyProjectFile                      - Modify a file's attributes
%    modifyProjectFileClassification        - Update classification for a particular file.
%    modifyProjectFileInfo                  - Update info for a particular file.
%    modifyProjectInfo                      - Update or replace info for a(n) project.
%    modifyProjectNote                      - Update a note of a(n) project.
%    modifyProjectRule                      - Update a rule on a project.
%    modifyProjectSettings                  - Modify a(n) project settings
%    modifyProjectUserPermission            - Update a user's permission for this project.
%    projectCopy                            - Copy By Reference
%    projectPackfileUpload                  - Add files to an in-progress packfile
%    recalcAllProjects                      - Recalculate all sessions against their project templates.
%    recalcProject                          - Currently does nothing--will eventually calculate if sessions in the project satisfy the template.
%    removeProjectRule                      - Remove a project rule.
%    removeProjectTemplate                  - Remove the session template for a project.
%    renameProjectTag                       - Rename a tag.
%    setProjectTemplate                     - Set the session template for a project.
%    startProjectPackfileUpload             - Start a packfile upload to project
%    uploadFileToProject                    - Upload a file to a(n) project.
%    uploadOutputToProjectAnalysis          - Upload an output file to an analysis.
%    upsertProjectHierarchy                 - Create or update subject, session and acquisition containers in the project.
classdef ProjectsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = ProjectsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addProject(obj, body, varargin)
            % Create a new project
            % body (ProjectInput)
            % inherit (logical):Inherit permissions from the group permission template
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('inherit',x__inp.UsingDefaults)), addParameter(x__inp, 'inherit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inherit)
                queryParams = [queryParams, 'inherit', flywheel.ApiClient.castParam(x__inp.Results.inherit, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectAnalysis(obj, cid, body, varargin)
            % Create an analysis and upload files.
            % cid (char)
            % body (Object)
            % job (logical):returns job_id instead of analysis.id
            % job (logical):returns job_id instead of analysis.id
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'logical')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'logical')];
            else
                queryParams = [queryParams, 'job', 'true'];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{cid}/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectAnalysisNote(obj, containerId, analysisId, body, varargin)
            % Add a note to a(n) project analysis.
            % containerId (char):24-char hex id
            % analysisId (char):24-char hex analysis id
            % body (Object):note content
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, analysisId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{container_id}/analyses/{analysis_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectNote(obj, containerId, body, varargin)
            % Add a note to a(n) project.
            % containerId (char)
            % body (NoteInput)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{container_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectPermission(obj, projectId, body, varargin)
            % Add a permission
            % projectId (char)
            % body (RolePermission)
            % xAcceptFeature (vector[Object])
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.RolePermission.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/permissions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectRule(obj, projectId, body, varargin)
            % Create a new rule for a project.
            % projectId (char)
            % body (GearRuleInput)
            % returns: [GearRuleOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.GearRuleInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/rules', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.GearRuleOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectTag(obj, cid, body, varargin)
            % Add a tag to a(n) project.
            % cid (char)
            % body (Tag)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addProjectTags(obj, cid, body, varargin)
            % Add multiple tags to a(n) project
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/projects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = catalogList(obj, varargin)
            % Catalog List
            % searchString (char):Include only results containing the search string
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('searchString',x__inp.UsingDefaults)), addParameter(x__inp, 'searchString', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.searchString)
                queryParams = [queryParams, 'search_string', flywheel.ApiClient.castParam(x__inp.Results.searchString, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/catalog-list', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProject(obj, projectId, varargin)
            % Delete a project
            % projectId (char)
            % deleteReason (ContainerDeleteReason):A reason for deletion when audit-trail is enabled
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{project_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectAnalysis(obj, cid, analysisId, varargin)
            % Delete an analysis
            % cid (char)
            % analysisId (char)
            % deleteReason (ContainerDeleteReason):Provide a reason for the deletion
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectAnalysisNote(obj, cid, analysisId, noteId, varargin)
            % Remove a note from a(n) project analysis.
            % cid (char):24-char hex id
            % analysisId (char):24-char hex analysis id
            % noteId (char):24-char hex note id
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/analyses/{analysis_id}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectFile(obj, cid, filename, varargin)
            % Delete a file
            % cid (char)
            % filename (char)
            % deleteReason (ContainerDeleteReason):A reason for deletion when audit-trail is enabled
            % force (logical):Force deletion of the file even if some checks fail. Deprecated, will be removed in a future release.
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            if (ismember('force',x__inp.UsingDefaults)), addParameter(x__inp, 'force', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end
            if ~isempty(x__inp.Results.force)
                queryParams = [queryParams, 'force', flywheel.ApiClient.castParam(x__inp.Results.force, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectNote(obj, cid, noteId, varargin)
            % Remove a note from a(n) project
            % cid (char)
            % noteId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectTag(obj, cid, value, varargin)
            % Delete a tag
            % cid (char)
            % value (char):The tag to interact with
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectTags(obj, cid, body, varargin)
            % Delete multiple tags from a(n) project
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/projects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectUserPermission(obj, projectId, uid, varargin)
            % Delete a permission
            % projectId (char)
            % uid (char)
            % xAcceptFeature (vector[Object])
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('uid',x__inp.UsingDefaults)), addRequired(x__inp, 'uid'); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, uid, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.uid)
                pathParams = [pathParams, 'uid', x__inp.Results.uid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{project_id}/permissions/{uid}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectsByIds(obj, body, varargin)
            % Delete multiple projects by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/projects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteProjectsByQuery(obj, body, varargin)
            % Delete multiple projects by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/projects/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadFileFromProject(obj, projectId, fileName, varargin)
            % Download a file.
            % projectId (char):24-character hex ID
            % fileName (char):output file name
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectFileZipInfo(obj, projectId, fileName, varargin)
            % Retrieve the zip info of a child file by name.
            % projectId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectDownloadTicket(obj, projectId, fileName, varargin)
            % Get a signed URL to download a named child file.
            % projectId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadInputFromProjectAnalysis(obj, projectId, analysisId, filename, varargin)
            % Download analysis inputs with filter.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalysisInputZipInfo(obj, projectId, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalysisInputDownloadTicket(obj, projectId, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadOutputFromProjectAnalysis(obj, projectId, analysisId, filename, varargin)
            % Download analysis outputs with filter.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalysisOutputZipInfo(obj, projectId, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):ticket id of the outputs to download
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalysisOutputDownloadTicket(obj, projectId, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % projectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):ticket id of the outputs to download
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = endProjectPackfileUpload(obj, token, metadata, fileCount, projectId, varargin)
            % End a packfile upload
            % token (char)
            % metadata (char):Metadata object as a JSON-encoded string
            % fileCount (integer):Number of files uploaded into this packfile.
            % projectId (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('token',x__inp.UsingDefaults)), addRequired(x__inp, 'token'); end
            if (ismember('metadata',x__inp.UsingDefaults)), addRequired(x__inp, 'metadata'); end
            if (ismember('fileCount',x__inp.UsingDefaults)), addRequired(x__inp, 'fileCount'); end
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, token, metadata, fileCount, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.token)
                queryParams = [queryParams, 'token', flywheel.ApiClient.castParam(x__inp.Results.token, 'char')];
            end
            if ~isempty(x__inp.Results.metadata)
                queryParams = [queryParams, 'metadata', flywheel.ApiClient.castParam(x__inp.Results.metadata, 'char')];
            end
            if ~isempty(x__inp.Results.fileCount)
                queryParams = [queryParams, 'file_count', flywheel.ApiClient.castParam(x__inp.Results.fileCount, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/packfile-end', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllProjects(obj, varargin)
            % Get a list of projects
            % counts (logical):Append the count of subjects in each project
            % stats (logical):Return the status of subjects and sessions in each project
            % joinAvatars (logical):Return the joined avatars of the permissions
            % join (JoinType)
            % exhaustive (logical):Set to return a complete list regardless of permissions
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('counts',x__inp.UsingDefaults)), addParameter(x__inp, 'counts', []); end
            if (ismember('stats',x__inp.UsingDefaults)), addParameter(x__inp, 'stats', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.counts)
                queryParams = [queryParams, 'counts', flywheel.ApiClient.castParam(x__inp.Results.counts, 'logical')];
            end
            if ~isempty(x__inp.Results.stats)
                queryParams = [queryParams, 'stats', flywheel.ApiClient.castParam(x__inp.Results.stats, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllProjectsGroups(obj, varargin)
            % List all groups which have a project in them
            % exhaustive (logical):returns exhaustive list if correct permissions
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [vector[GroupOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/groups', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.GroupOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getCatalogListFilterOptions(obj, varargin)
            % Get all filter options for sharing a project
            % returns: [SharingFilterOptions, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/catalog-list-filter-options', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SharingFilterOptions.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProject(obj, projectId, varargin)
            % Get a single project
            % projectId (char)
            % join (JoinType)
            % joinAvatars (logical):add name and avatar to notes
            % xAcceptFeature (vector[Object])
            % returns: [ProjectOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAcquisitions(obj, projectId, varargin)
            % List all acquisitions for the given project.
            % projectId (char)
            % collectionId (char)
            % exhaustive (logical)
            % join (JoinType)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('collectionId',x__inp.UsingDefaults)), addParameter(x__inp, 'collectionId', []); end
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.collectionId)
                queryParams = [queryParams, 'collection_id', flywheel.ApiClient.castParam(x__inp.Results.collectionId, 'char')];
            end
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/acquisitions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalyses(obj, cid, varargin)
            % Get analyses for a(n) project.
            % cid (char)
            % inflateJob (logical)
            % joinAvatars (logical)
            % join (JoinType)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{cid}/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectAnalysis(obj, cid, analysisId, varargin)
            % Get an analysis.
            % cid (char)
            % analysisId (char)
            % inflateJob (logical):Return job as an object instead of an id
            % joinAvatars (logical)
            % join (JoinType)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectFileInfo(obj, cid, filename, varargin)
            % Get info for a particular file.
            % cid (char):Container Id
            % filename (char)
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectNote(obj, cid, noteId, varargin)
            % Get a note of a(n) project.
            % cid (char)
            % noteId (char)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectRule(obj, projectId, ruleId, varargin)
            % Get a project rule.
            % projectId (char)
            % ruleId (char)
            % returns: [GearRuleOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('ruleId',x__inp.UsingDefaults)), addRequired(x__inp, 'ruleId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, ruleId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.ruleId)
                pathParams = [pathParams, 'rule_id', x__inp.Results.ruleId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/rules/{rule_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.GearRuleOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectRules(obj, projectId, varargin)
            % List all rules for a project.
            % projectId (char)
            % returns: [vector[GearRuleOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/rules', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.GearRuleOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectSessions(obj, projectId, varargin)
            % List all sessions for the given project.
            % projectId (char):24-char hex subject id
            % join (JoinType):join file origins
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/sessions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectSettings(obj, projectId, varargin)
            % Get a(n) project settings
            % projectId (char)
            % returns: [ProjectSettingsOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/settings', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectSettingsOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectSubjects(obj, projectId, varargin)
            % List all subjects for the given project.
            % projectId (char)
            % join (JoinType)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/subjects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectTag(obj, cid, value, varargin)
            % Get the value of a tag, by name.
            % cid (char)
            % value (char):The tag to interact with
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectUserPermission(obj, projectId, uid, varargin)
            % List a user's permissions for this project.
            % projectId (char)
            % uid (char)
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('uid',x__inp.UsingDefaults)), addRequired(x__inp, 'uid'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, uid, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.uid)
                pathParams = [pathParams, 'uid', x__inp.Results.uid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/projects/{project_id}/permissions/{uid}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProject(obj, projectId, body, varargin)
            % Update a project
            % projectId (char)
            % body (ProjectModify)
            % xAcceptFeature (vector[Object])
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectModify.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{project_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectAnalysis(obj, cid, analysisId, body, varargin)
            % Modify an analysis.
            % cid (char)
            % analysisId (char)
            % body (AnalysisModifyInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AnalysisModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectFile(obj, cid, filename, body, varargin)
            % Modify a file's attributes
            % cid (char)
            % filename (char)
            % body (FileModifyInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectFileClassification(obj, cid, filename, body, varargin)
            % Update classification for a particular file.
            % cid (char)
            % filename (char)
            % body (FileClassificationDelta)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileClassificationDelta.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/projects/{cid}/files/{filename}/classification', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectFileInfo(obj, cid, filename, body, varargin)
            % Update info for a particular file.
            % cid (char)
            % filename (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/projects/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectInfo(obj, cid, body, varargin)
            % Update or replace info for a(n) project.
            % cid (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/projects/{cid}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectNote(obj, cid, noteId, body, varargin)
            % Update a note of a(n) project.
            % cid (char)
            % noteId (char)
            % body (NoteInput)
            % returns: [integer, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.integer.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectRule(obj, projectId, ruleId, body, varargin)
            % Update a rule on a project.
            % projectId (char)
            % ruleId (char)
            % body (GearRuleModifyInput)
            % returns: [GearRuleOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('ruleId',x__inp.UsingDefaults)), addRequired(x__inp, 'ruleId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, ruleId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.ruleId)
                pathParams = [pathParams, 'rule_id', x__inp.Results.ruleId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.GearRuleModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{project_id}/rules/{rule_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.GearRuleOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectSettings(obj, projectId, body, varargin)
            % Modify a(n) project settings
            % projectId (char)
            % body (ProjectSettingsInput)
            % xAcceptFeature (vector[Object])
            % returns: [ProjectSettingsOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectSettingsInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{project_id}/settings', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectSettingsOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyProjectUserPermission(obj, projectId, uid, body, varargin)
            % Update a user's permission for this project.
            % projectId (char)
            % uid (char)
            % body (RolePermissionUpdate)
            % xAcceptFeature (vector[Object])
            % returns: [RolePermissionOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('uid',x__inp.UsingDefaults)), addRequired(x__inp, 'uid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, uid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.uid)
                pathParams = [pathParams, 'uid', x__inp.Results.uid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.RolePermissionUpdate.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{project_id}/permissions/{uid}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.RolePermissionOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = projectCopy(obj, projectId, body, varargin)
            % Copy By Reference
            % projectId (char)
            % body (ProjectCopyInput)
            % returns: [ProjectCopyOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectCopyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/copy', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectCopyOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = projectPackfileUpload(obj, projectId, token, file, varargin)
            % Add files to an in-progress packfile
            % projectId (char)
            % token (char)
            % file (vector)
            % returns: [vector[FileOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('token',x__inp.UsingDefaults)), addRequired(x__inp, 'token'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, token, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.token)
                queryParams = [queryParams, 'token', flywheel.ApiClient.castParam(x__inp.Results.token, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/packfile', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileOutput.fromJson(x, obj.context_), json);
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = recalcAllProjects(obj, varargin)
            % Recalculate all sessions against their project templates.
            % returns: [SessionTemplateRecalcOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/recalc', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SessionTemplateRecalcOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = recalcProject(obj, projectId, varargin)
            % Currently does nothing--will eventually calculate if sessions in the project satisfy the template.
            % projectId (char)
            % returns: [SessionTemplateRecalcOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/recalc', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SessionTemplateRecalcOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = removeProjectRule(obj, projectId, ruleId, varargin)
            % Remove a project rule.
            % projectId (char)
            % ruleId (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('ruleId',x__inp.UsingDefaults)), addRequired(x__inp, 'ruleId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, ruleId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end
            if ~isempty(x__inp.Results.ruleId)
                pathParams = [pathParams, 'rule_id', x__inp.Results.ruleId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{project_id}/rules/{rule_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = removeProjectTemplate(obj, projectId, varargin)
            % Remove the session template for a project.
            % projectId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/projects/{project_id}/template', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = renameProjectTag(obj, cid, value, body, varargin)
            % Rename a tag.
            % cid (char)
            % value (char):The tag to interact with
            % body (Tag)
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/projects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = setProjectTemplate(obj, projectId, body, varargin)
            % Set the session template for a project.
            % projectId (char)
            % body (ProjectTemplateListInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectTemplateListInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/template', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = startProjectPackfileUpload(obj, projectId, varargin)
            % Start a packfile upload to project
            % projectId (char)
            % returns: [UploadTokenOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/packfile-start', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.UploadTokenOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadFileToProject(obj, containerId, file, varargin)
            % Upload a file to a(n) project.
            % containerId (char)
            % file (vector):The file to upload
            % preserveMetadata (logical)
            % ticket (char)
            % id (char)
            % level (ContainerType)
            % job (char)
            % metadata (char):Metadata object as a JSON-encoded string
            % xAcceptFeature (vector[char]):redirect header
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/{container_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadOutputToProjectAnalysis(obj, cid, analysisId, file, varargin)
            % Upload an output file to an analysis.
            % cid (char)
            % analysisId (char)
            % file (vector):The file to upload
            % ticket (char)
            % id (char)
            % level (ContainerType)
            % job (char)
            % contentType (char)
            % returns: [vector[FileOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/projects/{cid}/analyses/{analysis_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = upsertProjectHierarchy(obj, projectId, body, varargin)
            % Create or update subject, session and acquisition containers in the project.
            % projectId (char)
            % body (ProjectHierarchyInput)
            % uidScope (char)
            % returns: [ProjectHierarchyOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projectId',x__inp.UsingDefaults)), addRequired(x__inp, 'projectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('uidScope',x__inp.UsingDefaults)), addParameter(x__inp, 'uidScope', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, projectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.projectId)
                pathParams = [pathParams, 'project_id', x__inp.Results.projectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.uidScope)
                queryParams = [queryParams, 'uid_scope', flywheel.ApiClient.castParam(x__inp.Results.uidScope, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ProjectHierarchyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/projects/{project_id}/upsert-hierarchy', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectHierarchyOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
