% ReportsApi - 
%
% ReportsApi Properties:
%    apiClient - ApiClient instance
%
% ReportsApi Methods
%    collectUsage         - Collect daily usage statistics.
%    getAccessLogReport   - Get a report of access log entries for the given parameters
%    getAccessLogTypes    - Get the list of types of access log entries
%    getDailyUsageReport  - Get a daily usage report for the given month.
%    getLegacyUsageReport - Get a usage report for the site grouped by month or project
%    getProjectReport     - Get project report
%    getSiteReport        - Get the site report
%    getUsageAvailability - Get year/month combinations where report data is available.
%    getUsageReport       - Get a usage report for the given month.
classdef ReportsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = ReportsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = collectUsage(obj, varargin)
            % Collect daily usage statistics.
            % year (integer):The year portion of the date
            % month (integer):The month portion of the date
            % day (integer):The day portion of the date
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('year',x__inp.UsingDefaults)), addParameter(x__inp, 'year', []); end
            if (ismember('month',x__inp.UsingDefaults)), addParameter(x__inp, 'month', []); end
            if (ismember('day',x__inp.UsingDefaults)), addParameter(x__inp, 'day', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.year)
                queryParams = [queryParams, 'year', flywheel.ApiClient.castParam(x__inp.Results.year, 'integer')];
            end
            if ~isempty(x__inp.Results.month)
                queryParams = [queryParams, 'month', flywheel.ApiClient.castParam(x__inp.Results.month, 'integer')];
            end
            if ~isempty(x__inp.Results.day)
                queryParams = [queryParams, 'day', flywheel.ApiClient.castParam(x__inp.Results.day, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/usage/collect', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAccessLogReport(obj, varargin)
            % Get a report of access log entries for the given parameters
            % csv (logical):Set to download a csv file instead of json
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return
            % skip (integer):The number of entries to skip
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % startDate (datetime):An ISO formatted timestamp for the start time of the report
            % endDate (datetime):An ISO formatted timestamp for the end time of the report
            % user (char):User id of the target user
            % subject (char):Limit the report to the subject code of subject accessed
            % project (char):Limit the report to the project id
            % accessTypes (vector[AccessType]):The list of access_types to filter logs
            % xAcceptFeature (vector[char])
            % returns: [vector[ReportAccessLogEntry], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('csv',x__inp.UsingDefaults)), addParameter(x__inp, 'csv', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('startDate',x__inp.UsingDefaults)), addParameter(x__inp, 'startDate', []); end
            if (ismember('endDate',x__inp.UsingDefaults)), addParameter(x__inp, 'endDate', []); end
            if (ismember('user',x__inp.UsingDefaults)), addParameter(x__inp, 'user', []); end
            if (ismember('subject',x__inp.UsingDefaults)), addParameter(x__inp, 'subject', []); end
            if (ismember('project',x__inp.UsingDefaults)), addParameter(x__inp, 'project', []); end
            if (ismember('accessTypes',x__inp.UsingDefaults)), addParameter(x__inp, 'accessTypes', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.csv)
                queryParams = [queryParams, 'csv', flywheel.ApiClient.castParam(x__inp.Results.csv, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end
            if ~isempty(x__inp.Results.startDate)
                queryParams = [queryParams, 'start_date', flywheel.ApiClient.castParam(x__inp.Results.startDate, 'datetime')];
            end
            if ~isempty(x__inp.Results.endDate)
                queryParams = [queryParams, 'end_date', flywheel.ApiClient.castParam(x__inp.Results.endDate, 'datetime')];
            end
            if ~isempty(x__inp.Results.user)
                queryParams = [queryParams, 'user', flywheel.ApiClient.castParam(x__inp.Results.user, 'char')];
            end
            if ~isempty(x__inp.Results.subject)
                queryParams = [queryParams, 'subject', flywheel.ApiClient.castParam(x__inp.Results.subject, 'char')];
            end
            if ~isempty(x__inp.Results.project)
                queryParams = [queryParams, 'project', flywheel.ApiClient.castParam(x__inp.Results.project, 'char')];
            end
            if ~isempty(x__inp.Results.accessTypes)
                queryParams = flywheel.ApiClient.formatParamCollection(queryParams, 'access_types', x__inp.Results.accessTypes, 'multi');
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/accesslog', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.ReportAccessLogEntry.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAccessLogTypes(obj, varargin)
            % Get the list of types of access log entries
            % returns: [vector[char], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/accesslog/types', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.fromJson(x, obj.context_), json);
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getDailyUsageReport(obj, varargin)
            % Get a daily usage report for the given month.
            % year (integer):The year portion of the date
            % month (integer):The month portion of the date
            % group (char):Limit the report to the given group id
            % project (char):Limit the report to the given project id
            % returns: [vector[DailyReportUsage], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('year',x__inp.UsingDefaults)), addParameter(x__inp, 'year', []); end
            if (ismember('month',x__inp.UsingDefaults)), addParameter(x__inp, 'month', []); end
            if (ismember('group',x__inp.UsingDefaults)), addParameter(x__inp, 'group', []); end
            if (ismember('project',x__inp.UsingDefaults)), addParameter(x__inp, 'project', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.year)
                queryParams = [queryParams, 'year', flywheel.ApiClient.castParam(x__inp.Results.year, 'integer')];
            end
            if ~isempty(x__inp.Results.month)
                queryParams = [queryParams, 'month', flywheel.ApiClient.castParam(x__inp.Results.month, 'integer')];
            end
            if ~isempty(x__inp.Results.group)
                queryParams = [queryParams, 'group', flywheel.ApiClient.castParam(x__inp.Results.group, 'char')];
            end
            if ~isempty(x__inp.Results.project)
                queryParams = [queryParams, 'project', flywheel.ApiClient.castParam(x__inp.Results.project, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/daily-usage', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.DailyReportUsage.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getLegacyUsageReport(obj, type, varargin)
            % Get a usage report for the site grouped by month or project
            % type (char):The type of usage report to generate
            % startDate (datetime):An ISO formatted timestamp for the start time of the report
            % endDate (datetime):An ISO formatted timestamp for the end time of the report
            % returns: [vector[LegacyUsageReport], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('type',x__inp.UsingDefaults)), addRequired(x__inp, 'type'); end
            if (ismember('startDate',x__inp.UsingDefaults)), addParameter(x__inp, 'startDate', []); end
            if (ismember('endDate',x__inp.UsingDefaults)), addParameter(x__inp, 'endDate', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, type, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.type)
                queryParams = [queryParams, 'type', flywheel.ApiClient.castParam(x__inp.Results.type, 'char')];
            end
            if ~isempty(x__inp.Results.startDate)
                queryParams = [queryParams, 'start_date', flywheel.ApiClient.castParam(x__inp.Results.startDate, 'datetime')];
            end
            if ~isempty(x__inp.Results.endDate)
                queryParams = [queryParams, 'end_date', flywheel.ApiClient.castParam(x__inp.Results.endDate, 'datetime')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/legacy-usage', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.LegacyUsageReport.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getProjectReport(obj, varargin)
            % Get project report
            % projects (vector[char]):Specify multiple times to include projects in the report
            % startDate (datetime):Report start date
            % endDate (datetime):Report end date
            % returns: [ProjectReportList, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('projects',x__inp.UsingDefaults)), addParameter(x__inp, 'projects', []); end
            if (ismember('startDate',x__inp.UsingDefaults)), addParameter(x__inp, 'startDate', []); end
            if (ismember('endDate',x__inp.UsingDefaults)), addParameter(x__inp, 'endDate', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.projects)
                queryParams = flywheel.ApiClient.formatParamCollection(queryParams, 'projects', x__inp.Results.projects, 'multi');
            end
            if ~isempty(x__inp.Results.startDate)
                queryParams = [queryParams, 'start_date', flywheel.ApiClient.castParam(x__inp.Results.startDate, 'datetime')];
            end
            if ~isempty(x__inp.Results.endDate)
                queryParams = [queryParams, 'end_date', flywheel.ApiClient.castParam(x__inp.Results.endDate, 'datetime')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/project', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ProjectReportList.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSiteReport(obj, varargin)
            % Get the site report
            % returns: [SiteReport, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/site', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SiteReport.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getUsageAvailability(obj, varargin)
            % Get year/month combinations where report data is available.
            % returns: [ReportAvailabilityList, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/usage/availability', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ReportAvailabilityList.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getUsageReport(obj, varargin)
            % Get a usage report for the given month.
            % year (integer):The year portion of the date
            % month (integer):The month portion of the date
            % project (char):Project to filter to
            % returns: [vector[ReportUsage], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('year',x__inp.UsingDefaults)), addParameter(x__inp, 'year', []); end
            if (ismember('month',x__inp.UsingDefaults)), addParameter(x__inp, 'month', []); end
            if (ismember('project',x__inp.UsingDefaults)), addParameter(x__inp, 'project', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.year)
                queryParams = [queryParams, 'year', flywheel.ApiClient.castParam(x__inp.Results.year, 'integer')];
            end
            if ~isempty(x__inp.Results.month)
                queryParams = [queryParams, 'month', flywheel.ApiClient.castParam(x__inp.Results.month, 'integer')];
            end
            if ~isempty(x__inp.Results.project)
                queryParams = [queryParams, 'project', flywheel.ApiClient.castParam(x__inp.Results.project, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/report/usage', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.ReportUsage.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
