% ResolveApi - 
%
% ResolveApi Properties:
%    apiClient - ApiClient instance
%
% ResolveApi Methods
%    lookupPath  - Perform path based lookup of a single node in the Flywheel hierarchy
%    resolvePath - Perform path based lookup of nodes in the Flywheel hierarchy
classdef ResolveApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = ResolveApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = lookupPath(obj, body, varargin)
            % Perform path based lookup of a single node in the Flywheel hierarchy
            % body (ResolveInput)
            % fullTree (logical)
            % exhaustive (logical)
            % returns: [ResolverNode, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('fullTree',x__inp.UsingDefaults)), addParameter(x__inp, 'fullTree', []); end
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.fullTree)
                queryParams = [queryParams, 'full_tree', flywheel.ApiClient.castParam(x__inp.Results.fullTree, 'logical')];
            end
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ResolveInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/lookup', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ResolverNode.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = resolvePath(obj, body, varargin)
            % Perform path based lookup of nodes in the Flywheel hierarchy
            % body (ResolveInput)
            % fullTree (logical):Parse full download style paths (e.g. group/PROJECTS/project_label/SUBJECTS/...)
            % minattr (logical):Return only minimal attributes
            % exhaustive (logical):Set to return a complete list regardless of permissions
            % returns: [ResolveOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('fullTree',x__inp.UsingDefaults)), addParameter(x__inp, 'fullTree', []); end
            if (ismember('minattr',x__inp.UsingDefaults)), addParameter(x__inp, 'minattr', []); end
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.fullTree)
                queryParams = [queryParams, 'full_tree', flywheel.ApiClient.castParam(x__inp.Results.fullTree, 'logical')];
            end
            if ~isempty(x__inp.Results.minattr)
                queryParams = [queryParams, 'minattr', flywheel.ApiClient.castParam(x__inp.Results.minattr, 'logical')];
            end
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ResolveInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/resolve', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ResolveOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
