% SubjectsApi - 
%
% SubjectsApi Properties:
%    apiClient - ApiClient instance
%
% SubjectsApi Methods
%    addSubject                             - Create a new subject
%    addSubjectAnalysis                     - Create an analysis and upload files.
%    addSubjectAnalysisNote                 - Add a note to a(n) subject analysis.
%    addSubjectNote                         - Add a note to a(n) subject.
%    addSubjectTag                          - Add a tag to a(n) subject.
%    addSubjectTags                         - Add multiple tags to a(n) subject
%    createMasterSubjectCode                - Request a master subject code for the given patient
%    deleteSubject                          - Delete a subject
%    deleteSubjectAnalysis                  - Delete an analysis
%    deleteSubjectAnalysisNote              - Remove a note from a(n) subject analysis.
%    deleteSubjectFile                      - Delete a file
%    deleteSubjectNote                      - Remove a note from a(n) subject
%    deleteSubjectTag                       - Delete a tag
%    deleteSubjectTags                      - Delete multiple tags from a(n) subject
%    deleteSubjectsByIds                    - Delete multiple subjects by ID list
%    deleteSubjectsByQuery                  - Delete multiple subjects by query
%    downloadFileFromSubject                - Download a file.
%    getSubjectFileZipInfo                  - Retrieve the zip info of a child file by name.
%    getSubjectDownloadTicket               - Get a signed URL to download a named child file.
%    downloadInputFromSubjectAnalysis       - Download analysis inputs with filter.
%    getSubjectAnalysisInputZipInfo         - Retrieve the zip info of a child file by name.
%    getSubjectAnalysisInputDownloadTicket  - Get a signed URL to download a named child file.
%    downloadOutputFromSubjectAnalysis      - Download analysis outputs with filter.
%    getSubjectAnalysisOutputZipInfo        - Retrieve the zip info of a child file by name.
%    getSubjectAnalysisOutputDownloadTicket - Get a signed URL to download a named child file.
%    getAllSubjects                         - Get a list of subjects
%    getSubject                             - Get a single subject
%    getSubjectAnalyses                     - Get analyses for a(n) subject.
%    getSubjectAnalysis                     - Get an analysis.
%    getSubjectFileInfo                     - Get info for a particular file.
%    getSubjectNote                         - Get a note of a(n) subject.
%    getSubjectSessions                     - List sessions of a subject
%    getSubjectTag                          - Get the value of a tag, by name.
%    modifySubject                          - Update a subject
%    modifySubjectAnalysis                  - Modify an analysis.
%    modifySubjectFile                      - Modify a file's attributes
%    modifySubjectFileClassification        - Update classification for a particular file.
%    modifySubjectFileInfo                  - Update info for a particular file.
%    modifySubjectInfo                      - Update or replace info for a(n) subject.
%    modifySubjectNote                      - Update a note of a(n) subject.
%    renameSubjectTag                       - Rename a tag.
%    uploadFileToSubject                    - Upload a file to a(n) subject.
%    uploadOutputToSubjectAnalysis          - Upload an output file to an analysis.
%    verifyMasterSubjectCode                - Verify that the given master subject code exists or not
classdef SubjectsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = SubjectsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = addSubject(obj, body, varargin)
            % Create a new subject
            % body (Object):subject object to create
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addSubjectAnalysis(obj, cid, body, varargin)
            % Create an analysis and upload files.
            % cid (char)
            % body (Object)
            % job (logical):returns job_id instead of analysis.id
            % job (logical):returns job_id instead of analysis.id
            % returns: [InsertedId, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'logical')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'logical')];
            else
                queryParams = [queryParams, 'job', 'true'];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects/{cid}/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.InsertedId.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addSubjectAnalysisNote(obj, containerId, analysisId, body, varargin)
            % Add a note to a(n) subject analysis.
            % containerId (char):24-char hex id
            % analysisId (char):24-char hex analysis id
            % body (Object):note content
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, analysisId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects/{container_id}/analyses/{analysis_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addSubjectNote(obj, containerId, body, varargin)
            % Add a note to a(n) subject.
            % containerId (char)
            % body (NoteInput)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects/{container_id}/notes', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addSubjectTag(obj, cid, body, varargin)
            % Add a tag to a(n) subject.
            % cid (char)
            % body (Tag)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = addSubjectTags(obj, cid, body, varargin)
            % Add multiple tags to a(n) subject
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/subjects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = createMasterSubjectCode(obj, body, varargin)
            % Request a master subject code for the given patient
            % body (Object)
            % returns: [MasterSubjectCodeOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/subjects/master-code', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.MasterSubjectCodeOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubject(obj, subjectId, varargin)
            % Delete a subject
            % subjectId (char):24-char hex subject id
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{subject_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectAnalysis(obj, cid, analysisId, varargin)
            % Delete an analysis
            % cid (char)
            % analysisId (char)
            % deleteReason (ContainerDeleteReason):Provide a reason for the deletion
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectAnalysisNote(obj, cid, analysisId, noteId, varargin)
            % Remove a note from a(n) subject analysis.
            % cid (char):24-char hex id
            % analysisId (char):24-char hex analysis id
            % noteId (char):24-char hex note id
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/analyses/{analysis_id}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectFile(obj, cid, filename, varargin)
            % Delete a file
            % cid (char)
            % filename (char)
            % deleteReason (ContainerDeleteReason):A reason for deletion when audit-trail is enabled
            % force (logical):Force deletion of the file even if some checks fail. Deprecated, will be removed in a future release.
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            if (ismember('force',x__inp.UsingDefaults)), addParameter(x__inp, 'force', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end
            if ~isempty(x__inp.Results.force)
                queryParams = [queryParams, 'force', flywheel.ApiClient.castParam(x__inp.Results.force, 'logical')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectNote(obj, cid, noteId, varargin)
            % Remove a note from a(n) subject
            % cid (char)
            % noteId (char)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectTag(obj, cid, value, varargin)
            % Delete a tag
            % cid (char)
            % value (char):The tag to interact with
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectTags(obj, cid, body, varargin)
            % Delete multiple tags from a(n) subject
            % cid (char)
            % body (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/subjects/{cid}/tags', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectsByIds(obj, body, varargin)
            % Delete multiple subjects by ID list
            % body (vector[char]):List of IDs to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.char.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/subjects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteSubjectsByQuery(obj, body, varargin)
            % Delete multiple subjects by query
            % body (vector[Filter]):Query for containers to delete
            % deleteReason (ContainerDeleteReason)
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('deleteReason',x__inp.UsingDefaults)), addParameter(x__inp, 'deleteReason', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.deleteReason)
                queryParams = [queryParams, 'delete_reason', flywheel.ApiClient.castParam(x__inp.Results.deleteReason, 'ContainerDeleteReason')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.ModelBase.cellmap(@(x) flywheel.model.Filter.ensureIsInstance(x), x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('DELETE', '/subjects/delete_by_query', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadFileFromSubject(obj, subjectId, fileName, varargin)
            % Download a file.
            % subjectId (char):24-character hex ID
            % fileName (char):output file name
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectFileZipInfo(obj, subjectId, fileName, varargin)
            % Retrieve the zip info of a child file by name.
            % subjectId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectDownloadTicket(obj, subjectId, fileName, varargin)
            % Get a signed URL to download a named child file.
            % subjectId (char):24-character hex ID
            % fileName (char):output file name
            % ticket (char):The generated ticket id for the download, or present but empty to generate a ticket id
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):If true, the proper \"Content-Type\" header based on the file's mimetype is set on response If false, the \"Content-Type\" header is set to \"application/octet-stream\" 
            % version (integer):version of the file to download
            % hash (char):file hash for comparison
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('fileName',x__inp.UsingDefaults)), addRequired(x__inp, 'fileName'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('version',x__inp.UsingDefaults)), addParameter(x__inp, 'version', []); end
            if (ismember('hash',x__inp.UsingDefaults)), addParameter(x__inp, 'hash', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, fileName, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.fileName)
                pathParams = [pathParams, 'file_name', x__inp.Results.fileName];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end
            if ~isempty(x__inp.Results.version)
                queryParams = [queryParams, 'version', flywheel.ApiClient.castParam(x__inp.Results.version, 'integer')];
            end
            if ~isempty(x__inp.Results.hash)
                queryParams = [queryParams, 'hash', flywheel.ApiClient.castParam(x__inp.Results.hash, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/files/{file_name}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadInputFromSubjectAnalysis(obj, subjectId, analysisId, filename, varargin)
            % Download analysis inputs with filter.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalysisInputZipInfo(obj, subjectId, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalysisInputDownloadTicket(obj, subjectId, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):24-char hex ticket id
            % info (logical):get file info only
            % member (char):get zipfile member
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/inputs/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = downloadOutputFromSubjectAnalysis(obj, subjectId, analysisId, filename, varargin)
            % Download analysis outputs with filter.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % destFile - Destination file path
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addRequired(x__inp, 'destFile');
            addParameter(x__inp, 'OutputType', 'double');
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    destFile = x__inp.Results.destFile;
                    if ~isempty(destFile)
                        resp.saveResponseBodyToFile(destFile);
                        returnData = destFile;
                    else
                        returnData = resp.getBodyData(x__inp.Results.OutputType);
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalysisOutputZipInfo(obj, subjectId, analysisId, filename, varargin)
            % Retrieve the zip info of a child file by name.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):ticket id of the outputs to download
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [FileZipInfo, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            else
                queryParams = [queryParams, 'info', 'true'];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileZipInfo.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalysisOutputDownloadTicket(obj, subjectId, analysisId, filename, varargin)
            % Get a signed URL to download a named child file.
            % subjectId (char):24-character hex ID
            % analysisId (char):24-char hex analysis id
            % filename (char):filename to download (get tar of all if empty)
            % ticket (char):ticket id of the outputs to download
            % info (logical):If the file is a zipfile, return a json response of zipfile member information
            % member (char):The filename of a zipfile member to download rather than the entire file
            % view (logical):feature flag for view/download
            % range (char):byte ranges to return
            % xAcceptFeature (vector[char]):redirect header
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('info',x__inp.UsingDefaults)), addParameter(x__inp, 'info', []); end
            if (ismember('member',x__inp.UsingDefaults)), addParameter(x__inp, 'member', []); end
            if (ismember('view',x__inp.UsingDefaults)), addParameter(x__inp, 'view', []); end
            if (ismember('range',x__inp.UsingDefaults)), addParameter(x__inp, 'range', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, analysisId, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.info)
                queryParams = [queryParams, 'info', flywheel.ApiClient.castParam(x__inp.Results.info, 'logical')];
            end
            if ~isempty(x__inp.Results.member)
                queryParams = [queryParams, 'member', flywheel.ApiClient.castParam(x__inp.Results.member, 'char')];
            end
            if ~isempty(x__inp.Results.view)
                queryParams = [queryParams, 'view', flywheel.ApiClient.castParam(x__inp.Results.view, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.range)
                headers = [headers, 'range', x__inp.Results.range];
            end
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/analyses/{analysis_id}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getAllSubjects(obj, varargin)
            % Get a list of subjects
            % exhaustive (logical):Set to return a complete list regardless of permissions
            % join (JoinType):join file origins
            % joinAvatars (logical):add name and avatar to notes
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('exhaustive',x__inp.UsingDefaults)), addParameter(x__inp, 'exhaustive', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.exhaustive)
                queryParams = [queryParams, 'exhaustive', flywheel.ApiClient.castParam(x__inp.Results.exhaustive, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubject(obj, subjectId, varargin)
            % Get a single subject
            % subjectId (char):24-char hex subject id
            % join (JoinType):join file origins
            % joinAvatars (logical):add name and avatar to notes
            % xAcceptFeature (vector[Object])
            % returns: [SubjectOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SubjectOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalyses(obj, cid, varargin)
            % Get analyses for a(n) subject.
            % cid (char)
            % inflateJob (logical)
            % joinAvatars (logical)
            % join (JoinType)
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[char])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{cid}/analyses', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectAnalysis(obj, cid, analysisId, varargin)
            % Get an analysis.
            % cid (char)
            % analysisId (char)
            % inflateJob (logical):Return job as an object instead of an id
            % joinAvatars (logical)
            % join (JoinType)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('inflateJob',x__inp.UsingDefaults)), addParameter(x__inp, 'inflateJob', []); end
            if (ismember('joinAvatars',x__inp.UsingDefaults)), addParameter(x__inp, 'joinAvatars', []); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.inflateJob)
                queryParams = [queryParams, 'inflate_job', flywheel.ApiClient.castParam(x__inp.Results.inflateJob, 'logical')];
            end
            if ~isempty(x__inp.Results.joinAvatars)
                queryParams = [queryParams, 'join_avatars', flywheel.ApiClient.castParam(x__inp.Results.joinAvatars, 'logical')];
            end
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectFileInfo(obj, cid, filename, varargin)
            % Get info for a particular file.
            % cid (char):Container Id
            % filename (char)
            % returns: [FileOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.FileOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectNote(obj, cid, noteId, varargin)
            % Get a note of a(n) subject.
            % cid (char)
            % noteId (char)
            % returns: [Note, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Note.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectSessions(obj, subjectId, varargin)
            % List sessions of a subject
            % subjectId (char):24-char hex subject id
            % join (JoinType):join file origins
            % includeAllInfo (logical):Include all info in returned objects
            % filter (char):The filter to apply. (e.g. label=my-label,created>2018-09-22)
            % sort (char):The sort fields and order. (e.g. label:asc,created:desc)
            % limit (integer):The maximum number of entries to return.
            % skip (integer):The number of entries to skip.
            % page (integer):The page number (i.e. skip limit*page entries)
            % afterId (char):Paginate after the given id. (Cannot be used with sort, page or skip)
            % xAcceptFeature (vector[Object])
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('join',x__inp.UsingDefaults)), addParameter(x__inp, 'join', []); end
            if (ismember('includeAllInfo',x__inp.UsingDefaults)), addParameter(x__inp, 'includeAllInfo', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('page',x__inp.UsingDefaults)), addParameter(x__inp, 'page', []); end
            if (ismember('afterId',x__inp.UsingDefaults)), addParameter(x__inp, 'afterId', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.join)
                queryParams = [queryParams, 'join', flywheel.ApiClient.castParam(x__inp.Results.join, 'JoinType')];
            end
            if ~isempty(x__inp.Results.includeAllInfo)
                queryParams = [queryParams, 'include_all_info', flywheel.ApiClient.castParam(x__inp.Results.includeAllInfo, 'logical')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.page)
                queryParams = [queryParams, 'page', flywheel.ApiClient.castParam(x__inp.Results.page, 'integer')];
            end
            if ~isempty(x__inp.Results.afterId)
                queryParams = [queryParams, 'after_id', flywheel.ApiClient.castParam(x__inp.Results.afterId, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{subject_id}/sessions', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getSubjectTag(obj, cid, value, varargin)
            % Get the value of a tag, by name.
            % cid (char)
            % value (char):The tag to interact with
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubject(obj, subjectId, body, varargin)
            % Update a subject
            % subjectId (char):24-char hex subject id
            % body (Object):subject object to modify
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('subjectId',x__inp.UsingDefaults)), addRequired(x__inp, 'subjectId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, subjectId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.subjectId)
                pathParams = [pathParams, 'subject_id', x__inp.Results.subjectId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model..ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/subjects/{subject_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectAnalysis(obj, cid, analysisId, body, varargin)
            % Modify an analysis.
            % cid (char)
            % analysisId (char)
            % body (AnalysisModifyInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.AnalysisModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/subjects/{cid}/analyses/{analysis_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectFile(obj, cid, filename, body, varargin)
            % Modify a file's attributes
            % cid (char)
            % filename (char)
            % body (FileModifyInput)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileModifyInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/subjects/{cid}/files/{filename}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectFileClassification(obj, cid, filename, body, varargin)
            % Update classification for a particular file.
            % cid (char)
            % filename (char)
            % body (FileClassificationDelta)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.FileClassificationDelta.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/subjects/{cid}/files/{filename}/classification', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectFileInfo(obj, cid, filename, body, varargin)
            % Update info for a particular file.
            % cid (char)
            % filename (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('filename',x__inp.UsingDefaults)), addRequired(x__inp, 'filename'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, filename, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.filename)
                pathParams = [pathParams, 'filename', x__inp.Results.filename];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/subjects/{cid}/files/{filename}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectInfo(obj, cid, body, varargin)
            % Update or replace info for a(n) subject.
            % cid (char)
            % body (Info)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Info.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PATCH', '/subjects/{cid}/info', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifySubjectNote(obj, cid, noteId, body, varargin)
            % Update a note of a(n) subject.
            % cid (char)
            % noteId (char)
            % body (NoteInput)
            % returns: [integer, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('noteId',x__inp.UsingDefaults)), addRequired(x__inp, 'noteId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, noteId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.noteId)
                pathParams = [pathParams, 'note_id', x__inp.Results.noteId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.NoteInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/subjects/{cid}/notes/{note_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.integer.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = renameSubjectTag(obj, cid, value, body, varargin)
            % Rename a tag.
            % cid (char)
            % value (char):The tag to interact with
            % body (Tag)
            % returns: [char, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('value',x__inp.UsingDefaults)), addRequired(x__inp, 'value'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, value, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.value)
                pathParams = [pathParams, 'value', x__inp.Results.value];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.Tag.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/subjects/{cid}/tags/{value}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.char.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadFileToSubject(obj, containerId, file, varargin)
            % Upload a file to a(n) subject.
            % containerId (char)
            % file (vector):The file to upload
            % preserveMetadata (logical)
            % ticket (char)
            % id (char)
            % level (ContainerType)
            % job (char)
            % metadata (char):Metadata object as a JSON-encoded string
            % xAcceptFeature (vector[char]):redirect header
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('xAcceptFeature',x__inp.UsingDefaults)), addParameter(x__inp, 'xAcceptFeature', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.containerId)
                pathParams = [pathParams, 'container_id', x__inp.Results.containerId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.xAcceptFeature)
                headers = flywheel.ApiClient.formatParamCollection(headers, 'x-accept-feature', x__inp.Results.xAcceptFeature, '');
            end
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/subjects/{container_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadOutputToSubjectAnalysis(obj, cid, analysisId, file, varargin)
            % Upload an output file to an analysis.
            % cid (char)
            % analysisId (char)
            % file (vector):The file to upload
            % ticket (char)
            % id (char)
            % level (ContainerType)
            % job (char)
            % contentType (char)
            % returns: [vector[FileOutput], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('cid',x__inp.UsingDefaults)), addRequired(x__inp, 'cid'); end
            if (ismember('analysisId',x__inp.UsingDefaults)), addRequired(x__inp, 'analysisId'); end
            if (ismember('file',x__inp.UsingDefaults)), addRequired(x__inp, 'file'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, cid, analysisId, file, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.cid)
                pathParams = [pathParams, 'cid', x__inp.Results.cid];
            end
            if ~isempty(x__inp.Results.analysisId)
                pathParams = [pathParams, 'analysis_id', x__inp.Results.analysisId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.file)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.file)];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/subjects/{cid}/analyses/{analysis_id}/files', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileOutput.fromJson(x, obj.context_), json);
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = verifyMasterSubjectCode(obj, code, varargin)
            % Verify that the given master subject code exists or not
            % code (char):code id
            % returns: [MasterSubjectCodeOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('code',x__inp.UsingDefaults)), addRequired(x__inp, 'code'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, code, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.code)
                pathParams = [pathParams, 'code', x__inp.Results.code];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/subjects/master-code/{code}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.MasterSubjectCodeOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
