% UploadApi - 
%
% UploadApi Properties:
%    apiClient - ApiClient instance
%
% UploadApi Methods
%    cleanupSignedUploadUrl    - Cleanup unused file blob previously uploaded using signed URL
%    completeS3MultipartUpload - Complete S3 multipart signed url upload
%    createSignedUploadUrl     - Create new signed upload URL
%    uploadByLabel             - Multipart form upload with N file fields, each with their desired filename.
%    uploadByReaper            - Bottom-up UID matching of Multipart form upload with N file fields, each with their desired filename.
%    uploadByUid               - Multipart form upload with N file fields, each with their desired filename.
%    uploadSignedFsFile        - Upload file to local filesystem storage provider
classdef UploadApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = UploadApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = cleanupSignedUploadUrl(obj, body, varargin)
            % Cleanup unused file blob previously uploaded using signed URL
            % body (SignedUrlCleanupInput)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.SignedUrlCleanupInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/upload/signed-url/cleanup', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = completeS3MultipartUpload(obj, body, varargin)
            % Complete S3 multipart signed url upload
            % body (CompleteS3MultipartUploadInput)
            % returns: [CompleteMultipartUploadOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.CompleteS3MultipartUploadInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/upload/complete-s3-multipart', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.CompleteMultipartUploadOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = createSignedUploadUrl(obj, body, varargin)
            % Create new signed upload URL
            % body (SignedUrlUploadInput)
            % returns: [SignedUrlUploadOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.SignedUrlUploadInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/upload/signed-url', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SignedUrlUploadOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadByLabel(obj, varargin)
            % Multipart form upload with N file fields, each with their desired filename.
            % preserveMetadata (logical)
            % ticket (char):Use empty value to get a ticket, and provide the ticket id to finalize the upload
            % id (char)
            % level (ContainerType)
            % job (char)
            % files (vector)
            % metadata (containers.Map):Metadata object
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('files',x__inp.UsingDefaults)), addParameter(x__inp, 'files', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.files)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.files)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/upload/label', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadByReaper(obj, varargin)
            % Bottom-up UID matching of Multipart form upload with N file fields, each with their desired filename.
            % preserveMetadata (logical)
            % ticket (char):Use empty value to get a ticket, and provide the ticket id to finalize the upload
            % uidPlacement (logical)
            % id (char)
            % level (ContainerType)
            % job (char)
            % files (vector)
            % metadata (containers.Map):Metadata object
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('uidPlacement',x__inp.UsingDefaults)), addParameter(x__inp, 'uidPlacement', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('files',x__inp.UsingDefaults)), addParameter(x__inp, 'files', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.uidPlacement)
                queryParams = [queryParams, 'uid_placement', flywheel.ApiClient.castParam(x__inp.Results.uidPlacement, 'logical')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.files)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.files)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/upload/reaper', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadByUid(obj, varargin)
            % Multipart form upload with N file fields, each with their desired filename.
            % preserveMetadata (logical)
            % ticket (char):Use empty value to get a ticket, and provide the ticket id to finalize the upload
            % id (char)
            % level (ContainerType)
            % job (char)
            % files (vector)
            % metadata (containers.Map):Metadata object
            % contentType (char)
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('preserveMetadata',x__inp.UsingDefaults)), addParameter(x__inp, 'preserveMetadata', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('id',x__inp.UsingDefaults)), addParameter(x__inp, 'id', []); end
            if (ismember('level',x__inp.UsingDefaults)), addParameter(x__inp, 'level', []); end
            if (ismember('job',x__inp.UsingDefaults)), addParameter(x__inp, 'job', []); end
            if (ismember('files',x__inp.UsingDefaults)), addParameter(x__inp, 'files', []); end
            if (ismember('metadata',x__inp.UsingDefaults)), addParameter(x__inp, 'metadata', []); end
            if (ismember('contentType',x__inp.UsingDefaults)), addParameter(x__inp, 'contentType', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.preserveMetadata)
                queryParams = [queryParams, 'preserve_metadata', flywheel.ApiClient.castParam(x__inp.Results.preserveMetadata, 'logical')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.id)
                queryParams = [queryParams, 'id', flywheel.ApiClient.castParam(x__inp.Results.id, 'char')];
            end
            if ~isempty(x__inp.Results.level)
                queryParams = [queryParams, 'level', flywheel.ApiClient.castParam(x__inp.Results.level, 'ContainerType')];
            end
            if ~isempty(x__inp.Results.job)
                queryParams = [queryParams, 'job', flywheel.ApiClient.castParam(x__inp.Results.job, 'char')];
            end

            % Header parameters
            headers = {};
            if ~isempty(x__inp.Results.contentType)
                headers = [headers, 'content-type', x__inp.Results.contentType];
            end

            % Form parameters
            formParams = {};
            files = {};
            if ~isempty(x__inp.Results.files)
                files = [files, flywheel.FileSpec.parametrize(x__inp.Results.files)];
            end
            if ~isempty(x__inp.Results.metadata)
                formParams = [formParams, 'metadata', x__inp.Results.metadata];
            end

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/upload/uid', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.Object.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = uploadSignedFsFile(obj, token, body, varargin)
            % Upload file to local filesystem storage provider
            % token (char):Upload token
            % body (vector):Signed filesystem file upload payload
            % returns: [SignedFSUploadOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('token',x__inp.UsingDefaults)), addRequired(x__inp, 'token'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, token, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.token)
                queryParams = [queryParams, 'token', flywheel.ApiClient.castParam(x__inp.Results.token, 'char')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = x__inp.Results.body;
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/upload/fs-file', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.SignedFSUploadOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
