% ViewsApi - 
%
% ViewsApi Properties:
%    apiClient - ApiClient instance
%
% ViewsApi Methods
%    dataViewColumns         - Return a list of all known column aliases for use in data views
%    deleteView              - Delete a data view
%    evaluateView            - Execute a view, returning data in the preferred format.
%    evaluateViewAdhoc       - Execute an ad-hoc view, returning data in the preferred format.
%    getView                 - Return the view identified by ViewId
%    modifyView              - Update the view identified by ViewId
%    queueAdhoc              - Execute an ad-hoc view, returning a reference to the created data view execution.
%    queueSaved              - Execute a view, returning a reference to the created data view execution.
%    saveViewDataToContainer - Execute a view, saving data to the target container / file
classdef ViewsApi < handle
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties
        apiClient
        context_
    end
    methods
        function obj = ViewsApi(apiClient, context)
            obj.apiClient = apiClient;
            obj.context_ = context;
        end

        function [returnData, resp] = dataViewColumns(obj, varargin)
            % Return a list of all known column aliases for use in data views
            % returns: [vector[DataViewColumnAlias], resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/views/columns', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.ModelBase.cellmap(@(x) flywheel.model.DataViewColumnAlias.fromJson(x, obj.context_), json);
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = deleteView(obj, viewId, varargin)
            % Delete a data view
            % viewId (char):The ID of the view
            % returns: [DeletedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('viewId',x__inp.UsingDefaults)), addRequired(x__inp, 'viewId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, viewId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.viewId)
                pathParams = [pathParams, 'view_id', x__inp.Results.viewId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('DELETE', '/views/{view_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DeletedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = evaluateView(obj, viewId, containerId, varargin)
            % Execute a view, returning data in the preferred format.
            % viewId (char):The ID of the view
            % containerId (char):The target container for view execution
            % ticket (char):download ticket id
            % filename (char):download ticket filename
            % format (Object):Available values : csv, tsv, json, ndjson, json_flat, json-row-column
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % filter (char):An optional filter expression
            % skip (integer):The optional number of rows to skip
            % limit (integer):The optional max number of rows to return
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('viewId',x__inp.UsingDefaults)), addRequired(x__inp, 'viewId'); end
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('filename',x__inp.UsingDefaults)), addParameter(x__inp, 'filename', []); end
            if (ismember('format',x__inp.UsingDefaults)), addParameter(x__inp, 'format', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, viewId, containerId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.viewId)
                pathParams = [pathParams, 'view_id', x__inp.Results.viewId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.containerId)
                queryParams = [queryParams, 'containerId', flywheel.ApiClient.castParam(x__inp.Results.containerId, 'char')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.filename)
                queryParams = [queryParams, 'filename', flywheel.ApiClient.castParam(x__inp.Results.filename, 'char')];
            end
            if ~isempty(x__inp.Results.format)
                queryParams = [queryParams, 'format', flywheel.ApiClient.castParam(x__inp.Results.format, 'Object')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/views/{view_id}/data', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = evaluateViewAdhoc(obj, containerId, body, varargin)
            % Execute an ad-hoc view, returning data in the preferred format.
            % containerId (char):The target container for view execution
            % body (ContainerPipelineInput)
            % filename (char):download ticket filename
            % format (Object):Available values : csv, tsv, json, ndjson, json_flat, json-row-column
            % ticket (char):download ticket id
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % filter (char):An optional filter expression
            % skip (integer):The optional number of rows to skip
            % limit (integer):The optional max number of rows to return
            % returns: [none, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('filename',x__inp.UsingDefaults)), addParameter(x__inp, 'filename', []); end
            if (ismember('format',x__inp.UsingDefaults)), addParameter(x__inp, 'format', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.containerId)
                queryParams = [queryParams, 'containerId', flywheel.ApiClient.castParam(x__inp.Results.containerId, 'char')];
            end
            if ~isempty(x__inp.Results.filename)
                queryParams = [queryParams, 'filename', flywheel.ApiClient.castParam(x__inp.Results.filename, 'char')];
            end
            if ~isempty(x__inp.Results.format)
                queryParams = [queryParams, 'format', flywheel.ApiClient.castParam(x__inp.Results.format, 'Object')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ContainerPipelineInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/views/data', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = getView(obj, viewId, varargin)
            % Return the view identified by ViewId
            % viewId (char):The ID of the view
            % returns: [ViewOutput, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('viewId',x__inp.UsingDefaults)), addRequired(x__inp, 'viewId'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, viewId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.viewId)
                pathParams = [pathParams, 'view_id', x__inp.Results.viewId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('GET', '/views/{view_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ViewOutput.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = modifyView(obj, viewId, body, varargin)
            % Update the view identified by ViewId
            % viewId (char):The ID of the view
            % body (ContainerModify)
            % returns: [ModifiedResult, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('viewId',x__inp.UsingDefaults)), addRequired(x__inp, 'viewId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, viewId, body, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.viewId)
                pathParams = [pathParams, 'view_id', x__inp.Results.viewId];
            end

            % Query parameters
            queryParams = {};

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ContainerModify.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('PUT', '/views/{view_id}', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.ModifiedResult.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = queueAdhoc(obj, containerId, body, varargin)
            % Execute an ad-hoc view, returning a reference to the created data view execution.
            % containerId (char):The target container for view execution
            % body (ContainerPipelineInput)
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % filter (char):An optional filter expression
            % skip (integer):The optional number of rows to skip
            % limit (integer):The optional max number of rows to return
            % returns: [DataViewExecution, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.containerId)
                queryParams = [queryParams, 'containerId', flywheel.ApiClient.castParam(x__inp.Results.containerId, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ContainerPipelineInput.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/views/queue', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DataViewExecution.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = queueSaved(obj, viewId, containerId, varargin)
            % Execute a view, returning a reference to the created data view execution.
            % viewId (char):The ID of the view
            % containerId (char):The target container for view execution
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % filter (char):An optional filter expression
            % skip (integer):The optional number of rows to skip
            % limit (integer):The optional max number of rows to return
            % returns: [DataViewExecution, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('viewId',x__inp.UsingDefaults)), addRequired(x__inp, 'viewId'); end
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, viewId, containerId, varargin{:});

            % Path parameters
            pathParams = {};
            if ~isempty(x__inp.Results.viewId)
                pathParams = [pathParams, 'view_id', x__inp.Results.viewId];
            end

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.containerId)
                queryParams = [queryParams, 'containerId', flywheel.ApiClient.castParam(x__inp.Results.containerId, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = {};

            resp = obj.apiClient.callApi('POST', '/views/{view_id}/queue', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.DataViewExecution.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

        function [returnData, resp] = saveViewDataToContainer(obj, containerId, body, varargin)
            % Execute a view, saving data to the target container / file
            % containerId (char):The target container for view execution
            % body (ContainerIdViewInputExecuteAndSave)
            % format (Object):Available values : csv, tsv, json, ndjson, json_flat, json-row-column
            % ticket (char):download ticket id
            % filter (char):An optional filter expression
            % sort (char):The sort fields and order.(e.g. label:asc,created:desc)
            % skip (integer):The optional number of rows to skip
            % limit (integer):The optional max number of rows to return
            % returns: [File, resp]

            x__inp = inputParser;
            x__inp.StructExpand = false;
            if (ismember('containerId',x__inp.UsingDefaults)), addRequired(x__inp, 'containerId'); end
            if (ismember('body',x__inp.UsingDefaults)), addRequired(x__inp, 'body'); end
            if (ismember('format',x__inp.UsingDefaults)), addParameter(x__inp, 'format', []); end
            if (ismember('ticket',x__inp.UsingDefaults)), addParameter(x__inp, 'ticket', []); end
            if (ismember('filter',x__inp.UsingDefaults)), addParameter(x__inp, 'filter', []); end
            if (ismember('sort',x__inp.UsingDefaults)), addParameter(x__inp, 'sort', []); end
            if (ismember('skip',x__inp.UsingDefaults)), addParameter(x__inp, 'skip', []); end
            if (ismember('limit',x__inp.UsingDefaults)), addParameter(x__inp, 'limit', []); end
            addParameter(x__inp, 'DumpResponseData', false);
            parse(x__inp, containerId, body, varargin{:});

            % Path parameters
            pathParams = {};

            % Query parameters
            queryParams = {};
            if ~isempty(x__inp.Results.containerId)
                queryParams = [queryParams, 'containerId', flywheel.ApiClient.castParam(x__inp.Results.containerId, 'char')];
            end
            if ~isempty(x__inp.Results.format)
                queryParams = [queryParams, 'format', flywheel.ApiClient.castParam(x__inp.Results.format, 'Object')];
            end
            if ~isempty(x__inp.Results.ticket)
                queryParams = [queryParams, 'ticket', flywheel.ApiClient.castParam(x__inp.Results.ticket, 'char')];
            end
            if ~isempty(x__inp.Results.filter)
                queryParams = [queryParams, 'filter', flywheel.ApiClient.castParam(x__inp.Results.filter, 'char')];
            end
            if ~isempty(x__inp.Results.sort)
                queryParams = [queryParams, 'sort', flywheel.ApiClient.castParam(x__inp.Results.sort, 'char')];
            end
            if ~isempty(x__inp.Results.skip)
                queryParams = [queryParams, 'skip', flywheel.ApiClient.castParam(x__inp.Results.skip, 'integer')];
            end
            if ~isempty(x__inp.Results.limit)
                queryParams = [queryParams, 'limit', flywheel.ApiClient.castParam(x__inp.Results.limit, 'integer')];
            end

            % Header parameters
            headers = {};

            % Form parameters
            formParams = {};
            files = {};

            % Body (as JSON)
            body = flywheel.model.ContainerIdViewInputExecuteAndSave.ensureIsInstance(x__inp.Results.body);
            body = flywheel.ApiClient.encodeJson(body.toJson());

            resp = obj.apiClient.callApi('POST', '/views/save', ...
                pathParams, queryParams, headers, body, formParams, files);

            status = resp.getStatusCode();

            switch num2str(status)
                case '200'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.File.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                case '422'
                    if x__inp.Results.DumpResponseData
                        x__respData = resp.getBodyAsString();
                        disp(x__respData);
                    end
                    if strcmp(resp.getBodyAsString(),'null')
                        returnData = [];
                        return
                    end
                    json = flywheel.ApiClient.getResponseJson(resp);
                    returnData = flywheel.model.HTTPValidationError.fromJson(json, obj.context_);
                    if ~isempty(returnData)
                        returnData = returnData.returnValue();
                    end
                otherwise
                    returnData = [];
            end
        end

    end
end
