% AccessPermissionOutput
%
% AccessPermissionOutput Properties:
%    id     
%    access 
%
% AccessPermissionOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AccessPermissionOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'access' }, ...
            { '_id', 'access' });
    end
    properties(Dependent)
        id
        access
    end
    methods
        function obj = AccessPermissionOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.AccessPermissionOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'access', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.access)
                    obj.props_('access') = p.Results.access;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.access(obj)
            if ismethod(obj, 'get_access')
                result = obj.get_access();
            else
                if isKey(obj.props_, 'access')
                    result = obj.props_('access');
                else
                    result = [];
                end
            end
        end
        function obj = set.access(obj, value)
            obj.props_('access') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'access')
                result('access') = obj.props_('access').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'access')
                result.access = struct(obj.props_('access'));
            else
                result.access = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'access')
                    propList.access = obj.props_('access');
                else
                    propList.access = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AccessPermissionOutput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'access')
                obj.props_('access') = flywheel.model.AccessLevel.fromJson(json.access, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AccessPermissionOutput')
                    obj = flywheel.model.AccessPermissionOutput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'access')
                    obj.props_('access') =  flywheel.model.AccessLevel.ensureIsInstance(obj.props_('access'));
                end
            end
        end
    end
end
