% AcquisitionInput - Input model for acquisition  Attributes:     label (str): The label of the acquisition     session (str): The parent session     info (Optional[dict]): The custom info object of the acquisition     uid (Optional[str]): The optional universal identification for the         acquisition     timestamp (Optional[datetime.datetime]): The timestamp of the         acquisition     timezone (Optional[str]): The timezone of the timestamp
%
% AcquisitionInput Properties:
%    label     
%    session   
%    uid       
%    timestamp 
%    timezone  
%    info      
%
% AcquisitionInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AcquisitionInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'session', 'uid', 'timestamp', 'timezone', 'info' }, ...
            { 'label', 'session', 'uid', 'timestamp', 'timezone', 'info' });
    end
    properties(Dependent)
        label
        session
        uid
        timestamp
        timezone
        info
    end
    methods
        function obj = AcquisitionInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.AcquisitionInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'session', []);
                addParameter(p, 'uid', []);
                addParameter(p, 'timestamp', []);
                addParameter(p, 'timezone', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
                if ~isempty(p.Results.uid)
                    obj.props_('uid') = p.Results.uid;
                end
                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
                if ~isempty(p.Results.timezone)
                    obj.props_('timezone') = p.Results.timezone;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = get.uid(obj)
            if ismethod(obj, 'get_uid')
                result = obj.get_uid();
            else
                if isKey(obj.props_, 'uid')
                    result = obj.props_('uid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uid(obj, value)
            obj.props_('uid') = value;
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = get.timezone(obj)
            if ismethod(obj, 'get_timezone')
                result = obj.get_timezone();
            else
                if isKey(obj.props_, 'timezone')
                    result = obj.props_('timezone');
                else
                    result = [];
                end
            end
        end
        function obj = set.timezone(obj, value)
            obj.props_('timezone') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'session')
                result('session') = flywheel.ModelBase.serializeValue(obj.props_('session'), 'char');
            end
            if isKey(obj.props_, 'uid')
                result('uid') = flywheel.ModelBase.serializeValue(obj.props_('uid'), 'char');
            end
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
            if isKey(obj.props_, 'timezone')
                result('timezone') = flywheel.ModelBase.serializeValue(obj.props_('timezone'), 'char');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'session')
                result.session = obj.props_('session');
            else
                result.session = [];
            end
            if isKey(obj.props_, 'uid')
                result.uid = obj.props_('uid');
            else
                result.uid = [];
            end
            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
            if isKey(obj.props_, 'timezone')
                result.timezone = obj.props_('timezone');
            else
                result.timezone = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                if isKey(obj.props_, 'uid')
                    propList.uid = obj.props_('uid');
                else
                    propList.uid = [];
                end
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                if isKey(obj.props_, 'timezone')
                    propList.timezone = obj.props_('timezone');
                else
                    propList.timezone = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AcquisitionInput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'session')
                obj.props_('session') = flywheel.ModelBase.deserializeValue(json.session, 'char');
            end
            if isfield(json, 'uid')
                obj.props_('uid') = flywheel.ModelBase.deserializeValue(json.uid, 'char');
            end
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isfield(json, 'timezone')
                obj.props_('timezone') = flywheel.ModelBase.deserializeValue(json.timezone, 'char');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AcquisitionInput')
                    obj = flywheel.model.AcquisitionInput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'session')
                end
                if isKey(obj.props_, 'uid')
                end
                if isKey(obj.props_, 'timestamp')
                end
                if isKey(obj.props_, 'timezone')
                end
                if isKey(obj.props_, 'info')
                end
            end
        end
    end
end
