% AcquisitionParents
%
% AcquisitionParents Properties:
%    group   
%    project 
%    subject 
%    session 
%
% AcquisitionParents Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AcquisitionParents < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'group', 'project', 'subject', 'session' }, ...
            { 'group', 'project', 'subject', 'session' });
    end
    properties(Dependent)
        group
        project
        subject
        session
    end
    methods
        function obj = AcquisitionParents(varargin)
            obj@flywheel.ModelBase(flywheel.model.AcquisitionParents.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'group', []);
                addParameter(p, 'project', []);
                addParameter(p, 'subject', []);
                addParameter(p, 'session', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.subject)
                    obj.props_('subject') = p.Results.subject;
                end
                if ~isempty(p.Results.session)
                    obj.props_('session') = p.Results.session;
                end
            end
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.subject(obj)
            if ismethod(obj, 'get_subject')
                result = obj.get_subject();
            else
                if isKey(obj.props_, 'subject')
                    result = obj.props_('subject');
                else
                    result = [];
                end
            end
        end
        function obj = set.subject(obj, value)
            obj.props_('subject') = value;
        end
        function result = get.session(obj)
            if ismethod(obj, 'get_session')
                result = obj.get_session();
            else
                if isKey(obj.props_, 'session')
                    result = obj.props_('session');
                else
                    result = [];
                end
            end
        end
        function obj = set.session(obj, value)
            obj.props_('session') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'char');
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'subject')
                result('subject') = flywheel.ModelBase.serializeValue(obj.props_('subject'), 'char');
            end
            if isKey(obj.props_, 'session')
                result('session') = flywheel.ModelBase.serializeValue(obj.props_('session'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'subject')
                result.subject = obj.props_('subject');
            else
                result.subject = [];
            end
            if isKey(obj.props_, 'session')
                result.session = obj.props_('session');
            else
                result.session = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'subject')
                    propList.subject = obj.props_('subject');
                else
                    propList.subject = [];
                end
                if isKey(obj.props_, 'session')
                    propList.session = obj.props_('session');
                else
                    propList.session = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AcquisitionParents;
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'char');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'subject')
                obj.props_('subject') = flywheel.ModelBase.deserializeValue(json.subject, 'char');
            end
            if isfield(json, 'session')
                obj.props_('session') = flywheel.ModelBase.deserializeValue(json.session, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AcquisitionParents')
                    obj = flywheel.model.AcquisitionParents(obj);
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'subject')
                end
                if isKey(obj.props_, 'session')
                end
            end
        end
    end
end
