% AcquisitionTemplateOptions
%
% AcquisitionTemplateOptions Properties:
%    minimum 
%    maximum 
%    files   
%    label   
%    tags    
%
% AcquisitionTemplateOptions Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AcquisitionTemplateOptions < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'minimum', 'maximum', 'files', 'label', 'tags' }, ...
            { 'minimum', 'maximum', 'files', 'label', 'tags' });
    end
    properties(Dependent)
        minimum
        maximum
        files
        label
        tags
    end
    methods
        function obj = AcquisitionTemplateOptions(varargin)
            obj@flywheel.ModelBase(flywheel.model.AcquisitionTemplateOptions.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'minimum', []);
                addParameter(p, 'maximum', []);
                addParameter(p, 'files', []);
                addParameter(p, 'label', []);
                addParameter(p, 'tags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.minimum)
                    obj.props_('minimum') = p.Results.minimum;
                end
                if ~isempty(p.Results.maximum)
                    obj.props_('maximum') = p.Results.maximum;
                end
                if ~isempty(p.Results.files)
                    obj.props_('files') = p.Results.files;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
            end
        end
        function result = get.minimum(obj)
            if ismethod(obj, 'get_minimum')
                result = obj.get_minimum();
            else
                if isKey(obj.props_, 'minimum')
                    result = obj.props_('minimum');
                else
                    result = [];
                end
            end
        end
        function obj = set.minimum(obj, value)
            obj.props_('minimum') = value;
        end
        function result = get.maximum(obj)
            if ismethod(obj, 'get_maximum')
                result = obj.get_maximum();
            else
                if isKey(obj.props_, 'maximum')
                    result = obj.props_('maximum');
                else
                    result = [];
                end
            end
        end
        function obj = set.maximum(obj, value)
            obj.props_('maximum') = value;
        end
        function result = get.files(obj)
            if ismethod(obj, 'get_files')
                result = obj.get_files();
            else
                if isKey(obj.props_, 'files')
                    result = obj.props_('files');
                else
                    result = [];
                end
            end
        end
        function obj = set.files(obj, value)
            obj.props_('files') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'minimum')
                result('minimum') = flywheel.ModelBase.serializeValue(obj.props_('minimum'), 'integer');
            end
            if isKey(obj.props_, 'maximum')
                result('maximum') = flywheel.ModelBase.serializeValue(obj.props_('maximum'), 'integer');
            end
            if isKey(obj.props_, 'files')
                result('files') = flywheel.ModelBase.cellmap(@toJson, obj.props_('files'));
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'minimum')
                result.minimum = obj.props_('minimum');
            else
                result.minimum = [];
            end
            if isKey(obj.props_, 'maximum')
                result.maximum = obj.props_('maximum');
            else
                result.maximum = [];
            end
            if isKey(obj.props_, 'files')
                result.files = flywheel.ModelBase.cellmap(@struct, obj.props_('files'));
            else
                result.files = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'minimum')
                    propList.minimum = obj.props_('minimum');
                else
                    propList.minimum = [];
                end
                if isKey(obj.props_, 'maximum')
                    propList.maximum = obj.props_('maximum');
                else
                    propList.maximum = [];
                end
                if isKey(obj.props_, 'files')
                    propList.files = obj.props_('files');
                else
                    propList.files = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AcquisitionTemplateOptions;
            if isfield(json, 'minimum')
                obj.props_('minimum') = flywheel.ModelBase.deserializeValue(json.minimum, 'integer');
            end
            if isfield(json, 'maximum')
                obj.props_('maximum') = flywheel.ModelBase.deserializeValue(json.maximum, 'integer');
            end
            if isfield(json, 'files')
                obj.props_('files') = flywheel.ModelBase.cellmap(@(x) flywheel.model.FileTemplateOptions.fromJson(x, context), json.files);
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AcquisitionTemplateOptions')
                    obj = flywheel.model.AcquisitionTemplateOptions(obj);
                end
                if isKey(obj.props_, 'minimum')
                end
                if isKey(obj.props_, 'maximum')
                end
                if isKey(obj.props_, 'files')
                    obj.props_('files') = flywheel.ModelBase.cellmap(@flywheel.model.FileTemplateOptions.ensureIsInstance, obj.props_('files'));
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'tags')
                end
            end
        end
    end
end
