% AcquisitionUpsertInput
%
% AcquisitionUpsertInput Properties:
%    id           
%    uid          
%    routingField 
%    label        
%    source       
%    timestamp    
%    timezone     
%    info         
%
% AcquisitionUpsertInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AcquisitionUpsertInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'uid', 'routingField', 'label', 'source', 'timestamp', 'timezone', 'info' }, ...
            { '_id', 'uid', 'routing_field', 'label', 'source', 'timestamp', 'timezone', 'info' });
    end
    properties(Dependent)
        id
        uid
        routingField
        label
        source
        timestamp
        timezone
        info
    end
    methods
        function obj = AcquisitionUpsertInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.AcquisitionUpsertInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'uid', []);
                addParameter(p, 'routingField', []);
                addParameter(p, 'label', []);
                addParameter(p, 'source', []);
                addParameter(p, 'timestamp', []);
                addParameter(p, 'timezone', []);
                addParameter(p, 'info', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.uid)
                    obj.props_('uid') = p.Results.uid;
                end
                if ~isempty(p.Results.routingField)
                    obj.props_('routing_field') = p.Results.routingField;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.source)
                    obj.props_('source') = p.Results.source;
                end
                if ~isempty(p.Results.timestamp)
                    obj.props_('timestamp') = p.Results.timestamp;
                end
                if ~isempty(p.Results.timezone)
                    obj.props_('timezone') = p.Results.timezone;
                end
                if ~isempty(p.Results.info)
                    obj.props_('info') = p.Results.info;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.uid(obj)
            if ismethod(obj, 'get_uid')
                result = obj.get_uid();
            else
                if isKey(obj.props_, 'uid')
                    result = obj.props_('uid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uid(obj, value)
            obj.props_('uid') = value;
        end
        function result = get.routingField(obj)
            if ismethod(obj, 'get_routingField')
                result = obj.get_routingField();
            else
                if isKey(obj.props_, 'routing_field')
                    result = obj.props_('routing_field');
                else
                    result = [];
                end
            end
        end
        function obj = set.routingField(obj, value)
            obj.props_('routing_field') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.source(obj)
            if ismethod(obj, 'get_source')
                result = obj.get_source();
            else
                if isKey(obj.props_, 'source')
                    result = obj.props_('source');
                else
                    result = [];
                end
            end
        end
        function obj = set.source(obj, value)
            obj.props_('source') = value;
        end
        function result = get.timestamp(obj)
            if ismethod(obj, 'get_timestamp')
                result = obj.get_timestamp();
            else
                if isKey(obj.props_, 'timestamp')
                    result = obj.props_('timestamp');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestamp(obj, value)
            obj.props_('timestamp') = value;
        end
        function result = get.timezone(obj)
            if ismethod(obj, 'get_timezone')
                result = obj.get_timezone();
            else
                if isKey(obj.props_, 'timezone')
                    result = obj.props_('timezone');
                else
                    result = [];
                end
            end
        end
        function obj = set.timezone(obj, value)
            obj.props_('timezone') = value;
        end
        function result = get.info(obj)
            if ismethod(obj, 'get_info')
                result = obj.get_info();
            else
                if isKey(obj.props_, 'info')
                    result = obj.props_('info');
                else
                    result = [];
                end
            end
        end
        function obj = set.info(obj, value)
            obj.props_('info') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'uid')
                result('uid') = flywheel.ModelBase.serializeValue(obj.props_('uid'), 'char');
            end
            if isKey(obj.props_, 'routing_field')
                result('routing_field') = flywheel.ModelBase.serializeValue(obj.props_('routing_field'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'source')
                result('source') = obj.props_('source').toJson();
            end
            if isKey(obj.props_, 'timestamp')
                result('timestamp') = flywheel.ModelBase.serializeValue(obj.props_('timestamp'), 'datetime');
            end
            if isKey(obj.props_, 'timezone')
                result('timezone') = flywheel.ModelBase.serializeValue(obj.props_('timezone'), 'char');
            end
            if isKey(obj.props_, 'info')
                result('info') = flywheel.ModelBase.serializeValue(obj.props_('info'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'uid')
                result.uid = obj.props_('uid');
            else
                result.uid = [];
            end
            if isKey(obj.props_, 'routing_field')
                result.routingField = obj.props_('routing_field');
            else
                result.routingField = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'source')
                result.source = struct(obj.props_('source'));
            else
                result.source = [];
            end
            if isKey(obj.props_, 'timestamp')
                result.timestamp = obj.props_('timestamp');
            else
                result.timestamp = [];
            end
            if isKey(obj.props_, 'timezone')
                result.timezone = obj.props_('timezone');
            else
                result.timezone = [];
            end
            if isKey(obj.props_, 'info')
                result.info = obj.props_('info');
            else
                result.info = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'uid')
                    propList.uid = obj.props_('uid');
                else
                    propList.uid = [];
                end
                if isKey(obj.props_, 'routing_field')
                    propList.routingField = obj.props_('routing_field');
                else
                    propList.routingField = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'source')
                    propList.source = obj.props_('source');
                else
                    propList.source = [];
                end
                if isKey(obj.props_, 'timestamp')
                    propList.timestamp = obj.props_('timestamp');
                else
                    propList.timestamp = [];
                end
                if isKey(obj.props_, 'timezone')
                    propList.timezone = obj.props_('timezone');
                else
                    propList.timezone = [];
                end
                if isKey(obj.props_, 'info')
                    propList.info = obj.props_('info');
                else
                    propList.info = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AcquisitionUpsertInput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'uid')
                obj.props_('uid') = flywheel.ModelBase.deserializeValue(json.uid, 'char');
            end
            if isfield(json, 'routing_field')
                obj.props_('routing_field') = flywheel.ModelBase.deserializeValue(json.routing_field, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'source')
                obj.props_('source') = flywheel.model.CoreModelsCommonSource.fromJson(json.source, context);
            end
            if isfield(json, 'timestamp')
                obj.props_('timestamp') = flywheel.ModelBase.deserializeValue(json.timestamp, 'datetime');
            end
            if isfield(json, 'timezone')
                obj.props_('timezone') = flywheel.ModelBase.deserializeValue(json.timezone, 'char');
            end
            if isfield(json, 'info')
                obj.props_('info') = flywheel.ModelBase.deserializeValue(json.info, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AcquisitionUpsertInput')
                    obj = flywheel.model.AcquisitionUpsertInput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'uid')
                end
                if isKey(obj.props_, 'routing_field')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'source')
                    obj.props_('source') =  flywheel.model.CoreModelsCommonSource.ensureIsInstance(obj.props_('source'));
                end
                if isKey(obj.props_, 'timestamp')
                end
                if isKey(obj.props_, 'timezone')
                end
                if isKey(obj.props_, 'info')
                end
            end
        end
    end
end
