% ApiKeyOutput
%
% ApiKeyOutput Properties:
%    label             
%    key               
%    created           
%    lastUsed          
%    unencryptedSecret 
%    expiresAt         
%
% ApiKeyOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ApiKeyOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'key', 'created', 'lastUsed', 'unencryptedSecret', 'expiresAt' }, ...
            { 'label', 'key', 'created', 'last_used', 'unencrypted_secret', 'expires_at' });
    end
    properties(Dependent)
        label
        key
        created
        lastUsed
        unencryptedSecret
        expiresAt
    end
    methods
        function obj = ApiKeyOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ApiKeyOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'key', []);
                addParameter(p, 'created', []);
                addParameter(p, 'lastUsed', []);
                addParameter(p, 'unencryptedSecret', []);
                addParameter(p, 'expiresAt', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.key)
                    obj.props_('key') = p.Results.key;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.lastUsed)
                    obj.props_('last_used') = p.Results.lastUsed;
                end
                if ~isempty(p.Results.unencryptedSecret)
                    obj.props_('unencrypted_secret') = p.Results.unencryptedSecret;
                end
                if ~isempty(p.Results.expiresAt)
                    obj.props_('expires_at') = p.Results.expiresAt;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.key(obj)
            if ismethod(obj, 'get_key')
                result = obj.get_key();
            else
                if isKey(obj.props_, 'key')
                    result = obj.props_('key');
                else
                    result = [];
                end
            end
        end
        function obj = set.key(obj, value)
            obj.props_('key') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.lastUsed(obj)
            if ismethod(obj, 'get_lastUsed')
                result = obj.get_lastUsed();
            else
                if isKey(obj.props_, 'last_used')
                    result = obj.props_('last_used');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastUsed(obj, value)
            obj.props_('last_used') = value;
        end
        function result = get.unencryptedSecret(obj)
            if ismethod(obj, 'get_unencryptedSecret')
                result = obj.get_unencryptedSecret();
            else
                if isKey(obj.props_, 'unencrypted_secret')
                    result = obj.props_('unencrypted_secret');
                else
                    result = [];
                end
            end
        end
        function obj = set.unencryptedSecret(obj, value)
            obj.props_('unencrypted_secret') = value;
        end
        function result = get.expiresAt(obj)
            if ismethod(obj, 'get_expiresAt')
                result = obj.get_expiresAt();
            else
                if isKey(obj.props_, 'expires_at')
                    result = obj.props_('expires_at');
                else
                    result = [];
                end
            end
        end
        function obj = set.expiresAt(obj, value)
            obj.props_('expires_at') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'key')
                result('key') = flywheel.ModelBase.serializeValue(obj.props_('key'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'last_used')
                result('last_used') = flywheel.ModelBase.serializeValue(obj.props_('last_used'), 'datetime');
            end
            if isKey(obj.props_, 'unencrypted_secret')
                result('unencrypted_secret') = flywheel.ModelBase.serializeValue(obj.props_('unencrypted_secret'), 'char');
            end
            if isKey(obj.props_, 'expires_at')
                result('expires_at') = flywheel.ModelBase.serializeValue(obj.props_('expires_at'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'key')
                result.key = obj.props_('key');
            else
                result.key = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'last_used')
                result.lastUsed = obj.props_('last_used');
            else
                result.lastUsed = [];
            end
            if isKey(obj.props_, 'unencrypted_secret')
                result.unencryptedSecret = obj.props_('unencrypted_secret');
            else
                result.unencryptedSecret = [];
            end
            if isKey(obj.props_, 'expires_at')
                result.expiresAt = obj.props_('expires_at');
            else
                result.expiresAt = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'key')
                    propList.key = obj.props_('key');
                else
                    propList.key = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'last_used')
                    propList.lastUsed = obj.props_('last_used');
                else
                    propList.lastUsed = [];
                end
                if isKey(obj.props_, 'unencrypted_secret')
                    propList.unencryptedSecret = obj.props_('unencrypted_secret');
                else
                    propList.unencryptedSecret = [];
                end
                if isKey(obj.props_, 'expires_at')
                    propList.expiresAt = obj.props_('expires_at');
                else
                    propList.expiresAt = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ApiKeyOutput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'key')
                obj.props_('key') = flywheel.ModelBase.deserializeValue(json.key, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'last_used')
                obj.props_('last_used') = flywheel.ModelBase.deserializeValue(json.last_used, 'datetime');
            end
            if isfield(json, 'unencrypted_secret')
                obj.props_('unencrypted_secret') = flywheel.ModelBase.deserializeValue(json.unencrypted_secret, 'char');
            end
            if isfield(json, 'expires_at')
                obj.props_('expires_at') = flywheel.ModelBase.deserializeValue(json.expires_at, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ApiKeyOutput')
                    obj = flywheel.model.ApiKeyOutput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'key')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'last_used')
                end
                if isKey(obj.props_, 'unencrypted_secret')
                end
                if isKey(obj.props_, 'expires_at')
                end
            end
        end
    end
end
