% AuditTrailReport
%
% AuditTrailReport Properties:
%    id           
%    origin       
%    projectId    
%    subjectIds   
%    label        
%    status       
%    created      
%    finished     
%    revision     
%    deleted      
%    error        
%    celeryTaskId 
%    size         
%
% AuditTrailReport Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AuditTrailReport < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'origin', 'projectId', 'subjectIds', 'label', 'status', 'created', 'finished', 'revision', 'deleted', 'error', 'celeryTaskId', 'size' }, ...
            { '_id', 'origin', 'project_id', 'subject_ids', 'label', 'status', 'created', 'finished', 'revision', 'deleted', 'error', 'celery_task_id', 'size' });
    end
    properties(Dependent)
        id
        origin
        projectId
        subjectIds
        label
        status
        created
        finished
        revision
        deleted
        error
        celeryTaskId
        size
    end
    methods
        function obj = AuditTrailReport(varargin)
            obj@flywheel.ModelBase(flywheel.model.AuditTrailReport.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'projectId', []);
                addParameter(p, 'subjectIds', []);
                addParameter(p, 'label', []);
                addParameter(p, 'status', []);
                addParameter(p, 'created', []);
                addParameter(p, 'finished', []);
                addParameter(p, 'revision', 1);
                addParameter(p, 'deleted', []);
                addParameter(p, 'error', []);
                addParameter(p, 'celeryTaskId', []);
                addParameter(p, 'size', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.subjectIds)
                    obj.props_('subject_ids') = p.Results.subjectIds;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.status)
                    obj.props_('status') = p.Results.status;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.finished)
                    obj.props_('finished') = p.Results.finished;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
                if ~isempty(p.Results.deleted)
                    obj.props_('deleted') = p.Results.deleted;
                end
                if ~isempty(p.Results.error)
                    obj.props_('error') = p.Results.error;
                end
                if ~isempty(p.Results.celeryTaskId)
                    obj.props_('celery_task_id') = p.Results.celeryTaskId;
                end
                if ~isempty(p.Results.size)
                    obj.props_('size') = p.Results.size;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.subjectIds(obj)
            if ismethod(obj, 'get_subjectIds')
                result = obj.get_subjectIds();
            else
                if isKey(obj.props_, 'subject_ids')
                    result = obj.props_('subject_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.subjectIds(obj, value)
            obj.props_('subject_ids') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.status(obj)
            if ismethod(obj, 'get_status')
                result = obj.get_status();
            else
                if isKey(obj.props_, 'status')
                    result = obj.props_('status');
                else
                    result = [];
                end
            end
        end
        function obj = set.status(obj, value)
            obj.props_('status') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.finished(obj)
            if ismethod(obj, 'get_finished')
                result = obj.get_finished();
            else
                if isKey(obj.props_, 'finished')
                    result = obj.props_('finished');
                else
                    result = [];
                end
            end
        end
        function obj = set.finished(obj, value)
            obj.props_('finished') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = get.deleted(obj)
            if ismethod(obj, 'get_deleted')
                result = obj.get_deleted();
            else
                if isKey(obj.props_, 'deleted')
                    result = obj.props_('deleted');
                else
                    result = [];
                end
            end
        end
        function obj = set.deleted(obj, value)
            obj.props_('deleted') = value;
        end
        function result = get.error(obj)
            if ismethod(obj, 'get_error')
                result = obj.get_error();
            else
                if isKey(obj.props_, 'error')
                    result = obj.props_('error');
                else
                    result = [];
                end
            end
        end
        function obj = set.error(obj, value)
            obj.props_('error') = value;
        end
        function result = get.celeryTaskId(obj)
            if ismethod(obj, 'get_celeryTaskId')
                result = obj.get_celeryTaskId();
            else
                if isKey(obj.props_, 'celery_task_id')
                    result = obj.props_('celery_task_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.celeryTaskId(obj, value)
            obj.props_('celery_task_id') = value;
        end
        function result = get.size(obj)
            if ismethod(obj, 'get_size')
                result = obj.get_size();
            else
                if isKey(obj.props_, 'size')
                    result = obj.props_('size');
                else
                    result = [];
                end
            end
        end
        function obj = set.size(obj, value)
            obj.props_('size') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'subject_ids')
                result('subject_ids') = flywheel.ModelBase.serializeValue(obj.props_('subject_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'status')
                result('status') = obj.props_('status').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'finished')
                result('finished') = flywheel.ModelBase.serializeValue(obj.props_('finished'), 'datetime');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
            if isKey(obj.props_, 'deleted')
                result('deleted') = flywheel.ModelBase.serializeValue(obj.props_('deleted'), 'datetime');
            end
            if isKey(obj.props_, 'error')
                result('error') = flywheel.ModelBase.serializeValue(obj.props_('error'), 'char');
            end
            if isKey(obj.props_, 'celery_task_id')
                result('celery_task_id') = flywheel.ModelBase.serializeValue(obj.props_('celery_task_id'), 'char');
            end
            if isKey(obj.props_, 'size')
                result('size') = flywheel.ModelBase.serializeValue(obj.props_('size'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'subject_ids')
                result.subjectIds = obj.props_('subject_ids');
            else
                result.subjectIds = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'status')
                result.status = struct(obj.props_('status'));
            else
                result.status = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'finished')
                result.finished = obj.props_('finished');
            else
                result.finished = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
            if isKey(obj.props_, 'deleted')
                result.deleted = obj.props_('deleted');
            else
                result.deleted = [];
            end
            if isKey(obj.props_, 'error')
                result.error = obj.props_('error');
            else
                result.error = [];
            end
            if isKey(obj.props_, 'celery_task_id')
                result.celeryTaskId = obj.props_('celery_task_id');
            else
                result.celeryTaskId = [];
            end
            if isKey(obj.props_, 'size')
                result.size = obj.props_('size');
            else
                result.size = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'subject_ids')
                    propList.subjectIds = obj.props_('subject_ids');
                else
                    propList.subjectIds = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'status')
                    propList.status = obj.props_('status');
                else
                    propList.status = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'finished')
                    propList.finished = obj.props_('finished');
                else
                    propList.finished = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                if isKey(obj.props_, 'deleted')
                    propList.deleted = obj.props_('deleted');
                else
                    propList.deleted = [];
                end
                if isKey(obj.props_, 'error')
                    propList.error = obj.props_('error');
                else
                    propList.error = [];
                end
                if isKey(obj.props_, 'celery_task_id')
                    propList.celeryTaskId = obj.props_('celery_task_id');
                else
                    propList.celeryTaskId = [];
                end
                if isKey(obj.props_, 'size')
                    propList.size = obj.props_('size');
                else
                    propList.size = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AuditTrailReport;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'subject_ids')
                obj.props_('subject_ids') = flywheel.ModelBase.deserializeValue(json.subject_ids, 'vector[char]');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'status')
                obj.props_('status') = flywheel.model.AuditTrailReportStatus.fromJson(json.status, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'finished')
                obj.props_('finished') = flywheel.ModelBase.deserializeValue(json.finished, 'datetime');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isfield(json, 'deleted')
                obj.props_('deleted') = flywheel.ModelBase.deserializeValue(json.deleted, 'datetime');
            end
            if isfield(json, 'error')
                obj.props_('error') = flywheel.ModelBase.deserializeValue(json.error, 'char');
            end
            if isfield(json, 'celery_task_id')
                obj.props_('celery_task_id') = flywheel.ModelBase.deserializeValue(json.celery_task_id, 'char');
            end
            if isfield(json, 'size')
                obj.props_('size') = flywheel.ModelBase.deserializeValue(json.size, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AuditTrailReport')
                    obj = flywheel.model.AuditTrailReport(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'subject_ids')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'status')
                    obj.props_('status') =  flywheel.model.AuditTrailReportStatus.ensureIsInstance(obj.props_('status'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'finished')
                end
                if isKey(obj.props_, 'revision')
                end
                if isKey(obj.props_, 'deleted')
                end
                if isKey(obj.props_, 'error')
                end
                if isKey(obj.props_, 'celery_task_id')
                end
                if isKey(obj.props_, 'size')
                end
            end
        end
    end
end
