% Auth0AuthOut
%
% Auth0AuthOut Properties:
%    clientId       
%    domain         
%    audience       
%    claimNamespace 
%    jwks           
%    options        
%    cookieDomain   
%
% Auth0AuthOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Auth0AuthOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'clientId', 'domain', 'audience', 'claimNamespace', 'jwks', 'options', 'cookieDomain' }, ...
            { 'client_id', 'domain', 'audience', 'claim_namespace', 'jwks', 'options', 'cookie_domain' });
    end
    properties(Dependent)
        clientId
        domain
        audience
        claimNamespace
        jwks
        options
        cookieDomain
    end
    methods
        function obj = Auth0AuthOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.Auth0AuthOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'clientId', []);
                addParameter(p, 'domain', []);
                addParameter(p, 'audience', []);
                addParameter(p, 'claimNamespace', []);
                addParameter(p, 'jwks', []);
                addParameter(p, 'options', []);
                addParameter(p, 'cookieDomain', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.clientId)
                    obj.props_('client_id') = p.Results.clientId;
                end
                if ~isempty(p.Results.domain)
                    obj.props_('domain') = p.Results.domain;
                end
                if ~isempty(p.Results.audience)
                    obj.props_('audience') = p.Results.audience;
                end
                if ~isempty(p.Results.claimNamespace)
                    obj.props_('claim_namespace') = p.Results.claimNamespace;
                end
                if ~isempty(p.Results.jwks)
                    obj.props_('jwks') = p.Results.jwks;
                end
                if ~isempty(p.Results.options)
                    obj.props_('options') = p.Results.options;
                end
                if ~isempty(p.Results.cookieDomain)
                    obj.props_('cookie_domain') = p.Results.cookieDomain;
                end
            end
        end
        function result = get.clientId(obj)
            if ismethod(obj, 'get_clientId')
                result = obj.get_clientId();
            else
                if isKey(obj.props_, 'client_id')
                    result = obj.props_('client_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.clientId(obj, value)
            obj.props_('client_id') = value;
        end
        function result = get.domain(obj)
            if ismethod(obj, 'get_domain')
                result = obj.get_domain();
            else
                if isKey(obj.props_, 'domain')
                    result = obj.props_('domain');
                else
                    result = [];
                end
            end
        end
        function obj = set.domain(obj, value)
            obj.props_('domain') = value;
        end
        function result = get.audience(obj)
            if ismethod(obj, 'get_audience')
                result = obj.get_audience();
            else
                if isKey(obj.props_, 'audience')
                    result = obj.props_('audience');
                else
                    result = [];
                end
            end
        end
        function obj = set.audience(obj, value)
            obj.props_('audience') = value;
        end
        function result = get.claimNamespace(obj)
            if ismethod(obj, 'get_claimNamespace')
                result = obj.get_claimNamespace();
            else
                if isKey(obj.props_, 'claim_namespace')
                    result = obj.props_('claim_namespace');
                else
                    result = [];
                end
            end
        end
        function obj = set.claimNamespace(obj, value)
            obj.props_('claim_namespace') = value;
        end
        function result = get.jwks(obj)
            if ismethod(obj, 'get_jwks')
                result = obj.get_jwks();
            else
                if isKey(obj.props_, 'jwks')
                    result = obj.props_('jwks');
                else
                    result = [];
                end
            end
        end
        function obj = set.jwks(obj, value)
            obj.props_('jwks') = value;
        end
        function result = get.options(obj)
            if ismethod(obj, 'get_options')
                result = obj.get_options();
            else
                if isKey(obj.props_, 'options')
                    result = obj.props_('options');
                else
                    result = [];
                end
            end
        end
        function obj = set.options(obj, value)
            obj.props_('options') = value;
        end
        function result = get.cookieDomain(obj)
            if ismethod(obj, 'get_cookieDomain')
                result = obj.get_cookieDomain();
            else
                if isKey(obj.props_, 'cookie_domain')
                    result = obj.props_('cookie_domain');
                else
                    result = [];
                end
            end
        end
        function obj = set.cookieDomain(obj, value)
            obj.props_('cookie_domain') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'client_id')
                result('client_id') = flywheel.ModelBase.serializeValue(obj.props_('client_id'), 'char');
            end
            if isKey(obj.props_, 'domain')
                result('domain') = flywheel.ModelBase.serializeValue(obj.props_('domain'), 'char');
            end
            if isKey(obj.props_, 'audience')
                result('audience') = flywheel.ModelBase.serializeValue(obj.props_('audience'), 'vector[char]');
            end
            if isKey(obj.props_, 'claim_namespace')
                result('claim_namespace') = flywheel.ModelBase.serializeValue(obj.props_('claim_namespace'), 'char');
            end
            if isKey(obj.props_, 'jwks')
                result('jwks') = flywheel.ModelBase.serializeValue(obj.props_('jwks'), 'containers.Map[String, containers.Map]');
            end
            if isKey(obj.props_, 'options')
                result('options') = obj.props_('options').toJson();
            end
            if isKey(obj.props_, 'cookie_domain')
                result('cookie_domain') = flywheel.ModelBase.serializeValue(obj.props_('cookie_domain'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'client_id')
                result.clientId = obj.props_('client_id');
            else
                result.clientId = [];
            end
            if isKey(obj.props_, 'domain')
                result.domain = obj.props_('domain');
            else
                result.domain = [];
            end
            if isKey(obj.props_, 'audience')
                result.audience = obj.props_('audience');
            else
                result.audience = [];
            end
            if isKey(obj.props_, 'claim_namespace')
                result.claimNamespace = obj.props_('claim_namespace');
            else
                result.claimNamespace = [];
            end
            if isKey(obj.props_, 'jwks')
                result.jwks = obj.props_('jwks');
            else
                result.jwks = [];
            end
            if isKey(obj.props_, 'options')
                result.options = struct(obj.props_('options'));
            else
                result.options = [];
            end
            if isKey(obj.props_, 'cookie_domain')
                result.cookieDomain = obj.props_('cookie_domain');
            else
                result.cookieDomain = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'client_id')
                    propList.clientId = obj.props_('client_id');
                else
                    propList.clientId = [];
                end
                if isKey(obj.props_, 'domain')
                    propList.domain = obj.props_('domain');
                else
                    propList.domain = [];
                end
                if isKey(obj.props_, 'audience')
                    propList.audience = obj.props_('audience');
                else
                    propList.audience = [];
                end
                if isKey(obj.props_, 'claim_namespace')
                    propList.claimNamespace = obj.props_('claim_namespace');
                else
                    propList.claimNamespace = [];
                end
                if isKey(obj.props_, 'jwks')
                    propList.jwks = obj.props_('jwks');
                else
                    propList.jwks = [];
                end
                if isKey(obj.props_, 'options')
                    propList.options = obj.props_('options');
                else
                    propList.options = [];
                end
                if isKey(obj.props_, 'cookie_domain')
                    propList.cookieDomain = obj.props_('cookie_domain');
                else
                    propList.cookieDomain = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Auth0AuthOut;
            if isfield(json, 'client_id')
                obj.props_('client_id') = flywheel.ModelBase.deserializeValue(json.client_id, 'char');
            end
            if isfield(json, 'domain')
                obj.props_('domain') = flywheel.ModelBase.deserializeValue(json.domain, 'char');
            end
            if isfield(json, 'audience')
                obj.props_('audience') = flywheel.ModelBase.deserializeValue(json.audience, 'vector[char]');
            end
            if isfield(json, 'claim_namespace')
                obj.props_('claim_namespace') = flywheel.ModelBase.deserializeValue(json.claim_namespace, 'char');
            end
            if isfield(json, 'jwks')
                obj.props_('jwks') = flywheel.ModelBase.deserializeValue(json.jwks, 'containers.Map[String, containers.Map]');
            end
            if isfield(json, 'options')
                obj.props_('options') = flywheel.model.Auth0OptionsOut.fromJson(json.options, context);
            end
            if isfield(json, 'cookie_domain')
                obj.props_('cookie_domain') = flywheel.ModelBase.deserializeValue(json.cookie_domain, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Auth0AuthOut')
                    obj = flywheel.model.Auth0AuthOut(obj);
                end
                if isKey(obj.props_, 'client_id')
                end
                if isKey(obj.props_, 'domain')
                end
                if isKey(obj.props_, 'audience')
                end
                if isKey(obj.props_, 'claim_namespace')
                end
                if isKey(obj.props_, 'jwks')
                end
                if isKey(obj.props_, 'options')
                    obj.props_('options') =  flywheel.model.Auth0OptionsOut.ensureIsInstance(obj.props_('options'));
                end
                if isKey(obj.props_, 'cookie_domain')
                end
            end
        end
    end
end
