% Auth0OptionsOut
%
% Auth0OptionsOut Properties:
%    onboarding            
%    onboardingEppn        
%    fetchProfile          
%    limitSocialDomains    
%    socialDomainWhitelist 
%    academicIdpWhitelist  
%    federatedLogoutSubs   
%
% Auth0OptionsOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Auth0OptionsOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'onboarding', 'onboardingEppn', 'fetchProfile', 'limitSocialDomains', 'socialDomainWhitelist', 'academicIdpWhitelist', 'federatedLogoutSubs' }, ...
            { 'onboarding', 'onboarding-eppn', 'fetch-profile', 'limit-social-domains', 'social_domain_whitelist', 'academic_idp_whitelist', 'federated_logout_subs' });
    end
    properties(Dependent)
        onboarding
        onboardingEppn
        fetchProfile
        limitSocialDomains
        socialDomainWhitelist
        academicIdpWhitelist
        federatedLogoutSubs
    end
    methods
        function obj = Auth0OptionsOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.Auth0OptionsOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'onboarding', []);
                addParameter(p, 'onboardingEppn', []);
                addParameter(p, 'fetchProfile', []);
                addParameter(p, 'limitSocialDomains', []);
                addParameter(p, 'socialDomainWhitelist', []);
                addParameter(p, 'academicIdpWhitelist', []);
                addParameter(p, 'federatedLogoutSubs', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.onboarding)
                    obj.props_('onboarding') = p.Results.onboarding;
                end
                if ~isempty(p.Results.onboardingEppn)
                    obj.props_('onboarding-eppn') = p.Results.onboardingEppn;
                end
                if ~isempty(p.Results.fetchProfile)
                    obj.props_('fetch-profile') = p.Results.fetchProfile;
                end
                if ~isempty(p.Results.limitSocialDomains)
                    obj.props_('limit-social-domains') = p.Results.limitSocialDomains;
                end
                if ~isempty(p.Results.socialDomainWhitelist)
                    obj.props_('social_domain_whitelist') = p.Results.socialDomainWhitelist;
                end
                if ~isempty(p.Results.academicIdpWhitelist)
                    obj.props_('academic_idp_whitelist') = p.Results.academicIdpWhitelist;
                end
                if ~isempty(p.Results.federatedLogoutSubs)
                    obj.props_('federated_logout_subs') = p.Results.federatedLogoutSubs;
                end
            end
        end
        function result = get.onboarding(obj)
            if ismethod(obj, 'get_onboarding')
                result = obj.get_onboarding();
            else
                if isKey(obj.props_, 'onboarding')
                    result = obj.props_('onboarding');
                else
                    result = [];
                end
            end
        end
        function obj = set.onboarding(obj, value)
            obj.props_('onboarding') = value;
        end
        function result = get.onboardingEppn(obj)
            if ismethod(obj, 'get_onboardingEppn')
                result = obj.get_onboardingEppn();
            else
                if isKey(obj.props_, 'onboarding-eppn')
                    result = obj.props_('onboarding-eppn');
                else
                    result = [];
                end
            end
        end
        function obj = set.onboardingEppn(obj, value)
            obj.props_('onboarding-eppn') = value;
        end
        function result = get.fetchProfile(obj)
            if ismethod(obj, 'get_fetchProfile')
                result = obj.get_fetchProfile();
            else
                if isKey(obj.props_, 'fetch-profile')
                    result = obj.props_('fetch-profile');
                else
                    result = [];
                end
            end
        end
        function obj = set.fetchProfile(obj, value)
            obj.props_('fetch-profile') = value;
        end
        function result = get.limitSocialDomains(obj)
            if ismethod(obj, 'get_limitSocialDomains')
                result = obj.get_limitSocialDomains();
            else
                if isKey(obj.props_, 'limit-social-domains')
                    result = obj.props_('limit-social-domains');
                else
                    result = [];
                end
            end
        end
        function obj = set.limitSocialDomains(obj, value)
            obj.props_('limit-social-domains') = value;
        end
        function result = get.socialDomainWhitelist(obj)
            if ismethod(obj, 'get_socialDomainWhitelist')
                result = obj.get_socialDomainWhitelist();
            else
                if isKey(obj.props_, 'social_domain_whitelist')
                    result = obj.props_('social_domain_whitelist');
                else
                    result = [];
                end
            end
        end
        function obj = set.socialDomainWhitelist(obj, value)
            obj.props_('social_domain_whitelist') = value;
        end
        function result = get.academicIdpWhitelist(obj)
            if ismethod(obj, 'get_academicIdpWhitelist')
                result = obj.get_academicIdpWhitelist();
            else
                if isKey(obj.props_, 'academic_idp_whitelist')
                    result = obj.props_('academic_idp_whitelist');
                else
                    result = [];
                end
            end
        end
        function obj = set.academicIdpWhitelist(obj, value)
            obj.props_('academic_idp_whitelist') = value;
        end
        function result = get.federatedLogoutSubs(obj)
            if ismethod(obj, 'get_federatedLogoutSubs')
                result = obj.get_federatedLogoutSubs();
            else
                if isKey(obj.props_, 'federated_logout_subs')
                    result = obj.props_('federated_logout_subs');
                else
                    result = [];
                end
            end
        end
        function obj = set.federatedLogoutSubs(obj, value)
            obj.props_('federated_logout_subs') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'onboarding')
                result('onboarding') = flywheel.ModelBase.serializeValue(obj.props_('onboarding'), 'logical');
            end
            if isKey(obj.props_, 'onboarding-eppn')
                result('onboarding-eppn') = flywheel.ModelBase.serializeValue(obj.props_('onboarding-eppn'), 'logical');
            end
            if isKey(obj.props_, 'fetch-profile')
                result('fetch-profile') = flywheel.ModelBase.serializeValue(obj.props_('fetch-profile'), 'logical');
            end
            if isKey(obj.props_, 'limit-social-domains')
                result('limit-social-domains') = flywheel.ModelBase.serializeValue(obj.props_('limit-social-domains'), 'logical');
            end
            if isKey(obj.props_, 'social_domain_whitelist')
                result('social_domain_whitelist') = flywheel.ModelBase.serializeValue(obj.props_('social_domain_whitelist'), 'vector[char]');
            end
            if isKey(obj.props_, 'academic_idp_whitelist')
                result('academic_idp_whitelist') = flywheel.ModelBase.serializeValue(obj.props_('academic_idp_whitelist'), 'vector[char]');
            end
            if isKey(obj.props_, 'federated_logout_subs')
                result('federated_logout_subs') = flywheel.ModelBase.serializeValue(obj.props_('federated_logout_subs'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'onboarding')
                result.onboarding = obj.props_('onboarding');
            else
                result.onboarding = [];
            end
            if isKey(obj.props_, 'onboarding-eppn')
                result.onboardingEppn = obj.props_('onboarding-eppn');
            else
                result.onboardingEppn = [];
            end
            if isKey(obj.props_, 'fetch-profile')
                result.fetchProfile = obj.props_('fetch-profile');
            else
                result.fetchProfile = [];
            end
            if isKey(obj.props_, 'limit-social-domains')
                result.limitSocialDomains = obj.props_('limit-social-domains');
            else
                result.limitSocialDomains = [];
            end
            if isKey(obj.props_, 'social_domain_whitelist')
                result.socialDomainWhitelist = obj.props_('social_domain_whitelist');
            else
                result.socialDomainWhitelist = [];
            end
            if isKey(obj.props_, 'academic_idp_whitelist')
                result.academicIdpWhitelist = obj.props_('academic_idp_whitelist');
            else
                result.academicIdpWhitelist = [];
            end
            if isKey(obj.props_, 'federated_logout_subs')
                result.federatedLogoutSubs = obj.props_('federated_logout_subs');
            else
                result.federatedLogoutSubs = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'onboarding')
                    propList.onboarding = obj.props_('onboarding');
                else
                    propList.onboarding = [];
                end
                if isKey(obj.props_, 'onboarding-eppn')
                    propList.onboardingEppn = obj.props_('onboarding-eppn');
                else
                    propList.onboardingEppn = [];
                end
                if isKey(obj.props_, 'fetch-profile')
                    propList.fetchProfile = obj.props_('fetch-profile');
                else
                    propList.fetchProfile = [];
                end
                if isKey(obj.props_, 'limit-social-domains')
                    propList.limitSocialDomains = obj.props_('limit-social-domains');
                else
                    propList.limitSocialDomains = [];
                end
                if isKey(obj.props_, 'social_domain_whitelist')
                    propList.socialDomainWhitelist = obj.props_('social_domain_whitelist');
                else
                    propList.socialDomainWhitelist = [];
                end
                if isKey(obj.props_, 'academic_idp_whitelist')
                    propList.academicIdpWhitelist = obj.props_('academic_idp_whitelist');
                else
                    propList.academicIdpWhitelist = [];
                end
                if isKey(obj.props_, 'federated_logout_subs')
                    propList.federatedLogoutSubs = obj.props_('federated_logout_subs');
                else
                    propList.federatedLogoutSubs = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Auth0OptionsOut;
            if isfield(json, 'onboarding')
                obj.props_('onboarding') = flywheel.ModelBase.deserializeValue(json.onboarding, 'logical');
            end
            if isfield(json, 'onboarding0x2Deppn')
                obj.props_('onboarding-eppn') = flywheel.ModelBase.deserializeValue(json.onboarding0x2Deppn, 'logical');
            end
            if isfield(json, 'fetch0x2Dprofile')
                obj.props_('fetch-profile') = flywheel.ModelBase.deserializeValue(json.fetch0x2Dprofile, 'logical');
            end
            if isfield(json, 'limit0x2Dsocial0x2Ddomains')
                obj.props_('limit-social-domains') = flywheel.ModelBase.deserializeValue(json.limit0x2Dsocial0x2Ddomains, 'logical');
            end
            if isfield(json, 'social_domain_whitelist')
                obj.props_('social_domain_whitelist') = flywheel.ModelBase.deserializeValue(json.social_domain_whitelist, 'vector[char]');
            end
            if isfield(json, 'academic_idp_whitelist')
                obj.props_('academic_idp_whitelist') = flywheel.ModelBase.deserializeValue(json.academic_idp_whitelist, 'vector[char]');
            end
            if isfield(json, 'federated_logout_subs')
                obj.props_('federated_logout_subs') = flywheel.ModelBase.deserializeValue(json.federated_logout_subs, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Auth0OptionsOut')
                    obj = flywheel.model.Auth0OptionsOut(obj);
                end
                if isKey(obj.props_, 'onboarding')
                end
                if isKey(obj.props_, 'onboarding-eppn')
                end
                if isKey(obj.props_, 'fetch-profile')
                end
                if isKey(obj.props_, 'limit-social-domains')
                end
                if isKey(obj.props_, 'social_domain_whitelist')
                end
                if isKey(obj.props_, 'academic_idp_whitelist')
                end
                if isKey(obj.props_, 'federated_logout_subs')
                end
            end
        end
    end
end
