% AuthOut
%
% AuthOut Properties:
%    google 
%    auth0  
%    basic  
%    cas    
%    ldap   
%    mail   
%    saml   
%    wechat 
%
% AuthOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AuthOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'google', 'auth0', 'basic', 'cas', 'ldap', 'mail', 'saml', 'wechat' }, ...
            { 'google', 'auth0', 'basic', 'cas', 'ldap', 'mail', 'saml', 'wechat' });
    end
    properties(Dependent)
        google
        auth0
        basic
        cas
        ldap
        mail
        saml
        wechat
    end
    methods
        function obj = AuthOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.AuthOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'google', []);
                addParameter(p, 'auth0', []);
                addParameter(p, 'basic', []);
                addParameter(p, 'cas', []);
                addParameter(p, 'ldap', []);
                addParameter(p, 'mail', []);
                addParameter(p, 'saml', []);
                addParameter(p, 'wechat', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.google)
                    obj.props_('google') = p.Results.google;
                end
                if ~isempty(p.Results.auth0)
                    obj.props_('auth0') = p.Results.auth0;
                end
                if ~isempty(p.Results.basic)
                    obj.props_('basic') = p.Results.basic;
                end
                if ~isempty(p.Results.cas)
                    obj.props_('cas') = p.Results.cas;
                end
                if ~isempty(p.Results.ldap)
                    obj.props_('ldap') = p.Results.ldap;
                end
                if ~isempty(p.Results.mail)
                    obj.props_('mail') = p.Results.mail;
                end
                if ~isempty(p.Results.saml)
                    obj.props_('saml') = p.Results.saml;
                end
                if ~isempty(p.Results.wechat)
                    obj.props_('wechat') = p.Results.wechat;
                end
            end
        end
        function result = get.google(obj)
            if ismethod(obj, 'get_google')
                result = obj.get_google();
            else
                if isKey(obj.props_, 'google')
                    result = obj.props_('google');
                else
                    result = [];
                end
            end
        end
        function obj = set.google(obj, value)
            obj.props_('google') = value;
        end
        function result = get.auth0(obj)
            if ismethod(obj, 'get_auth0')
                result = obj.get_auth0();
            else
                if isKey(obj.props_, 'auth0')
                    result = obj.props_('auth0');
                else
                    result = [];
                end
            end
        end
        function obj = set.auth0(obj, value)
            obj.props_('auth0') = value;
        end
        function result = get.basic(obj)
            if ismethod(obj, 'get_basic')
                result = obj.get_basic();
            else
                if isKey(obj.props_, 'basic')
                    result = obj.props_('basic');
                else
                    result = [];
                end
            end
        end
        function obj = set.basic(obj, value)
            obj.props_('basic') = value;
        end
        function result = get.cas(obj)
            if ismethod(obj, 'get_cas')
                result = obj.get_cas();
            else
                if isKey(obj.props_, 'cas')
                    result = obj.props_('cas');
                else
                    result = [];
                end
            end
        end
        function obj = set.cas(obj, value)
            obj.props_('cas') = value;
        end
        function result = get.ldap(obj)
            if ismethod(obj, 'get_ldap')
                result = obj.get_ldap();
            else
                if isKey(obj.props_, 'ldap')
                    result = obj.props_('ldap');
                else
                    result = [];
                end
            end
        end
        function obj = set.ldap(obj, value)
            obj.props_('ldap') = value;
        end
        function result = get.mail(obj)
            if ismethod(obj, 'get_mail')
                result = obj.get_mail();
            else
                if isKey(obj.props_, 'mail')
                    result = obj.props_('mail');
                else
                    result = [];
                end
            end
        end
        function obj = set.mail(obj, value)
            obj.props_('mail') = value;
        end
        function result = get.saml(obj)
            if ismethod(obj, 'get_saml')
                result = obj.get_saml();
            else
                if isKey(obj.props_, 'saml')
                    result = obj.props_('saml');
                else
                    result = [];
                end
            end
        end
        function obj = set.saml(obj, value)
            obj.props_('saml') = value;
        end
        function result = get.wechat(obj)
            if ismethod(obj, 'get_wechat')
                result = obj.get_wechat();
            else
                if isKey(obj.props_, 'wechat')
                    result = obj.props_('wechat');
                else
                    result = [];
                end
            end
        end
        function obj = set.wechat(obj, value)
            obj.props_('wechat') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'google')
                result('google') = obj.props_('google').toJson();
            end
            if isKey(obj.props_, 'auth0')
                result('auth0') = obj.props_('auth0').toJson();
            end
            if isKey(obj.props_, 'basic')
                result('basic') = flywheel.ModelBase.serializeValue(obj.props_('basic'), 'containers.Map');
            end
            if isKey(obj.props_, 'cas')
                result('cas') = flywheel.ModelBase.serializeValue(obj.props_('cas'), 'containers.Map');
            end
            if isKey(obj.props_, 'ldap')
                result('ldap') = flywheel.ModelBase.serializeValue(obj.props_('ldap'), 'containers.Map');
            end
            if isKey(obj.props_, 'mail')
                result('mail') = flywheel.ModelBase.serializeValue(obj.props_('mail'), 'containers.Map');
            end
            if isKey(obj.props_, 'saml')
                result('saml') = flywheel.ModelBase.serializeValue(obj.props_('saml'), 'containers.Map');
            end
            if isKey(obj.props_, 'wechat')
                result('wechat') = flywheel.ModelBase.serializeValue(obj.props_('wechat'), 'containers.Map');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'google')
                result.google = struct(obj.props_('google'));
            else
                result.google = [];
            end
            if isKey(obj.props_, 'auth0')
                result.auth0 = struct(obj.props_('auth0'));
            else
                result.auth0 = [];
            end
            if isKey(obj.props_, 'basic')
                result.basic = obj.props_('basic');
            else
                result.basic = [];
            end
            if isKey(obj.props_, 'cas')
                result.cas = obj.props_('cas');
            else
                result.cas = [];
            end
            if isKey(obj.props_, 'ldap')
                result.ldap = obj.props_('ldap');
            else
                result.ldap = [];
            end
            if isKey(obj.props_, 'mail')
                result.mail = obj.props_('mail');
            else
                result.mail = [];
            end
            if isKey(obj.props_, 'saml')
                result.saml = obj.props_('saml');
            else
                result.saml = [];
            end
            if isKey(obj.props_, 'wechat')
                result.wechat = obj.props_('wechat');
            else
                result.wechat = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'google')
                    propList.google = obj.props_('google');
                else
                    propList.google = [];
                end
                if isKey(obj.props_, 'auth0')
                    propList.auth0 = obj.props_('auth0');
                else
                    propList.auth0 = [];
                end
                if isKey(obj.props_, 'basic')
                    propList.basic = obj.props_('basic');
                else
                    propList.basic = [];
                end
                if isKey(obj.props_, 'cas')
                    propList.cas = obj.props_('cas');
                else
                    propList.cas = [];
                end
                if isKey(obj.props_, 'ldap')
                    propList.ldap = obj.props_('ldap');
                else
                    propList.ldap = [];
                end
                if isKey(obj.props_, 'mail')
                    propList.mail = obj.props_('mail');
                else
                    propList.mail = [];
                end
                if isKey(obj.props_, 'saml')
                    propList.saml = obj.props_('saml');
                else
                    propList.saml = [];
                end
                if isKey(obj.props_, 'wechat')
                    propList.wechat = obj.props_('wechat');
                else
                    propList.wechat = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AuthOut;
            if isfield(json, 'google')
                obj.props_('google') = flywheel.model.GoogleAuthOut.fromJson(json.google, context);
            end
            if isfield(json, 'auth0')
                obj.props_('auth0') = flywheel.model.Auth0AuthOut.fromJson(json.auth0, context);
            end
            if isfield(json, 'basic')
                obj.props_('basic') = flywheel.ModelBase.deserializeValue(json.basic, 'containers.Map');
            end
            if isfield(json, 'cas')
                obj.props_('cas') = flywheel.ModelBase.deserializeValue(json.cas, 'containers.Map');
            end
            if isfield(json, 'ldap')
                obj.props_('ldap') = flywheel.ModelBase.deserializeValue(json.ldap, 'containers.Map');
            end
            if isfield(json, 'mail')
                obj.props_('mail') = flywheel.ModelBase.deserializeValue(json.mail, 'containers.Map');
            end
            if isfield(json, 'saml')
                obj.props_('saml') = flywheel.ModelBase.deserializeValue(json.saml, 'containers.Map');
            end
            if isfield(json, 'wechat')
                obj.props_('wechat') = flywheel.ModelBase.deserializeValue(json.wechat, 'containers.Map');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AuthOut')
                    obj = flywheel.model.AuthOut(obj);
                end
                if isKey(obj.props_, 'google')
                    obj.props_('google') =  flywheel.model.GoogleAuthOut.ensureIsInstance(obj.props_('google'));
                end
                if isKey(obj.props_, 'auth0')
                    obj.props_('auth0') =  flywheel.model.Auth0AuthOut.ensureIsInstance(obj.props_('auth0'));
                end
                if isKey(obj.props_, 'basic')
                end
                if isKey(obj.props_, 'cas')
                end
                if isKey(obj.props_, 'ldap')
                end
                if isKey(obj.props_, 'mail')
                end
                if isKey(obj.props_, 'saml')
                end
                if isKey(obj.props_, 'wechat')
                end
            end
        end
    end
end
