% AuthSessionOutput
%
% AuthSessionOutput Properties:
%    origin      
%    userId      
%    userIsAdmin 
%    isDevice    
%    roles       
%
% AuthSessionOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AuthSessionOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'origin', 'userId', 'userIsAdmin', 'isDevice', 'roles' }, ...
            { 'origin', 'user_id', 'user_is_admin', 'is_device', 'roles' });
    end
    properties(Dependent)
        origin
        userId
        userIsAdmin
        isDevice
        roles
    end
    methods
        function obj = AuthSessionOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.AuthSessionOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'origin', []);
                addParameter(p, 'userId', []);
                addParameter(p, 'userIsAdmin', []);
                addParameter(p, 'isDevice', []);
                addParameter(p, 'roles', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.userId)
                    obj.props_('user_id') = p.Results.userId;
                end
                if ~isempty(p.Results.userIsAdmin)
                    obj.props_('user_is_admin') = p.Results.userIsAdmin;
                end
                if ~isempty(p.Results.isDevice)
                    obj.props_('is_device') = p.Results.isDevice;
                end
                if ~isempty(p.Results.roles)
                    obj.props_('roles') = p.Results.roles;
                end
            end
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.userId(obj)
            if ismethod(obj, 'get_userId')
                result = obj.get_userId();
            else
                if isKey(obj.props_, 'user_id')
                    result = obj.props_('user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.userId(obj, value)
            obj.props_('user_id') = value;
        end
        function result = get.userIsAdmin(obj)
            if ismethod(obj, 'get_userIsAdmin')
                result = obj.get_userIsAdmin();
            else
                if isKey(obj.props_, 'user_is_admin')
                    result = obj.props_('user_is_admin');
                else
                    result = [];
                end
            end
        end
        function obj = set.userIsAdmin(obj, value)
            obj.props_('user_is_admin') = value;
        end
        function result = get.isDevice(obj)
            if ismethod(obj, 'get_isDevice')
                result = obj.get_isDevice();
            else
                if isKey(obj.props_, 'is_device')
                    result = obj.props_('is_device');
                else
                    result = [];
                end
            end
        end
        function obj = set.isDevice(obj, value)
            obj.props_('is_device') = value;
        end
        function result = get.roles(obj)
            if ismethod(obj, 'get_roles')
                result = obj.get_roles();
            else
                if isKey(obj.props_, 'roles')
                    result = obj.props_('roles');
                else
                    result = [];
                end
            end
        end
        function obj = set.roles(obj, value)
            obj.props_('roles') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'user_id')
                result('user_id') = flywheel.ModelBase.serializeValue(obj.props_('user_id'), 'char');
            end
            if isKey(obj.props_, 'user_is_admin')
                result('user_is_admin') = flywheel.ModelBase.serializeValue(obj.props_('user_is_admin'), 'logical');
            end
            if isKey(obj.props_, 'is_device')
                result('is_device') = flywheel.ModelBase.serializeValue(obj.props_('is_device'), 'logical');
            end
            if isKey(obj.props_, 'roles')
                result('roles') = flywheel.ModelBase.cellmap(@toJson, obj.props_('roles'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'user_id')
                result.userId = obj.props_('user_id');
            else
                result.userId = [];
            end
            if isKey(obj.props_, 'user_is_admin')
                result.userIsAdmin = obj.props_('user_is_admin');
            else
                result.userIsAdmin = [];
            end
            if isKey(obj.props_, 'is_device')
                result.isDevice = obj.props_('is_device');
            else
                result.isDevice = [];
            end
            if isKey(obj.props_, 'roles')
                result.roles = flywheel.ModelBase.cellmap(@struct, obj.props_('roles'));
            else
                result.roles = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'user_id')
                    propList.userId = obj.props_('user_id');
                else
                    propList.userId = [];
                end
                if isKey(obj.props_, 'user_is_admin')
                    propList.userIsAdmin = obj.props_('user_is_admin');
                else
                    propList.userIsAdmin = [];
                end
                if isKey(obj.props_, 'is_device')
                    propList.isDevice = obj.props_('is_device');
                else
                    propList.isDevice = [];
                end
                if isKey(obj.props_, 'roles')
                    propList.roles = obj.props_('roles');
                else
                    propList.roles = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AuthSessionOutput;
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'user_id')
                obj.props_('user_id') = flywheel.ModelBase.deserializeValue(json.user_id, 'char');
            end
            if isfield(json, 'user_is_admin')
                obj.props_('user_is_admin') = flywheel.ModelBase.deserializeValue(json.user_is_admin, 'logical');
            end
            if isfield(json, 'is_device')
                obj.props_('is_device') = flywheel.ModelBase.deserializeValue(json.is_device, 'logical');
            end
            if isfield(json, 'roles')
                obj.props_('roles') = flywheel.ModelBase.cellmap(@(x) flywheel.model.RoleType.fromJson(x, context), json.roles);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AuthSessionOutput')
                    obj = flywheel.model.AuthSessionOutput(obj);
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'user_id')
                end
                if isKey(obj.props_, 'user_is_admin')
                end
                if isKey(obj.props_, 'is_device')
                end
                if isKey(obj.props_, 'roles')
                    obj.props_('roles') = flywheel.ModelBase.cellmap(@flywheel.model.RoleType.ensureIsInstance, obj.props_('roles'));
                end
            end
        end
    end
end
