% AwsCreds - Creds for AWS can be excluded and then they are loaded from the ENV
%
% AwsCreds Properties:
%    awsAccessKeyId     
%    awsSecretAccessKey 
%
% AwsCreds Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AwsCreds < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'awsAccessKeyId', 'awsSecretAccessKey' }, ...
            { 'aws_access_key_id', 'aws_secret_access_key' });
    end
    properties(Dependent)
        awsAccessKeyId
        awsSecretAccessKey
    end
    methods
        function obj = AwsCreds(varargin)
            obj@flywheel.ModelBase(flywheel.model.AwsCreds.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'awsAccessKeyId', []);
                addParameter(p, 'awsSecretAccessKey', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.awsAccessKeyId)
                    obj.props_('aws_access_key_id') = p.Results.awsAccessKeyId;
                end
                if ~isempty(p.Results.awsSecretAccessKey)
                    obj.props_('aws_secret_access_key') = p.Results.awsSecretAccessKey;
                end
            end
        end
        function result = get.awsAccessKeyId(obj)
            if ismethod(obj, 'get_awsAccessKeyId')
                result = obj.get_awsAccessKeyId();
            else
                if isKey(obj.props_, 'aws_access_key_id')
                    result = obj.props_('aws_access_key_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.awsAccessKeyId(obj, value)
            obj.props_('aws_access_key_id') = value;
        end
        function result = get.awsSecretAccessKey(obj)
            if ismethod(obj, 'get_awsSecretAccessKey')
                result = obj.get_awsSecretAccessKey();
            else
                if isKey(obj.props_, 'aws_secret_access_key')
                    result = obj.props_('aws_secret_access_key');
                else
                    result = [];
                end
            end
        end
        function obj = set.awsSecretAccessKey(obj, value)
            obj.props_('aws_secret_access_key') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'aws_access_key_id')
                result('aws_access_key_id') = flywheel.ModelBase.serializeValue(obj.props_('aws_access_key_id'), 'char');
            end
            if isKey(obj.props_, 'aws_secret_access_key')
                result('aws_secret_access_key') = flywheel.ModelBase.serializeValue(obj.props_('aws_secret_access_key'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'aws_access_key_id')
                result.awsAccessKeyId = obj.props_('aws_access_key_id');
            else
                result.awsAccessKeyId = [];
            end
            if isKey(obj.props_, 'aws_secret_access_key')
                result.awsSecretAccessKey = obj.props_('aws_secret_access_key');
            else
                result.awsSecretAccessKey = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'aws_access_key_id')
                    propList.awsAccessKeyId = obj.props_('aws_access_key_id');
                else
                    propList.awsAccessKeyId = [];
                end
                if isKey(obj.props_, 'aws_secret_access_key')
                    propList.awsSecretAccessKey = obj.props_('aws_secret_access_key');
                else
                    propList.awsSecretAccessKey = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AwsCreds;
            if isfield(json, 'aws_access_key_id')
                obj.props_('aws_access_key_id') = flywheel.ModelBase.deserializeValue(json.aws_access_key_id, 'char');
            end
            if isfield(json, 'aws_secret_access_key')
                obj.props_('aws_secret_access_key') = flywheel.ModelBase.deserializeValue(json.aws_secret_access_key, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AwsCreds')
                    obj = flywheel.model.AwsCreds(obj);
                end
                if isKey(obj.props_, 'aws_access_key_id')
                end
                if isKey(obj.props_, 'aws_secret_access_key')
                end
            end
        end
    end
end
