% AwsStorage
%
% AwsStorage Properties:
%    region          
%    bucket          
%    path            
%    zone            
%    endpointUrl     
%    configType      
%    configClass     
%    addressingStyle 
%
% AwsStorage Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AwsStorage < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'region', 'bucket', 'path', 'zone', 'endpointUrl', 'configType', 'configClass', 'addressingStyle' }, ...
            { 'region', 'bucket', 'path', 'zone', 'endpoint_url', 'config_type', 'config_class', 'addressing_style' });
    end
    properties(Dependent)
        region
        bucket
        path
        zone
        endpointUrl
        configType
        configClass
        addressingStyle
    end
    methods
        function obj = AwsStorage(varargin)
            obj@flywheel.ModelBase(flywheel.model.AwsStorage.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'region', []);
                addParameter(p, 'bucket', []);
                addParameter(p, 'path', &#x27;&#x27;);
                addParameter(p, 'zone', []);
                addParameter(p, 'endpointUrl', []);
                addParameter(p, 'configType', &#x27;aws&#x27;);
                addParameter(p, 'configClass', &#x27;storage&#x27;);
                addParameter(p, 'addressingStyle', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.region)
                    obj.props_('region') = p.Results.region;
                end
                if ~isempty(p.Results.bucket)
                    obj.props_('bucket') = p.Results.bucket;
                end
                if ~isempty(p.Results.path)
                    obj.props_('path') = p.Results.path;
                end
                if ~isempty(p.Results.zone)
                    obj.props_('zone') = p.Results.zone;
                end
                if ~isempty(p.Results.endpointUrl)
                    obj.props_('endpoint_url') = p.Results.endpointUrl;
                end
                if ~isempty(p.Results.configType)
                    obj.props_('config_type') = p.Results.configType;
                end
                if ~isempty(p.Results.configClass)
                    obj.props_('config_class') = p.Results.configClass;
                end
                if ~isempty(p.Results.addressingStyle)
                    obj.props_('addressing_style') = p.Results.addressingStyle;
                end
            end
        end
        function result = get.region(obj)
            if ismethod(obj, 'get_region')
                result = obj.get_region();
            else
                if isKey(obj.props_, 'region')
                    result = obj.props_('region');
                else
                    result = [];
                end
            end
        end
        function obj = set.region(obj, value)
            obj.props_('region') = value;
        end
        function result = get.bucket(obj)
            if ismethod(obj, 'get_bucket')
                result = obj.get_bucket();
            else
                if isKey(obj.props_, 'bucket')
                    result = obj.props_('bucket');
                else
                    result = [];
                end
            end
        end
        function obj = set.bucket(obj, value)
            obj.props_('bucket') = value;
        end
        function result = get.path(obj)
            if ismethod(obj, 'get_path')
                result = obj.get_path();
            else
                if isKey(obj.props_, 'path')
                    result = obj.props_('path');
                else
                    result = [];
                end
            end
        end
        function obj = set.path(obj, value)
            obj.props_('path') = value;
        end
        function result = get.zone(obj)
            if ismethod(obj, 'get_zone')
                result = obj.get_zone();
            else
                if isKey(obj.props_, 'zone')
                    result = obj.props_('zone');
                else
                    result = [];
                end
            end
        end
        function obj = set.zone(obj, value)
            obj.props_('zone') = value;
        end
        function result = get.endpointUrl(obj)
            if ismethod(obj, 'get_endpointUrl')
                result = obj.get_endpointUrl();
            else
                if isKey(obj.props_, 'endpoint_url')
                    result = obj.props_('endpoint_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.endpointUrl(obj, value)
            obj.props_('endpoint_url') = value;
        end
        function result = get.configType(obj)
            if ismethod(obj, 'get_configType')
                result = obj.get_configType();
            else
                if isKey(obj.props_, 'config_type')
                    result = obj.props_('config_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.configType(obj, value)
            obj.props_('config_type') = value;
        end
        function result = get.configClass(obj)
            if ismethod(obj, 'get_configClass')
                result = obj.get_configClass();
            else
                if isKey(obj.props_, 'config_class')
                    result = obj.props_('config_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.configClass(obj, value)
            obj.props_('config_class') = value;
        end
        function result = get.addressingStyle(obj)
            if ismethod(obj, 'get_addressingStyle')
                result = obj.get_addressingStyle();
            else
                if isKey(obj.props_, 'addressing_style')
                    result = obj.props_('addressing_style');
                else
                    result = [];
                end
            end
        end
        function obj = set.addressingStyle(obj, value)
            obj.props_('addressing_style') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'region')
                result('region') = flywheel.ModelBase.serializeValue(obj.props_('region'), 'char');
            end
            if isKey(obj.props_, 'bucket')
                result('bucket') = flywheel.ModelBase.serializeValue(obj.props_('bucket'), 'char');
            end
            if isKey(obj.props_, 'path')
                result('path') = flywheel.ModelBase.serializeValue(obj.props_('path'), 'char');
            end
            if isKey(obj.props_, 'zone')
                result('zone') = flywheel.ModelBase.serializeValue(obj.props_('zone'), 'char');
            end
            if isKey(obj.props_, 'endpoint_url')
                result('endpoint_url') = flywheel.ModelBase.serializeValue(obj.props_('endpoint_url'), 'char');
            end
            if isKey(obj.props_, 'config_type')
                result('config_type') = flywheel.ModelBase.serializeValue(obj.props_('config_type'), 'char');
            end
            if isKey(obj.props_, 'config_class')
                result('config_class') = flywheel.ModelBase.serializeValue(obj.props_('config_class'), 'char');
            end
            if isKey(obj.props_, 'addressing_style')
                result('addressing_style') = obj.props_('addressing_style').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'region')
                result.region = obj.props_('region');
            else
                result.region = [];
            end
            if isKey(obj.props_, 'bucket')
                result.bucket = obj.props_('bucket');
            else
                result.bucket = [];
            end
            if isKey(obj.props_, 'path')
                result.path = obj.props_('path');
            else
                result.path = [];
            end
            if isKey(obj.props_, 'zone')
                result.zone = obj.props_('zone');
            else
                result.zone = [];
            end
            if isKey(obj.props_, 'endpoint_url')
                result.endpointUrl = obj.props_('endpoint_url');
            else
                result.endpointUrl = [];
            end
            if isKey(obj.props_, 'config_type')
                result.configType = obj.props_('config_type');
            else
                result.configType = [];
            end
            if isKey(obj.props_, 'config_class')
                result.configClass = obj.props_('config_class');
            else
                result.configClass = [];
            end
            if isKey(obj.props_, 'addressing_style')
                result.addressingStyle = struct(obj.props_('addressing_style'));
            else
                result.addressingStyle = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'region')
                    propList.region = obj.props_('region');
                else
                    propList.region = [];
                end
                if isKey(obj.props_, 'bucket')
                    propList.bucket = obj.props_('bucket');
                else
                    propList.bucket = [];
                end
                if isKey(obj.props_, 'path')
                    propList.path = obj.props_('path');
                else
                    propList.path = [];
                end
                if isKey(obj.props_, 'zone')
                    propList.zone = obj.props_('zone');
                else
                    propList.zone = [];
                end
                if isKey(obj.props_, 'endpoint_url')
                    propList.endpointUrl = obj.props_('endpoint_url');
                else
                    propList.endpointUrl = [];
                end
                if isKey(obj.props_, 'config_type')
                    propList.configType = obj.props_('config_type');
                else
                    propList.configType = [];
                end
                if isKey(obj.props_, 'config_class')
                    propList.configClass = obj.props_('config_class');
                else
                    propList.configClass = [];
                end
                if isKey(obj.props_, 'addressing_style')
                    propList.addressingStyle = obj.props_('addressing_style');
                else
                    propList.addressingStyle = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AwsStorage;
            if isfield(json, 'region')
                obj.props_('region') = flywheel.ModelBase.deserializeValue(json.region, 'char');
            end
            if isfield(json, 'bucket')
                obj.props_('bucket') = flywheel.ModelBase.deserializeValue(json.bucket, 'char');
            end
            if isfield(json, 'path')
                obj.props_('path') = flywheel.ModelBase.deserializeValue(json.path, 'char');
            end
            if isfield(json, 'zone')
                obj.props_('zone') = flywheel.ModelBase.deserializeValue(json.zone, 'char');
            end
            if isfield(json, 'endpoint_url')
                obj.props_('endpoint_url') = flywheel.ModelBase.deserializeValue(json.endpoint_url, 'char');
            end
            if isfield(json, 'config_type')
                obj.props_('config_type') = flywheel.ModelBase.deserializeValue(json.config_type, 'char');
            end
            if isfield(json, 'config_class')
                obj.props_('config_class') = flywheel.ModelBase.deserializeValue(json.config_class, 'char');
            end
            if isfield(json, 'addressing_style')
                obj.props_('addressing_style') = flywheel.model.AllOfAwsStorageAddressingStyle.fromJson(json.addressing_style, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AwsStorage')
                    obj = flywheel.model.AwsStorage(obj);
                end
                if isKey(obj.props_, 'region')
                end
                if isKey(obj.props_, 'bucket')
                end
                if isKey(obj.props_, 'path')
                end
                if isKey(obj.props_, 'zone')
                end
                if isKey(obj.props_, 'endpoint_url')
                end
                if isKey(obj.props_, 'config_type')
                end
                if isKey(obj.props_, 'config_class')
                end
                if isKey(obj.props_, 'addressing_style')
                    obj.props_('addressing_style') =  flywheel.model.AllOfAwsStorageAddressingStyle.ensureIsInstance(obj.props_('addressing_style'));
                end
            end
        end
    end
end
