% AzureCreds - Creds for Azure can be excluded and then they are loaded from the ENV
%
% AzureCreds Properties:
%    azureAccountName 
%    azureAccountKey  
%
% AzureCreds Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureCreds < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'azureAccountName', 'azureAccountKey' }, ...
            { 'azure_account_name', 'azure_account_key' });
    end
    properties(Dependent)
        azureAccountName
        azureAccountKey
    end
    methods
        function obj = AzureCreds(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureCreds.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'azureAccountName', []);
                addParameter(p, 'azureAccountKey', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.azureAccountName)
                    obj.props_('azure_account_name') = p.Results.azureAccountName;
                end
                if ~isempty(p.Results.azureAccountKey)
                    obj.props_('azure_account_key') = p.Results.azureAccountKey;
                end
            end
        end
        function result = get.azureAccountName(obj)
            if ismethod(obj, 'get_azureAccountName')
                result = obj.get_azureAccountName();
            else
                if isKey(obj.props_, 'azure_account_name')
                    result = obj.props_('azure_account_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.azureAccountName(obj, value)
            obj.props_('azure_account_name') = value;
        end
        function result = get.azureAccountKey(obj)
            if ismethod(obj, 'get_azureAccountKey')
                result = obj.get_azureAccountKey();
            else
                if isKey(obj.props_, 'azure_account_key')
                    result = obj.props_('azure_account_key');
                else
                    result = [];
                end
            end
        end
        function obj = set.azureAccountKey(obj, value)
            obj.props_('azure_account_key') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'azure_account_name')
                result('azure_account_name') = flywheel.ModelBase.serializeValue(obj.props_('azure_account_name'), 'char');
            end
            if isKey(obj.props_, 'azure_account_key')
                result('azure_account_key') = flywheel.ModelBase.serializeValue(obj.props_('azure_account_key'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'azure_account_name')
                result.azureAccountName = obj.props_('azure_account_name');
            else
                result.azureAccountName = [];
            end
            if isKey(obj.props_, 'azure_account_key')
                result.azureAccountKey = obj.props_('azure_account_key');
            else
                result.azureAccountKey = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'azure_account_name')
                    propList.azureAccountName = obj.props_('azure_account_name');
                else
                    propList.azureAccountName = [];
                end
                if isKey(obj.props_, 'azure_account_key')
                    propList.azureAccountKey = obj.props_('azure_account_key');
                else
                    propList.azureAccountKey = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureCreds;
            if isfield(json, 'azure_account_name')
                obj.props_('azure_account_name') = flywheel.ModelBase.deserializeValue(json.azure_account_name, 'char');
            end
            if isfield(json, 'azure_account_key')
                obj.props_('azure_account_key') = flywheel.ModelBase.deserializeValue(json.azure_account_key, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureCreds')
                    obj = flywheel.model.AzureCreds(obj);
                end
                if isKey(obj.props_, 'azure_account_name')
                end
                if isKey(obj.props_, 'azure_account_key')
                end
            end
        end
    end
end
