% AzureMLAccount
%
% AzureMLAccount Properties:
%    email     
%    onboarded 
%
% AzureMLAccount Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureMLAccount < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'email', 'onboarded' }, ...
            { 'email', 'onboarded' });
    end
    properties(Dependent)
        email
        onboarded
    end
    methods
        function obj = AzureMLAccount(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureMLAccount.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'email', []);
                addParameter(p, 'onboarded', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.email)
                    obj.props_('email') = p.Results.email;
                end
                if ~isempty(p.Results.onboarded)
                    obj.props_('onboarded') = p.Results.onboarded;
                end
            end
        end
        function result = get.email(obj)
            if ismethod(obj, 'get_email')
                result = obj.get_email();
            else
                if isKey(obj.props_, 'email')
                    result = obj.props_('email');
                else
                    result = [];
                end
            end
        end
        function obj = set.email(obj, value)
            obj.props_('email') = value;
        end
        function result = get.onboarded(obj)
            if ismethod(obj, 'get_onboarded')
                result = obj.get_onboarded();
            else
                if isKey(obj.props_, 'onboarded')
                    result = obj.props_('onboarded');
                else
                    result = [];
                end
            end
        end
        function obj = set.onboarded(obj, value)
            obj.props_('onboarded') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'email')
                result('email') = flywheel.ModelBase.serializeValue(obj.props_('email'), 'char');
            end
            if isKey(obj.props_, 'onboarded')
                result('onboarded') = flywheel.ModelBase.serializeValue(obj.props_('onboarded'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'email')
                result.email = obj.props_('email');
            else
                result.email = [];
            end
            if isKey(obj.props_, 'onboarded')
                result.onboarded = obj.props_('onboarded');
            else
                result.onboarded = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'email')
                    propList.email = obj.props_('email');
                else
                    propList.email = [];
                end
                if isKey(obj.props_, 'onboarded')
                    propList.onboarded = obj.props_('onboarded');
                else
                    propList.onboarded = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureMLAccount;
            if isfield(json, 'email')
                obj.props_('email') = flywheel.ModelBase.deserializeValue(json.email, 'char');
            end
            if isfield(json, 'onboarded')
                obj.props_('onboarded') = flywheel.ModelBase.deserializeValue(json.onboarded, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureMLAccount')
                    obj = flywheel.model.AzureMLAccount(obj);
                end
                if isKey(obj.props_, 'email')
                end
                if isKey(obj.props_, 'onboarded')
                end
            end
        end
    end
end
