% AzureMLInitialization
%
% AzureMLInitialization Properties:
%    resources           
%    xferStorage         
%    userRoleAssignments 
%    computeInstances    
%
% AzureMLInitialization Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureMLInitialization < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'resources', 'xferStorage', 'userRoleAssignments', 'computeInstances' }, ...
            { 'resources', 'xfer_storage', 'user_role_assignments', 'compute_instances' });
    end
    properties(Dependent)
        resources
        xferStorage
        userRoleAssignments
        computeInstances
    end
    methods
        function obj = AzureMLInitialization(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureMLInitialization.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'resources', []);
                addParameter(p, 'xferStorage', []);
                addParameter(p, 'userRoleAssignments', []);
                addParameter(p, 'computeInstances', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.resources)
                    obj.props_('resources') = p.Results.resources;
                end
                if ~isempty(p.Results.xferStorage)
                    obj.props_('xfer_storage') = p.Results.xferStorage;
                end
                if ~isempty(p.Results.userRoleAssignments)
                    obj.props_('user_role_assignments') = p.Results.userRoleAssignments;
                end
                if ~isempty(p.Results.computeInstances)
                    obj.props_('compute_instances') = p.Results.computeInstances;
                end
            end
        end
        function result = get.resources(obj)
            if ismethod(obj, 'get_resources')
                result = obj.get_resources();
            else
                if isKey(obj.props_, 'resources')
                    result = obj.props_('resources');
                else
                    result = [];
                end
            end
        end
        function obj = set.resources(obj, value)
            obj.props_('resources') = value;
        end
        function result = get.xferStorage(obj)
            if ismethod(obj, 'get_xferStorage')
                result = obj.get_xferStorage();
            else
                if isKey(obj.props_, 'xfer_storage')
                    result = obj.props_('xfer_storage');
                else
                    result = [];
                end
            end
        end
        function obj = set.xferStorage(obj, value)
            obj.props_('xfer_storage') = value;
        end
        function result = get.userRoleAssignments(obj)
            if ismethod(obj, 'get_userRoleAssignments')
                result = obj.get_userRoleAssignments();
            else
                if isKey(obj.props_, 'user_role_assignments')
                    result = obj.props_('user_role_assignments');
                else
                    result = [];
                end
            end
        end
        function obj = set.userRoleAssignments(obj, value)
            obj.props_('user_role_assignments') = value;
        end
        function result = get.computeInstances(obj)
            if ismethod(obj, 'get_computeInstances')
                result = obj.get_computeInstances();
            else
                if isKey(obj.props_, 'compute_instances')
                    result = obj.props_('compute_instances');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeInstances(obj, value)
            obj.props_('compute_instances') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'resources')
                result('resources') = obj.props_('resources').toJson();
            end
            if isKey(obj.props_, 'xfer_storage')
                result('xfer_storage') = obj.props_('xfer_storage').toJson();
            end
            if isKey(obj.props_, 'user_role_assignments')
                result('user_role_assignments') = obj.props_('user_role_assignments').toJson();
            end
            if isKey(obj.props_, 'compute_instances')
                result('compute_instances') = obj.props_('compute_instances').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'resources')
                result.resources = struct(obj.props_('resources'));
            else
                result.resources = [];
            end
            if isKey(obj.props_, 'xfer_storage')
                result.xferStorage = struct(obj.props_('xfer_storage'));
            else
                result.xferStorage = [];
            end
            if isKey(obj.props_, 'user_role_assignments')
                result.userRoleAssignments = struct(obj.props_('user_role_assignments'));
            else
                result.userRoleAssignments = [];
            end
            if isKey(obj.props_, 'compute_instances')
                result.computeInstances = struct(obj.props_('compute_instances'));
            else
                result.computeInstances = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'resources')
                    propList.resources = obj.props_('resources');
                else
                    propList.resources = [];
                end
                if isKey(obj.props_, 'xfer_storage')
                    propList.xferStorage = obj.props_('xfer_storage');
                else
                    propList.xferStorage = [];
                end
                if isKey(obj.props_, 'user_role_assignments')
                    propList.userRoleAssignments = obj.props_('user_role_assignments');
                else
                    propList.userRoleAssignments = [];
                end
                if isKey(obj.props_, 'compute_instances')
                    propList.computeInstances = obj.props_('compute_instances');
                else
                    propList.computeInstances = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureMLInitialization;
            if isfield(json, 'resources')
                obj.props_('resources') = flywheel.model.AllOfAzureMLInitializationResources.fromJson(json.resources, context);
            end
            if isfield(json, 'xfer_storage')
                obj.props_('xfer_storage') = flywheel.model.AllOfAzureMLInitializationXferStorage.fromJson(json.xfer_storage, context);
            end
            if isfield(json, 'user_role_assignments')
                obj.props_('user_role_assignments') = flywheel.model.AllOfAzureMLInitializationUserRoleAssignments.fromJson(json.user_role_assignments, context);
            end
            if isfield(json, 'compute_instances')
                obj.props_('compute_instances') = flywheel.model.AllOfAzureMLInitializationComputeInstances.fromJson(json.compute_instances, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureMLInitialization')
                    obj = flywheel.model.AzureMLInitialization(obj);
                end
                if isKey(obj.props_, 'resources')
                    obj.props_('resources') =  flywheel.model.AllOfAzureMLInitializationResources.ensureIsInstance(obj.props_('resources'));
                end
                if isKey(obj.props_, 'xfer_storage')
                    obj.props_('xfer_storage') =  flywheel.model.AllOfAzureMLInitializationXferStorage.ensureIsInstance(obj.props_('xfer_storage'));
                end
                if isKey(obj.props_, 'user_role_assignments')
                    obj.props_('user_role_assignments') =  flywheel.model.AllOfAzureMLInitializationUserRoleAssignments.ensureIsInstance(obj.props_('user_role_assignments'));
                end
                if isKey(obj.props_, 'compute_instances')
                    obj.props_('compute_instances') =  flywheel.model.AllOfAzureMLInitializationComputeInstances.ensureIsInstance(obj.props_('compute_instances'));
                end
            end
        end
    end
end
