% AzureMLIntegration
%
% AzureMLIntegration Properties:
%    enabled               
%    workspace             
%    azuremlInitialization 
%
% AzureMLIntegration Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureMLIntegration < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'enabled', 'workspace', 'azuremlInitialization' }, ...
            { 'enabled', 'workspace', 'azureml_initialization' });
    end
    properties(Dependent)
        enabled
        workspace
        azuremlInitialization
    end
    methods
        function obj = AzureMLIntegration(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureMLIntegration.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'enabled', []);
                addParameter(p, 'workspace', []);
                addParameter(p, 'azuremlInitialization', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.enabled)
                    obj.props_('enabled') = p.Results.enabled;
                end
                if ~isempty(p.Results.workspace)
                    obj.props_('workspace') = p.Results.workspace;
                end
                if ~isempty(p.Results.azuremlInitialization)
                    obj.props_('azureml_initialization') = p.Results.azuremlInitialization;
                end
            end
        end
        function result = get.enabled(obj)
            if ismethod(obj, 'get_enabled')
                result = obj.get_enabled();
            else
                if isKey(obj.props_, 'enabled')
                    result = obj.props_('enabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.enabled(obj, value)
            obj.props_('enabled') = value;
        end
        function result = get.workspace(obj)
            if ismethod(obj, 'get_workspace')
                result = obj.get_workspace();
            else
                if isKey(obj.props_, 'workspace')
                    result = obj.props_('workspace');
                else
                    result = [];
                end
            end
        end
        function obj = set.workspace(obj, value)
            obj.props_('workspace') = value;
        end
        function result = get.azuremlInitialization(obj)
            if ismethod(obj, 'get_azuremlInitialization')
                result = obj.get_azuremlInitialization();
            else
                if isKey(obj.props_, 'azureml_initialization')
                    result = obj.props_('azureml_initialization');
                else
                    result = [];
                end
            end
        end
        function obj = set.azuremlInitialization(obj, value)
            obj.props_('azureml_initialization') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'enabled')
                result('enabled') = flywheel.ModelBase.serializeValue(obj.props_('enabled'), 'logical');
            end
            if isKey(obj.props_, 'workspace')
                result('workspace') = obj.props_('workspace').toJson();
            end
            if isKey(obj.props_, 'azureml_initialization')
                result('azureml_initialization') = obj.props_('azureml_initialization').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'enabled')
                result.enabled = obj.props_('enabled');
            else
                result.enabled = [];
            end
            if isKey(obj.props_, 'workspace')
                result.workspace = struct(obj.props_('workspace'));
            else
                result.workspace = [];
            end
            if isKey(obj.props_, 'azureml_initialization')
                result.azuremlInitialization = struct(obj.props_('azureml_initialization'));
            else
                result.azuremlInitialization = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'enabled')
                    propList.enabled = obj.props_('enabled');
                else
                    propList.enabled = [];
                end
                if isKey(obj.props_, 'workspace')
                    propList.workspace = obj.props_('workspace');
                else
                    propList.workspace = [];
                end
                if isKey(obj.props_, 'azureml_initialization')
                    propList.azuremlInitialization = obj.props_('azureml_initialization');
                else
                    propList.azuremlInitialization = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureMLIntegration;
            if isfield(json, 'enabled')
                obj.props_('enabled') = flywheel.ModelBase.deserializeValue(json.enabled, 'logical');
            end
            if isfield(json, 'workspace')
                obj.props_('workspace') = flywheel.model.AnyOfAzureMLIntegrationWorkspace.fromJson(json.workspace, context);
            end
            if isfield(json, 'azureml_initialization')
                obj.props_('azureml_initialization') = flywheel.model.AzureMLInitialization.fromJson(json.azureml_initialization, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureMLIntegration')
                    obj = flywheel.model.AzureMLIntegration(obj);
                end
                if isKey(obj.props_, 'enabled')
                end
                if isKey(obj.props_, 'workspace')
                    obj.props_('workspace') =  flywheel.model.AnyOfAzureMLIntegrationWorkspace.ensureIsInstance(obj.props_('workspace'));
                end
                if isKey(obj.props_, 'azureml_initialization')
                    obj.props_('azureml_initialization') =  flywheel.model.AzureMLInitialization.ensureIsInstance(obj.props_('azureml_initialization'));
                end
            end
        end
    end
end
