% AzureMLWorkspace - Model for the output of data when getting or creating a workspace
%
% AzureMLWorkspace Properties:
%    name          
%    displayName   
%    resourceGroup 
%    subscription  
%    url           
%    created       
%    origin        
%    projectId     
%
% AzureMLWorkspace Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureMLWorkspace < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'name', 'displayName', 'resourceGroup', 'subscription', 'url', 'created', 'origin', 'projectId' }, ...
            { 'name', 'display_name', 'resource_group', 'subscription', 'url', 'created', 'origin', 'project_id' });
    end
    properties(Dependent)
        name
        displayName
        resourceGroup
        subscription
        url
        created
        origin
        projectId
    end
    methods
        function obj = AzureMLWorkspace(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureMLWorkspace.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'name', []);
                addParameter(p, 'displayName', []);
                addParameter(p, 'resourceGroup', []);
                addParameter(p, 'subscription', []);
                addParameter(p, 'url', []);
                addParameter(p, 'created', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'projectId', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.displayName)
                    obj.props_('display_name') = p.Results.displayName;
                end
                if ~isempty(p.Results.resourceGroup)
                    obj.props_('resource_group') = p.Results.resourceGroup;
                end
                if ~isempty(p.Results.subscription)
                    obj.props_('subscription') = p.Results.subscription;
                end
                if ~isempty(p.Results.url)
                    obj.props_('url') = p.Results.url;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
            end
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.displayName(obj)
            if ismethod(obj, 'get_displayName')
                result = obj.get_displayName();
            else
                if isKey(obj.props_, 'display_name')
                    result = obj.props_('display_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.displayName(obj, value)
            obj.props_('display_name') = value;
        end
        function result = get.resourceGroup(obj)
            if ismethod(obj, 'get_resourceGroup')
                result = obj.get_resourceGroup();
            else
                if isKey(obj.props_, 'resource_group')
                    result = obj.props_('resource_group');
                else
                    result = [];
                end
            end
        end
        function obj = set.resourceGroup(obj, value)
            obj.props_('resource_group') = value;
        end
        function result = get.subscription(obj)
            if ismethod(obj, 'get_subscription')
                result = obj.get_subscription();
            else
                if isKey(obj.props_, 'subscription')
                    result = obj.props_('subscription');
                else
                    result = [];
                end
            end
        end
        function obj = set.subscription(obj, value)
            obj.props_('subscription') = value;
        end
        function result = get.url(obj)
            if ismethod(obj, 'get_url')
                result = obj.get_url();
            else
                if isKey(obj.props_, 'url')
                    result = obj.props_('url');
                else
                    result = [];
                end
            end
        end
        function obj = set.url(obj, value)
            obj.props_('url') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'display_name')
                result('display_name') = flywheel.ModelBase.serializeValue(obj.props_('display_name'), 'char');
            end
            if isKey(obj.props_, 'resource_group')
                result('resource_group') = flywheel.ModelBase.serializeValue(obj.props_('resource_group'), 'char');
            end
            if isKey(obj.props_, 'subscription')
                result('subscription') = flywheel.ModelBase.serializeValue(obj.props_('subscription'), 'char');
            end
            if isKey(obj.props_, 'url')
                result('url') = flywheel.ModelBase.serializeValue(obj.props_('url'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'display_name')
                result.displayName = obj.props_('display_name');
            else
                result.displayName = [];
            end
            if isKey(obj.props_, 'resource_group')
                result.resourceGroup = obj.props_('resource_group');
            else
                result.resourceGroup = [];
            end
            if isKey(obj.props_, 'subscription')
                result.subscription = obj.props_('subscription');
            else
                result.subscription = [];
            end
            if isKey(obj.props_, 'url')
                result.url = obj.props_('url');
            else
                result.url = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'display_name')
                    propList.displayName = obj.props_('display_name');
                else
                    propList.displayName = [];
                end
                if isKey(obj.props_, 'resource_group')
                    propList.resourceGroup = obj.props_('resource_group');
                else
                    propList.resourceGroup = [];
                end
                if isKey(obj.props_, 'subscription')
                    propList.subscription = obj.props_('subscription');
                else
                    propList.subscription = [];
                end
                if isKey(obj.props_, 'url')
                    propList.url = obj.props_('url');
                else
                    propList.url = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureMLWorkspace;
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'display_name')
                obj.props_('display_name') = flywheel.ModelBase.deserializeValue(json.display_name, 'char');
            end
            if isfield(json, 'resource_group')
                obj.props_('resource_group') = flywheel.ModelBase.deserializeValue(json.resource_group, 'char');
            end
            if isfield(json, 'subscription')
                obj.props_('subscription') = flywheel.ModelBase.deserializeValue(json.subscription, 'char');
            end
            if isfield(json, 'url')
                obj.props_('url') = flywheel.ModelBase.deserializeValue(json.url, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureMLWorkspace')
                    obj = flywheel.model.AzureMLWorkspace(obj);
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'display_name')
                end
                if isKey(obj.props_, 'resource_group')
                end
                if isKey(obj.props_, 'subscription')
                end
                if isKey(obj.props_, 'url')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'project_id')
                end
            end
        end
    end
end
