% AzureMLWorkspaceInput - Model for the input of data when getting, creating or deleting a workspace
%
% AzureMLWorkspaceInput Properties:
%    name        
%    displayName 
%
% AzureMLWorkspaceInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef AzureMLWorkspaceInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'name', 'displayName' }, ...
            { 'name', 'display_name' });
    end
    properties(Dependent)
        name
        displayName
    end
    methods
        function obj = AzureMLWorkspaceInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.AzureMLWorkspaceInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'name', []);
                addParameter(p, 'displayName', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.displayName)
                    obj.props_('display_name') = p.Results.displayName;
                end
            end
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.displayName(obj)
            if ismethod(obj, 'get_displayName')
                result = obj.get_displayName();
            else
                if isKey(obj.props_, 'display_name')
                    result = obj.props_('display_name');
                else
                    result = [];
                end
            end
        end
        function obj = set.displayName(obj, value)
            obj.props_('display_name') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'display_name')
                result('display_name') = flywheel.ModelBase.serializeValue(obj.props_('display_name'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'display_name')
                result.displayName = obj.props_('display_name');
            else
                result.displayName = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'display_name')
                    propList.displayName = obj.props_('display_name');
                else
                    propList.displayName = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.AzureMLWorkspaceInput;
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'display_name')
                obj.props_('display_name') = flywheel.ModelBase.deserializeValue(json.display_name, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.AzureMLWorkspaceInput')
                    obj = flywheel.model.AzureMLWorkspaceInput(obj);
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'display_name')
                end
            end
        end
    end
end
