% BaseAET
%
% BaseAET Properties:
%    id      
%    created 
%    aet      - DICOM Application Entity Title
%    creator  - Database ID of a user
%
% BaseAET Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef BaseAET < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'created', 'aet', 'creator' }, ...
            { '_id', 'created', 'aet', 'creator' });
    end
    properties(Dependent)
        id
        created
        aet
        creator
    end
    methods
        function obj = BaseAET(varargin)
            obj@flywheel.ModelBase(flywheel.model.BaseAET.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'created', []);
                addParameter(p, 'aet', []);
                addParameter(p, 'creator', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.aet)
                    obj.props_('aet') = p.Results.aet;
                end
                if ~isempty(p.Results.creator)
                    obj.props_('creator') = p.Results.creator;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.aet(obj)
            if ismethod(obj, 'get_aet')
                result = obj.get_aet();
            else
                if isKey(obj.props_, 'aet')
                    result = obj.props_('aet');
                else
                    result = [];
                end
            end
        end
        function obj = set.aet(obj, value)
            obj.props_('aet') = value;
        end
        function result = get.creator(obj)
            if ismethod(obj, 'get_creator')
                result = obj.get_creator();
            else
                if isKey(obj.props_, 'creator')
                    result = obj.props_('creator');
                else
                    result = [];
                end
            end
        end
        function obj = set.creator(obj, value)
            obj.props_('creator') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'aet')
                result('aet') = flywheel.ModelBase.serializeValue(obj.props_('aet'), 'char');
            end
            if isKey(obj.props_, 'creator')
                result('creator') = flywheel.ModelBase.serializeValue(obj.props_('creator'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'aet')
                result.aet = obj.props_('aet');
            else
                result.aet = [];
            end
            if isKey(obj.props_, 'creator')
                result.creator = obj.props_('creator');
            else
                result.creator = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'aet')
                    propList.aet = obj.props_('aet');
                else
                    propList.aet = [];
                end
                if isKey(obj.props_, 'creator')
                    propList.creator = obj.props_('creator');
                else
                    propList.creator = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.BaseAET;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'aet')
                obj.props_('aet') = flywheel.ModelBase.deserializeValue(json.aet, 'char');
            end
            if isfield(json, 'creator')
                obj.props_('creator') = flywheel.ModelBase.deserializeValue(json.creator, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.BaseAET')
                    obj = flywheel.model.BaseAET(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'aet')
                end
                if isKey(obj.props_, 'creator')
                end
            end
        end
    end
end
