% BaseCompute
%
% BaseCompute Properties:
%    queueThreshold 
%    maxCompute     
%    machineType    
%    diskSize       
%    swapSize       
%    preemptible    
%    zone           
%    region         
%    tags           
%    configType     
%    configClass    
%
% BaseCompute Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef BaseCompute < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'queueThreshold', 'maxCompute', 'machineType', 'diskSize', 'swapSize', 'preemptible', 'zone', 'region', 'tags', 'configType', 'configClass' }, ...
            { 'queue_threshold', 'max_compute', 'machine_type', 'disk_size', 'swap_size', 'preemptible', 'zone', 'region', 'tags', 'config_type', 'config_class' });
    end
    properties(Dependent)
        queueThreshold
        maxCompute
        machineType
        diskSize
        swapSize
        preemptible
        zone
        region
        tags
        configType
        configClass
    end
    methods
        function obj = BaseCompute(varargin)
            obj@flywheel.ModelBase(flywheel.model.BaseCompute.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'queueThreshold', []);
                addParameter(p, 'maxCompute', []);
                addParameter(p, 'machineType', []);
                addParameter(p, 'diskSize', []);
                addParameter(p, 'swapSize', &#x27;30G&#x27;);
                addParameter(p, 'preemptible', []);
                addParameter(p, 'zone', []);
                addParameter(p, 'region', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'configType', []);
                addParameter(p, 'configClass', &#x27;compute&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.queueThreshold)
                    obj.props_('queue_threshold') = p.Results.queueThreshold;
                end
                if ~isempty(p.Results.maxCompute)
                    obj.props_('max_compute') = p.Results.maxCompute;
                end
                if ~isempty(p.Results.machineType)
                    obj.props_('machine_type') = p.Results.machineType;
                end
                if ~isempty(p.Results.diskSize)
                    obj.props_('disk_size') = p.Results.diskSize;
                end
                if ~isempty(p.Results.swapSize)
                    obj.props_('swap_size') = p.Results.swapSize;
                end
                if ~isempty(p.Results.preemptible)
                    obj.props_('preemptible') = p.Results.preemptible;
                end
                if ~isempty(p.Results.zone)
                    obj.props_('zone') = p.Results.zone;
                end
                if ~isempty(p.Results.region)
                    obj.props_('region') = p.Results.region;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.configType)
                    obj.props_('config_type') = p.Results.configType;
                end
                if ~isempty(p.Results.configClass)
                    obj.props_('config_class') = p.Results.configClass;
                end
            end
        end
        function result = get.queueThreshold(obj)
            if ismethod(obj, 'get_queueThreshold')
                result = obj.get_queueThreshold();
            else
                if isKey(obj.props_, 'queue_threshold')
                    result = obj.props_('queue_threshold');
                else
                    result = [];
                end
            end
        end
        function obj = set.queueThreshold(obj, value)
            obj.props_('queue_threshold') = value;
        end
        function result = get.maxCompute(obj)
            if ismethod(obj, 'get_maxCompute')
                result = obj.get_maxCompute();
            else
                if isKey(obj.props_, 'max_compute')
                    result = obj.props_('max_compute');
                else
                    result = [];
                end
            end
        end
        function obj = set.maxCompute(obj, value)
            obj.props_('max_compute') = value;
        end
        function result = get.machineType(obj)
            if ismethod(obj, 'get_machineType')
                result = obj.get_machineType();
            else
                if isKey(obj.props_, 'machine_type')
                    result = obj.props_('machine_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.machineType(obj, value)
            obj.props_('machine_type') = value;
        end
        function result = get.diskSize(obj)
            if ismethod(obj, 'get_diskSize')
                result = obj.get_diskSize();
            else
                if isKey(obj.props_, 'disk_size')
                    result = obj.props_('disk_size');
                else
                    result = [];
                end
            end
        end
        function obj = set.diskSize(obj, value)
            obj.props_('disk_size') = value;
        end
        function result = get.swapSize(obj)
            if ismethod(obj, 'get_swapSize')
                result = obj.get_swapSize();
            else
                if isKey(obj.props_, 'swap_size')
                    result = obj.props_('swap_size');
                else
                    result = [];
                end
            end
        end
        function obj = set.swapSize(obj, value)
            obj.props_('swap_size') = value;
        end
        function result = get.preemptible(obj)
            if ismethod(obj, 'get_preemptible')
                result = obj.get_preemptible();
            else
                if isKey(obj.props_, 'preemptible')
                    result = obj.props_('preemptible');
                else
                    result = [];
                end
            end
        end
        function obj = set.preemptible(obj, value)
            obj.props_('preemptible') = value;
        end
        function result = get.zone(obj)
            if ismethod(obj, 'get_zone')
                result = obj.get_zone();
            else
                if isKey(obj.props_, 'zone')
                    result = obj.props_('zone');
                else
                    result = [];
                end
            end
        end
        function obj = set.zone(obj, value)
            obj.props_('zone') = value;
        end
        function result = get.region(obj)
            if ismethod(obj, 'get_region')
                result = obj.get_region();
            else
                if isKey(obj.props_, 'region')
                    result = obj.props_('region');
                else
                    result = [];
                end
            end
        end
        function obj = set.region(obj, value)
            obj.props_('region') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.configType(obj)
            if ismethod(obj, 'get_configType')
                result = obj.get_configType();
            else
                if isKey(obj.props_, 'config_type')
                    result = obj.props_('config_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.configType(obj, value)
            obj.props_('config_type') = value;
        end
        function result = get.configClass(obj)
            if ismethod(obj, 'get_configClass')
                result = obj.get_configClass();
            else
                if isKey(obj.props_, 'config_class')
                    result = obj.props_('config_class');
                else
                    result = [];
                end
            end
        end
        function obj = set.configClass(obj, value)
            obj.props_('config_class') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'queue_threshold')
                result('queue_threshold') = flywheel.ModelBase.serializeValue(obj.props_('queue_threshold'), 'integer');
            end
            if isKey(obj.props_, 'max_compute')
                result('max_compute') = flywheel.ModelBase.serializeValue(obj.props_('max_compute'), 'integer');
            end
            if isKey(obj.props_, 'machine_type')
                result('machine_type') = flywheel.ModelBase.serializeValue(obj.props_('machine_type'), 'char');
            end
            if isKey(obj.props_, 'disk_size')
                result('disk_size') = flywheel.ModelBase.serializeValue(obj.props_('disk_size'), 'integer');
            end
            if isKey(obj.props_, 'swap_size')
                result('swap_size') = flywheel.ModelBase.serializeValue(obj.props_('swap_size'), 'char');
            end
            if isKey(obj.props_, 'preemptible')
                result('preemptible') = flywheel.ModelBase.serializeValue(obj.props_('preemptible'), 'logical');
            end
            if isKey(obj.props_, 'zone')
                result('zone') = flywheel.ModelBase.serializeValue(obj.props_('zone'), 'char');
            end
            if isKey(obj.props_, 'region')
                result('region') = flywheel.ModelBase.serializeValue(obj.props_('region'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'containers.Map');
            end
            if isKey(obj.props_, 'config_type')
                result('config_type') = flywheel.ModelBase.serializeValue(obj.props_('config_type'), 'char');
            end
            if isKey(obj.props_, 'config_class')
                result('config_class') = flywheel.ModelBase.serializeValue(obj.props_('config_class'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'queue_threshold')
                result.queueThreshold = obj.props_('queue_threshold');
            else
                result.queueThreshold = [];
            end
            if isKey(obj.props_, 'max_compute')
                result.maxCompute = obj.props_('max_compute');
            else
                result.maxCompute = [];
            end
            if isKey(obj.props_, 'machine_type')
                result.machineType = obj.props_('machine_type');
            else
                result.machineType = [];
            end
            if isKey(obj.props_, 'disk_size')
                result.diskSize = obj.props_('disk_size');
            else
                result.diskSize = [];
            end
            if isKey(obj.props_, 'swap_size')
                result.swapSize = obj.props_('swap_size');
            else
                result.swapSize = [];
            end
            if isKey(obj.props_, 'preemptible')
                result.preemptible = obj.props_('preemptible');
            else
                result.preemptible = [];
            end
            if isKey(obj.props_, 'zone')
                result.zone = obj.props_('zone');
            else
                result.zone = [];
            end
            if isKey(obj.props_, 'region')
                result.region = obj.props_('region');
            else
                result.region = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'config_type')
                result.configType = obj.props_('config_type');
            else
                result.configType = [];
            end
            if isKey(obj.props_, 'config_class')
                result.configClass = obj.props_('config_class');
            else
                result.configClass = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'queue_threshold')
                    propList.queueThreshold = obj.props_('queue_threshold');
                else
                    propList.queueThreshold = [];
                end
                if isKey(obj.props_, 'max_compute')
                    propList.maxCompute = obj.props_('max_compute');
                else
                    propList.maxCompute = [];
                end
                if isKey(obj.props_, 'machine_type')
                    propList.machineType = obj.props_('machine_type');
                else
                    propList.machineType = [];
                end
                if isKey(obj.props_, 'disk_size')
                    propList.diskSize = obj.props_('disk_size');
                else
                    propList.diskSize = [];
                end
                if isKey(obj.props_, 'swap_size')
                    propList.swapSize = obj.props_('swap_size');
                else
                    propList.swapSize = [];
                end
                if isKey(obj.props_, 'preemptible')
                    propList.preemptible = obj.props_('preemptible');
                else
                    propList.preemptible = [];
                end
                if isKey(obj.props_, 'zone')
                    propList.zone = obj.props_('zone');
                else
                    propList.zone = [];
                end
                if isKey(obj.props_, 'region')
                    propList.region = obj.props_('region');
                else
                    propList.region = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'config_type')
                    propList.configType = obj.props_('config_type');
                else
                    propList.configType = [];
                end
                if isKey(obj.props_, 'config_class')
                    propList.configClass = obj.props_('config_class');
                else
                    propList.configClass = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.BaseCompute;
            if isfield(json, 'queue_threshold')
                obj.props_('queue_threshold') = flywheel.ModelBase.deserializeValue(json.queue_threshold, 'integer');
            end
            if isfield(json, 'max_compute')
                obj.props_('max_compute') = flywheel.ModelBase.deserializeValue(json.max_compute, 'integer');
            end
            if isfield(json, 'machine_type')
                obj.props_('machine_type') = flywheel.ModelBase.deserializeValue(json.machine_type, 'char');
            end
            if isfield(json, 'disk_size')
                obj.props_('disk_size') = flywheel.ModelBase.deserializeValue(json.disk_size, 'integer');
            end
            if isfield(json, 'swap_size')
                obj.props_('swap_size') = flywheel.ModelBase.deserializeValue(json.swap_size, 'char');
            end
            if isfield(json, 'preemptible')
                obj.props_('preemptible') = flywheel.ModelBase.deserializeValue(json.preemptible, 'logical');
            end
            if isfield(json, 'zone')
                obj.props_('zone') = flywheel.ModelBase.deserializeValue(json.zone, 'char');
            end
            if isfield(json, 'region')
                obj.props_('region') = flywheel.ModelBase.deserializeValue(json.region, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'containers.Map');
            end
            if isfield(json, 'config_type')
                obj.props_('config_type') = flywheel.ModelBase.deserializeValue(json.config_type, 'char');
            end
            if isfield(json, 'config_class')
                obj.props_('config_class') = flywheel.ModelBase.deserializeValue(json.config_class, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.BaseCompute')
                    obj = flywheel.model.BaseCompute(obj);
                end
                if isKey(obj.props_, 'queue_threshold')
                end
                if isKey(obj.props_, 'max_compute')
                end
                if isKey(obj.props_, 'machine_type')
                end
                if isKey(obj.props_, 'disk_size')
                end
                if isKey(obj.props_, 'swap_size')
                end
                if isKey(obj.props_, 'preemptible')
                end
                if isKey(obj.props_, 'zone')
                end
                if isKey(obj.props_, 'region')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'config_type')
                end
                if isKey(obj.props_, 'config_class')
                end
            end
        end
    end
end
