% Bookmark
%
% Bookmark Properties:
%    label 
%    url   
%
% Bookmark Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Bookmark < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'url' }, ...
            { 'label', 'url' });
    end
    properties(Dependent)
        label
        url
    end
    methods
        function obj = Bookmark(varargin)
            obj@flywheel.ModelBase(flywheel.model.Bookmark.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'url', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.url)
                    obj.props_('url') = p.Results.url;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.url(obj)
            if ismethod(obj, 'get_url')
                result = obj.get_url();
            else
                if isKey(obj.props_, 'url')
                    result = obj.props_('url');
                else
                    result = [];
                end
            end
        end
        function obj = set.url(obj, value)
            obj.props_('url') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'url')
                result('url') = flywheel.ModelBase.serializeValue(obj.props_('url'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'url')
                result.url = obj.props_('url');
            else
                result.url = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'url')
                    propList.url = obj.props_('url');
                else
                    propList.url = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Bookmark;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'url')
                obj.props_('url') = flywheel.ModelBase.deserializeValue(json.url, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Bookmark')
                    obj = flywheel.model.Bookmark(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'url')
                end
            end
        end
    end
end
