% CatalogListOutput
%
% CatalogListOutput Properties:
%    id                  
%    label               
%    tags                
%    therapeuticAreas    
%    bodyRegions         
%    organSystems        
%    projectInstitutions 
%    projectContacts     
%    summary             
%    stats               
%
% CatalogListOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CatalogListOutput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'label', 'tags', 'therapeuticAreas', 'bodyRegions', 'organSystems', 'projectInstitutions', 'projectContacts', 'summary', 'stats' }, ...
            { 'id', 'label', 'tags', 'therapeutic_areas', 'body_regions', 'organ_systems', 'project_institutions', 'project_contacts', 'summary', 'stats' });
    end
    properties(Dependent)
        id
        label
        tags
        therapeuticAreas
        bodyRegions
        organSystems
        projectInstitutions
        projectContacts
        summary
        stats
    end
    methods
        function obj = CatalogListOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.CatalogListOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'label', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'therapeuticAreas', []);
                addParameter(p, 'bodyRegions', []);
                addParameter(p, 'organSystems', []);
                addParameter(p, 'projectInstitutions', []);
                addParameter(p, 'projectContacts', []);
                addParameter(p, 'summary', []);
                addParameter(p, 'stats', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('id') = p.Results.id;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.therapeuticAreas)
                    obj.props_('therapeutic_areas') = p.Results.therapeuticAreas;
                end
                if ~isempty(p.Results.bodyRegions)
                    obj.props_('body_regions') = p.Results.bodyRegions;
                end
                if ~isempty(p.Results.organSystems)
                    obj.props_('organ_systems') = p.Results.organSystems;
                end
                if ~isempty(p.Results.projectInstitutions)
                    obj.props_('project_institutions') = p.Results.projectInstitutions;
                end
                if ~isempty(p.Results.projectContacts)
                    obj.props_('project_contacts') = p.Results.projectContacts;
                end
                if ~isempty(p.Results.summary)
                    obj.props_('summary') = p.Results.summary;
                end
                if ~isempty(p.Results.stats)
                    obj.props_('stats') = p.Results.stats;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, 'id')
                    result = obj.props_('id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('id') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.therapeuticAreas(obj)
            if ismethod(obj, 'get_therapeuticAreas')
                result = obj.get_therapeuticAreas();
            else
                if isKey(obj.props_, 'therapeutic_areas')
                    result = obj.props_('therapeutic_areas');
                else
                    result = [];
                end
            end
        end
        function obj = set.therapeuticAreas(obj, value)
            obj.props_('therapeutic_areas') = value;
        end
        function result = get.bodyRegions(obj)
            if ismethod(obj, 'get_bodyRegions')
                result = obj.get_bodyRegions();
            else
                if isKey(obj.props_, 'body_regions')
                    result = obj.props_('body_regions');
                else
                    result = [];
                end
            end
        end
        function obj = set.bodyRegions(obj, value)
            obj.props_('body_regions') = value;
        end
        function result = get.organSystems(obj)
            if ismethod(obj, 'get_organSystems')
                result = obj.get_organSystems();
            else
                if isKey(obj.props_, 'organ_systems')
                    result = obj.props_('organ_systems');
                else
                    result = [];
                end
            end
        end
        function obj = set.organSystems(obj, value)
            obj.props_('organ_systems') = value;
        end
        function result = get.projectInstitutions(obj)
            if ismethod(obj, 'get_projectInstitutions')
                result = obj.get_projectInstitutions();
            else
                if isKey(obj.props_, 'project_institutions')
                    result = obj.props_('project_institutions');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectInstitutions(obj, value)
            obj.props_('project_institutions') = value;
        end
        function result = get.projectContacts(obj)
            if ismethod(obj, 'get_projectContacts')
                result = obj.get_projectContacts();
            else
                if isKey(obj.props_, 'project_contacts')
                    result = obj.props_('project_contacts');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectContacts(obj, value)
            obj.props_('project_contacts') = value;
        end
        function result = get.summary(obj)
            if ismethod(obj, 'get_summary')
                result = obj.get_summary();
            else
                if isKey(obj.props_, 'summary')
                    result = obj.props_('summary');
                else
                    result = [];
                end
            end
        end
        function obj = set.summary(obj, value)
            obj.props_('summary') = value;
        end
        function result = get.stats(obj)
            if ismethod(obj, 'get_stats')
                result = obj.get_stats();
            else
                if isKey(obj.props_, 'stats')
                    result = obj.props_('stats');
                else
                    result = [];
                end
            end
        end
        function obj = set.stats(obj, value)
            obj.props_('stats') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'id')
                result('id') = flywheel.ModelBase.serializeValue(obj.props_('id'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'therapeutic_areas')
                result('therapeutic_areas') = flywheel.ModelBase.cellmap(@toJson, obj.props_('therapeutic_areas'));
            end
            if isKey(obj.props_, 'body_regions')
                result('body_regions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('body_regions'));
            end
            if isKey(obj.props_, 'organ_systems')
                result('organ_systems') = flywheel.ModelBase.cellmap(@toJson, obj.props_('organ_systems'));
            end
            if isKey(obj.props_, 'project_institutions')
                result('project_institutions') = flywheel.ModelBase.cellmap(@toJson, obj.props_('project_institutions'));
            end
            if isKey(obj.props_, 'project_contacts')
                result('project_contacts') = flywheel.ModelBase.cellmap(@toJson, obj.props_('project_contacts'));
            end
            if isKey(obj.props_, 'summary')
                result('summary') = flywheel.ModelBase.serializeValue(obj.props_('summary'), 'char');
            end
            if isKey(obj.props_, 'stats')
                result('stats') = obj.props_('stats').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'id')
                result.id = obj.props_('id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'therapeutic_areas')
                result.therapeuticAreas = flywheel.ModelBase.cellmap(@struct, obj.props_('therapeutic_areas'));
            else
                result.therapeuticAreas = [];
            end
            if isKey(obj.props_, 'body_regions')
                result.bodyRegions = flywheel.ModelBase.cellmap(@struct, obj.props_('body_regions'));
            else
                result.bodyRegions = [];
            end
            if isKey(obj.props_, 'organ_systems')
                result.organSystems = flywheel.ModelBase.cellmap(@struct, obj.props_('organ_systems'));
            else
                result.organSystems = [];
            end
            if isKey(obj.props_, 'project_institutions')
                result.projectInstitutions = flywheel.ModelBase.cellmap(@struct, obj.props_('project_institutions'));
            else
                result.projectInstitutions = [];
            end
            if isKey(obj.props_, 'project_contacts')
                result.projectContacts = flywheel.ModelBase.cellmap(@struct, obj.props_('project_contacts'));
            else
                result.projectContacts = [];
            end
            if isKey(obj.props_, 'summary')
                result.summary = obj.props_('summary');
            else
                result.summary = [];
            end
            if isKey(obj.props_, 'stats')
                result.stats = struct(obj.props_('stats'));
            else
                result.stats = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'id')
                    propList.id = obj.props_('id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'therapeutic_areas')
                    propList.therapeuticAreas = obj.props_('therapeutic_areas');
                else
                    propList.therapeuticAreas = [];
                end
                if isKey(obj.props_, 'body_regions')
                    propList.bodyRegions = obj.props_('body_regions');
                else
                    propList.bodyRegions = [];
                end
                if isKey(obj.props_, 'organ_systems')
                    propList.organSystems = obj.props_('organ_systems');
                else
                    propList.organSystems = [];
                end
                if isKey(obj.props_, 'project_institutions')
                    propList.projectInstitutions = obj.props_('project_institutions');
                else
                    propList.projectInstitutions = [];
                end
                if isKey(obj.props_, 'project_contacts')
                    propList.projectContacts = obj.props_('project_contacts');
                else
                    propList.projectContacts = [];
                end
                if isKey(obj.props_, 'summary')
                    propList.summary = obj.props_('summary');
                else
                    propList.summary = [];
                end
                if isKey(obj.props_, 'stats')
                    propList.stats = obj.props_('stats');
                else
                    propList.stats = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CatalogListOutput;
            if isfield(json, 'id')
                obj.props_('id') = flywheel.ModelBase.deserializeValue(json.id, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'therapeutic_areas')
                obj.props_('therapeutic_areas') = flywheel.ModelBase.cellmap(@(x) flywheel.model.TherapeuticArea.fromJson(x, context), json.therapeutic_areas);
            end
            if isfield(json, 'body_regions')
                obj.props_('body_regions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.BodyRegion.fromJson(x, context), json.body_regions);
            end
            if isfield(json, 'organ_systems')
                obj.props_('organ_systems') = flywheel.ModelBase.cellmap(@(x) flywheel.model.OrganSystem.fromJson(x, context), json.organ_systems);
            end
            if isfield(json, 'project_institutions')
                obj.props_('project_institutions') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ProjectInstitution.fromJson(x, context), json.project_institutions);
            end
            if isfield(json, 'project_contacts')
                obj.props_('project_contacts') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ProjectContact.fromJson(x, context), json.project_contacts);
            end
            if isfield(json, 'summary')
                obj.props_('summary') = flywheel.ModelBase.deserializeValue(json.summary, 'char');
            end
            if isfield(json, 'stats')
                obj.props_('stats') = flywheel.model.ProjectStats.fromJson(json.stats, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CatalogListOutput')
                    obj = flywheel.model.CatalogListOutput(obj);
                end
                if isKey(obj.props_, 'id')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'therapeutic_areas')
                    obj.props_('therapeutic_areas') = flywheel.ModelBase.cellmap(@flywheel.model.TherapeuticArea.ensureIsInstance, obj.props_('therapeutic_areas'));
                end
                if isKey(obj.props_, 'body_regions')
                    obj.props_('body_regions') = flywheel.ModelBase.cellmap(@flywheel.model.BodyRegion.ensureIsInstance, obj.props_('body_regions'));
                end
                if isKey(obj.props_, 'organ_systems')
                    obj.props_('organ_systems') = flywheel.ModelBase.cellmap(@flywheel.model.OrganSystem.ensureIsInstance, obj.props_('organ_systems'));
                end
                if isKey(obj.props_, 'project_institutions')
                    obj.props_('project_institutions') = flywheel.ModelBase.cellmap(@flywheel.model.ProjectInstitution.ensureIsInstance, obj.props_('project_institutions'));
                end
                if isKey(obj.props_, 'project_contacts')
                    obj.props_('project_contacts') = flywheel.ModelBase.cellmap(@flywheel.model.ProjectContact.ensureIsInstance, obj.props_('project_contacts'));
                end
                if isKey(obj.props_, 'summary')
                end
                if isKey(obj.props_, 'stats')
                    obj.props_('stats') =  flywheel.model.ProjectStats.ensureIsInstance(obj.props_('stats'));
                end
            end
        end
    end
end
