% CentralOut
%
% CentralOut Properties:
%    enabled        
%    managerUrl     
%    appUrl         
%    tenantId       
%    tenantPath     
%    organizationId 
%
% CentralOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CentralOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'enabled', 'managerUrl', 'appUrl', 'tenantId', 'tenantPath', 'organizationId' }, ...
            { 'enabled', 'manager_url', 'app_url', 'tenant_id', 'tenant_path', 'organization_id' });
    end
    properties(Dependent)
        enabled
        managerUrl
        appUrl
        tenantId
        tenantPath
        organizationId
    end
    methods
        function obj = CentralOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.CentralOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'enabled', false);
                addParameter(p, 'managerUrl', &#x27;&#x27;);
                addParameter(p, 'appUrl', &#x27;&#x27;);
                addParameter(p, 'tenantId', &#x27;&#x27;);
                addParameter(p, 'tenantPath', &#x27;&#x27;);
                addParameter(p, 'organizationId', &#x27;&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.enabled)
                    obj.props_('enabled') = p.Results.enabled;
                end
                if ~isempty(p.Results.managerUrl)
                    obj.props_('manager_url') = p.Results.managerUrl;
                end
                if ~isempty(p.Results.appUrl)
                    obj.props_('app_url') = p.Results.appUrl;
                end
                if ~isempty(p.Results.tenantId)
                    obj.props_('tenant_id') = p.Results.tenantId;
                end
                if ~isempty(p.Results.tenantPath)
                    obj.props_('tenant_path') = p.Results.tenantPath;
                end
                if ~isempty(p.Results.organizationId)
                    obj.props_('organization_id') = p.Results.organizationId;
                end
            end
        end
        function result = get.enabled(obj)
            if ismethod(obj, 'get_enabled')
                result = obj.get_enabled();
            else
                if isKey(obj.props_, 'enabled')
                    result = obj.props_('enabled');
                else
                    result = [];
                end
            end
        end
        function obj = set.enabled(obj, value)
            obj.props_('enabled') = value;
        end
        function result = get.managerUrl(obj)
            if ismethod(obj, 'get_managerUrl')
                result = obj.get_managerUrl();
            else
                if isKey(obj.props_, 'manager_url')
                    result = obj.props_('manager_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.managerUrl(obj, value)
            obj.props_('manager_url') = value;
        end
        function result = get.appUrl(obj)
            if ismethod(obj, 'get_appUrl')
                result = obj.get_appUrl();
            else
                if isKey(obj.props_, 'app_url')
                    result = obj.props_('app_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.appUrl(obj, value)
            obj.props_('app_url') = value;
        end
        function result = get.tenantId(obj)
            if ismethod(obj, 'get_tenantId')
                result = obj.get_tenantId();
            else
                if isKey(obj.props_, 'tenant_id')
                    result = obj.props_('tenant_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.tenantId(obj, value)
            obj.props_('tenant_id') = value;
        end
        function result = get.tenantPath(obj)
            if ismethod(obj, 'get_tenantPath')
                result = obj.get_tenantPath();
            else
                if isKey(obj.props_, 'tenant_path')
                    result = obj.props_('tenant_path');
                else
                    result = [];
                end
            end
        end
        function obj = set.tenantPath(obj, value)
            obj.props_('tenant_path') = value;
        end
        function result = get.organizationId(obj)
            if ismethod(obj, 'get_organizationId')
                result = obj.get_organizationId();
            else
                if isKey(obj.props_, 'organization_id')
                    result = obj.props_('organization_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.organizationId(obj, value)
            obj.props_('organization_id') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'enabled')
                result('enabled') = flywheel.ModelBase.serializeValue(obj.props_('enabled'), 'logical');
            end
            if isKey(obj.props_, 'manager_url')
                result('manager_url') = flywheel.ModelBase.serializeValue(obj.props_('manager_url'), 'char');
            end
            if isKey(obj.props_, 'app_url')
                result('app_url') = flywheel.ModelBase.serializeValue(obj.props_('app_url'), 'char');
            end
            if isKey(obj.props_, 'tenant_id')
                result('tenant_id') = flywheel.ModelBase.serializeValue(obj.props_('tenant_id'), 'char');
            end
            if isKey(obj.props_, 'tenant_path')
                result('tenant_path') = flywheel.ModelBase.serializeValue(obj.props_('tenant_path'), 'char');
            end
            if isKey(obj.props_, 'organization_id')
                result('organization_id') = flywheel.ModelBase.serializeValue(obj.props_('organization_id'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'enabled')
                result.enabled = obj.props_('enabled');
            else
                result.enabled = [];
            end
            if isKey(obj.props_, 'manager_url')
                result.managerUrl = obj.props_('manager_url');
            else
                result.managerUrl = [];
            end
            if isKey(obj.props_, 'app_url')
                result.appUrl = obj.props_('app_url');
            else
                result.appUrl = [];
            end
            if isKey(obj.props_, 'tenant_id')
                result.tenantId = obj.props_('tenant_id');
            else
                result.tenantId = [];
            end
            if isKey(obj.props_, 'tenant_path')
                result.tenantPath = obj.props_('tenant_path');
            else
                result.tenantPath = [];
            end
            if isKey(obj.props_, 'organization_id')
                result.organizationId = obj.props_('organization_id');
            else
                result.organizationId = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'enabled')
                    propList.enabled = obj.props_('enabled');
                else
                    propList.enabled = [];
                end
                if isKey(obj.props_, 'manager_url')
                    propList.managerUrl = obj.props_('manager_url');
                else
                    propList.managerUrl = [];
                end
                if isKey(obj.props_, 'app_url')
                    propList.appUrl = obj.props_('app_url');
                else
                    propList.appUrl = [];
                end
                if isKey(obj.props_, 'tenant_id')
                    propList.tenantId = obj.props_('tenant_id');
                else
                    propList.tenantId = [];
                end
                if isKey(obj.props_, 'tenant_path')
                    propList.tenantPath = obj.props_('tenant_path');
                else
                    propList.tenantPath = [];
                end
                if isKey(obj.props_, 'organization_id')
                    propList.organizationId = obj.props_('organization_id');
                else
                    propList.organizationId = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CentralOut;
            if isfield(json, 'enabled')
                obj.props_('enabled') = flywheel.ModelBase.deserializeValue(json.enabled, 'logical');
            end
            if isfield(json, 'manager_url')
                obj.props_('manager_url') = flywheel.ModelBase.deserializeValue(json.manager_url, 'char');
            end
            if isfield(json, 'app_url')
                obj.props_('app_url') = flywheel.ModelBase.deserializeValue(json.app_url, 'char');
            end
            if isfield(json, 'tenant_id')
                obj.props_('tenant_id') = flywheel.ModelBase.deserializeValue(json.tenant_id, 'char');
            end
            if isfield(json, 'tenant_path')
                obj.props_('tenant_path') = flywheel.ModelBase.deserializeValue(json.tenant_path, 'char');
            end
            if isfield(json, 'organization_id')
                obj.props_('organization_id') = flywheel.ModelBase.deserializeValue(json.organization_id, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CentralOut')
                    obj = flywheel.model.CentralOut(obj);
                end
                if isKey(obj.props_, 'enabled')
                end
                if isKey(obj.props_, 'manager_url')
                end
                if isKey(obj.props_, 'app_url')
                end
                if isKey(obj.props_, 'tenant_id')
                end
                if isKey(obj.props_, 'tenant_path')
                end
                if isKey(obj.props_, 'organization_id')
                end
            end
        end
    end
end
