% Change
%
% Change Properties:
%    created       
%    origin        
%    containerType 
%    containerId   
%    fileVersion   
%    method        
%    patch         
%    revision      
%    reason        
%
% Change Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Change < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'created', 'origin', 'containerType', 'containerId', 'fileVersion', 'method', 'patch', 'revision', 'reason' }, ...
            { 'created', 'origin', 'container_type', 'container_id', 'file_version', 'method', 'patch', 'revision', 'reason' });
    end
    properties(Dependent)
        created
        origin
        containerType
        containerId
        fileVersion
        method
        patch
        revision
        reason
    end
    methods
        function obj = Change(varargin)
            obj@flywheel.ModelBase(flywheel.model.Change.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'created', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'containerType', []);
                addParameter(p, 'containerId', []);
                addParameter(p, 'fileVersion', []);
                addParameter(p, 'method', []);
                addParameter(p, 'patch', []);
                addParameter(p, 'revision', []);
                addParameter(p, 'reason', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.containerType)
                    obj.props_('container_type') = p.Results.containerType;
                end
                if ~isempty(p.Results.containerId)
                    obj.props_('container_id') = p.Results.containerId;
                end
                if ~isempty(p.Results.fileVersion)
                    obj.props_('file_version') = p.Results.fileVersion;
                end
                if ~isempty(p.Results.method)
                    obj.props_('method') = p.Results.method;
                end
                if ~isempty(p.Results.patch)
                    obj.props_('patch') = p.Results.patch;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
                if ~isempty(p.Results.reason)
                    obj.props_('reason') = p.Results.reason;
                end
            end
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.containerType(obj)
            if ismethod(obj, 'get_containerType')
                result = obj.get_containerType();
            else
                if isKey(obj.props_, 'container_type')
                    result = obj.props_('container_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerType(obj, value)
            obj.props_('container_type') = value;
        end
        function result = get.containerId(obj)
            if ismethod(obj, 'get_containerId')
                result = obj.get_containerId();
            else
                if isKey(obj.props_, 'container_id')
                    result = obj.props_('container_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerId(obj, value)
            obj.props_('container_id') = value;
        end
        function result = get.fileVersion(obj)
            if ismethod(obj, 'get_fileVersion')
                result = obj.get_fileVersion();
            else
                if isKey(obj.props_, 'file_version')
                    result = obj.props_('file_version');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileVersion(obj, value)
            obj.props_('file_version') = value;
        end
        function result = get.method(obj)
            if ismethod(obj, 'get_method')
                result = obj.get_method();
            else
                if isKey(obj.props_, 'method')
                    result = obj.props_('method');
                else
                    result = [];
                end
            end
        end
        function obj = set.method(obj, value)
            obj.props_('method') = value;
        end
        function result = get.patch(obj)
            if ismethod(obj, 'get_patch')
                result = obj.get_patch();
            else
                if isKey(obj.props_, 'patch')
                    result = obj.props_('patch');
                else
                    result = [];
                end
            end
        end
        function obj = set.patch(obj, value)
            obj.props_('patch') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = get.reason(obj)
            if ismethod(obj, 'get_reason')
                result = obj.get_reason();
            else
                if isKey(obj.props_, 'reason')
                    result = obj.props_('reason');
                else
                    result = [];
                end
            end
        end
        function obj = set.reason(obj, value)
            obj.props_('reason') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'container_type')
                result('container_type') = obj.props_('container_type').toJson();
            end
            if isKey(obj.props_, 'container_id')
                result('container_id') = flywheel.ModelBase.serializeValue(obj.props_('container_id'), 'char');
            end
            if isKey(obj.props_, 'file_version')
                result('file_version') = flywheel.ModelBase.serializeValue(obj.props_('file_version'), 'integer');
            end
            if isKey(obj.props_, 'method')
                result('method') = obj.props_('method').toJson();
            end
            if isKey(obj.props_, 'patch')
                result('patch') = flywheel.ModelBase.serializeValue(obj.props_('patch'), 'containers.Map');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
            if isKey(obj.props_, 'reason')
                result('reason') = obj.props_('reason').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'container_type')
                result.containerType = struct(obj.props_('container_type'));
            else
                result.containerType = [];
            end
            if isKey(obj.props_, 'container_id')
                result.containerId = obj.props_('container_id');
            else
                result.containerId = [];
            end
            if isKey(obj.props_, 'file_version')
                result.fileVersion = obj.props_('file_version');
            else
                result.fileVersion = [];
            end
            if isKey(obj.props_, 'method')
                result.method = struct(obj.props_('method'));
            else
                result.method = [];
            end
            if isKey(obj.props_, 'patch')
                result.patch = obj.props_('patch');
            else
                result.patch = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
            if isKey(obj.props_, 'reason')
                result.reason = struct(obj.props_('reason'));
            else
                result.reason = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'container_type')
                    propList.containerType = obj.props_('container_type');
                else
                    propList.containerType = [];
                end
                if isKey(obj.props_, 'container_id')
                    propList.containerId = obj.props_('container_id');
                else
                    propList.containerId = [];
                end
                if isKey(obj.props_, 'file_version')
                    propList.fileVersion = obj.props_('file_version');
                else
                    propList.fileVersion = [];
                end
                if isKey(obj.props_, 'method')
                    propList.method = obj.props_('method');
                else
                    propList.method = [];
                end
                if isKey(obj.props_, 'patch')
                    propList.patch = obj.props_('patch');
                else
                    propList.patch = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                if isKey(obj.props_, 'reason')
                    propList.reason = obj.props_('reason');
                else
                    propList.reason = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Change;
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'container_type')
                obj.props_('container_type') = flywheel.model.AnyOfChangeContainerType.fromJson(json.container_type, context);
            end
            if isfield(json, 'container_id')
                obj.props_('container_id') = flywheel.ModelBase.deserializeValue(json.container_id, 'char');
            end
            if isfield(json, 'file_version')
                obj.props_('file_version') = flywheel.ModelBase.deserializeValue(json.file_version, 'integer');
            end
            if isfield(json, 'method')
                obj.props_('method') = flywheel.model.ChangeMethod.fromJson(json.method, context);
            end
            if isfield(json, 'patch')
                obj.props_('patch') = flywheel.ModelBase.deserializeValue(json.patch, 'containers.Map');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isfield(json, 'reason')
                obj.props_('reason') = flywheel.model.ContainerDeleteReason.fromJson(json.reason, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Change')
                    obj = flywheel.model.Change(obj);
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'container_type')
                    obj.props_('container_type') =  flywheel.model.AnyOfChangeContainerType.ensureIsInstance(obj.props_('container_type'));
                end
                if isKey(obj.props_, 'container_id')
                end
                if isKey(obj.props_, 'file_version')
                end
                if isKey(obj.props_, 'method')
                    obj.props_('method') =  flywheel.model.ChangeMethod.ensureIsInstance(obj.props_('method'));
                end
                if isKey(obj.props_, 'patch')
                end
                if isKey(obj.props_, 'revision')
                end
                if isKey(obj.props_, 'reason')
                    obj.props_('reason') =  flywheel.model.ContainerDeleteReason.ensureIsInstance(obj.props_('reason'));
                end
            end
        end
    end
end
