% ClassicBatchProposalInput
%
% ClassicBatchProposalInput Properties:
%    gearId              
%    targets             
%    targetContext       
%    priority            
%    config              
%    tags                 - Array of application-specific tags
%    analysis            
%    optionalInputPolicy 
%    computeProviderId    - Unique database ID
%
% ClassicBatchProposalInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ClassicBatchProposalInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'gearId', 'targets', 'targetContext', 'priority', 'config', 'tags', 'analysis', 'optionalInputPolicy', 'computeProviderId' }, ...
            { 'gear_id', 'targets', 'target_context', 'priority', 'config', 'tags', 'analysis', 'optional_input_policy', 'compute_provider_id' });
    end
    properties(Dependent)
        gearId
        targets
        targetContext
        priority
        config
        tags
        analysis
        optionalInputPolicy
        computeProviderId
    end
    methods
        function obj = ClassicBatchProposalInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ClassicBatchProposalInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'gearId', []);
                addParameter(p, 'targets', []);
                addParameter(p, 'targetContext', []);
                addParameter(p, 'priority', []);
                addParameter(p, 'config', []);
                addParameter(p, 'tags', []);
                addParameter(p, 'analysis', []);
                addParameter(p, 'optionalInputPolicy', []);
                addParameter(p, 'computeProviderId', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.targets)
                    obj.props_('targets') = p.Results.targets;
                end
                if ~isempty(p.Results.targetContext)
                    obj.props_('target_context') = p.Results.targetContext;
                end
                if ~isempty(p.Results.priority)
                    obj.props_('priority') = p.Results.priority;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
                if ~isempty(p.Results.analysis)
                    obj.props_('analysis') = p.Results.analysis;
                end
                if ~isempty(p.Results.optionalInputPolicy)
                    obj.props_('optional_input_policy') = p.Results.optionalInputPolicy;
                end
                if ~isempty(p.Results.computeProviderId)
                    obj.props_('compute_provider_id') = p.Results.computeProviderId;
                end
            end
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.targets(obj)
            if ismethod(obj, 'get_targets')
                result = obj.get_targets();
            else
                if isKey(obj.props_, 'targets')
                    result = obj.props_('targets');
                else
                    result = [];
                end
            end
        end
        function obj = set.targets(obj, value)
            obj.props_('targets') = value;
        end
        function result = get.targetContext(obj)
            if ismethod(obj, 'get_targetContext')
                result = obj.get_targetContext();
            else
                if isKey(obj.props_, 'target_context')
                    result = obj.props_('target_context');
                else
                    result = [];
                end
            end
        end
        function obj = set.targetContext(obj, value)
            obj.props_('target_context') = value;
        end
        function result = get.priority(obj)
            if ismethod(obj, 'get_priority')
                result = obj.get_priority();
            else
                if isKey(obj.props_, 'priority')
                    result = obj.props_('priority');
                else
                    result = [];
                end
            end
        end
        function obj = set.priority(obj, value)
            obj.props_('priority') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = get.analysis(obj)
            if ismethod(obj, 'get_analysis')
                result = obj.get_analysis();
            else
                if isKey(obj.props_, 'analysis')
                    result = obj.props_('analysis');
                else
                    result = [];
                end
            end
        end
        function obj = set.analysis(obj, value)
            obj.props_('analysis') = value;
        end
        function result = get.optionalInputPolicy(obj)
            if ismethod(obj, 'get_optionalInputPolicy')
                result = obj.get_optionalInputPolicy();
            else
                if isKey(obj.props_, 'optional_input_policy')
                    result = obj.props_('optional_input_policy');
                else
                    result = [];
                end
            end
        end
        function obj = set.optionalInputPolicy(obj, value)
            obj.props_('optional_input_policy') = value;
        end
        function result = get.computeProviderId(obj)
            if ismethod(obj, 'get_computeProviderId')
                result = obj.get_computeProviderId();
            else
                if isKey(obj.props_, 'compute_provider_id')
                    result = obj.props_('compute_provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.computeProviderId(obj, value)
            obj.props_('compute_provider_id') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'targets')
                result('targets') = flywheel.ModelBase.cellmap(@toJson, obj.props_('targets'));
            end
            if isKey(obj.props_, 'target_context')
                result('target_context') = obj.props_('target_context').toJson();
            end
            if isKey(obj.props_, 'priority')
                result('priority') = obj.props_('priority').toJson();
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'tags')
                result('tags') = flywheel.ModelBase.serializeValue(obj.props_('tags'), 'vector[char]');
            end
            if isKey(obj.props_, 'analysis')
                result('analysis') = obj.props_('analysis').toJson();
            end
            if isKey(obj.props_, 'optional_input_policy')
                result('optional_input_policy') = obj.props_('optional_input_policy').toJson();
            end
            if isKey(obj.props_, 'compute_provider_id')
                result('compute_provider_id') = flywheel.ModelBase.serializeValue(obj.props_('compute_provider_id'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'targets')
                result.targets = flywheel.ModelBase.cellmap(@struct, obj.props_('targets'));
            else
                result.targets = [];
            end
            if isKey(obj.props_, 'target_context')
                result.targetContext = struct(obj.props_('target_context'));
            else
                result.targetContext = [];
            end
            if isKey(obj.props_, 'priority')
                result.priority = struct(obj.props_('priority'));
            else
                result.priority = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = obj.props_('tags');
            else
                result.tags = [];
            end
            if isKey(obj.props_, 'analysis')
                result.analysis = struct(obj.props_('analysis'));
            else
                result.analysis = [];
            end
            if isKey(obj.props_, 'optional_input_policy')
                result.optionalInputPolicy = struct(obj.props_('optional_input_policy'));
            else
                result.optionalInputPolicy = [];
            end
            if isKey(obj.props_, 'compute_provider_id')
                result.computeProviderId = obj.props_('compute_provider_id');
            else
                result.computeProviderId = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'targets')
                    propList.targets = obj.props_('targets');
                else
                    propList.targets = [];
                end
                if isKey(obj.props_, 'target_context')
                    propList.targetContext = obj.props_('target_context');
                else
                    propList.targetContext = [];
                end
                if isKey(obj.props_, 'priority')
                    propList.priority = obj.props_('priority');
                else
                    propList.priority = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                if isKey(obj.props_, 'analysis')
                    propList.analysis = obj.props_('analysis');
                else
                    propList.analysis = [];
                end
                if isKey(obj.props_, 'optional_input_policy')
                    propList.optionalInputPolicy = obj.props_('optional_input_policy');
                else
                    propList.optionalInputPolicy = [];
                end
                if isKey(obj.props_, 'compute_provider_id')
                    propList.computeProviderId = obj.props_('compute_provider_id');
                else
                    propList.computeProviderId = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ClassicBatchProposalInput;
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'targets')
                obj.props_('targets') = flywheel.ModelBase.cellmap(@(x) flywheel.model.ContainerReference.fromJson(x, context), json.targets);
            end
            if isfield(json, 'target_context')
                obj.props_('target_context') = flywheel.model.ContainerReference.fromJson(json.target_context, context);
            end
            if isfield(json, 'priority')
                obj.props_('priority') = flywheel.model.AllOfClassicBatchProposalInputPriority.fromJson(json.priority, context);
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.ModelBase.deserializeValue(json.tags, 'vector[char]');
            end
            if isfield(json, 'analysis')
                obj.props_('analysis') = flywheel.model.BatchJobAnalysisInput.fromJson(json.analysis, context);
            end
            if isfield(json, 'optional_input_policy')
                obj.props_('optional_input_policy') = flywheel.model.OptionalInputPolicy.fromJson(json.optional_input_policy, context);
            end
            if isfield(json, 'compute_provider_id')
                obj.props_('compute_provider_id') = flywheel.ModelBase.deserializeValue(json.compute_provider_id, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ClassicBatchProposalInput')
                    obj = flywheel.model.ClassicBatchProposalInput(obj);
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'targets')
                    obj.props_('targets') = flywheel.ModelBase.cellmap(@flywheel.model.ContainerReference.ensureIsInstance, obj.props_('targets'));
                end
                if isKey(obj.props_, 'target_context')
                    obj.props_('target_context') =  flywheel.model.ContainerReference.ensureIsInstance(obj.props_('target_context'));
                end
                if isKey(obj.props_, 'priority')
                    obj.props_('priority') =  flywheel.model.AllOfClassicBatchProposalInputPriority.ensureIsInstance(obj.props_('priority'));
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'tags')
                end
                if isKey(obj.props_, 'analysis')
                    obj.props_('analysis') =  flywheel.model.BatchJobAnalysisInput.ensureIsInstance(obj.props_('analysis'));
                end
                if isKey(obj.props_, 'optional_input_policy')
                    obj.props_('optional_input_policy') =  flywheel.model.OptionalInputPolicy.ensureIsInstance(obj.props_('optional_input_policy'));
                end
                if isKey(obj.props_, 'compute_provider_id')
                end
            end
        end
    end
end
