% ClassicBatchProposalOutput
%
% ClassicBatchProposalOutput Properties:
%    id                   - Unique database ID
%    gearId              
%    state               
%    origin              
%    config              
%    created              - Creation time (automatically set)
%    modified             - Last modification time (automatically updated)
%    optionalInputPolicy 
%    ambiguous           
%    notMatched          
%    matched             
%    improperPermissions  - Unique database IDs
%
% ClassicBatchProposalOutput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ClassicBatchProposalOutput < flywheel.ModelBase & flywheel.mixins.BatchProposalMixin
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'gearId', 'state', 'origin', 'config', 'created', 'modified', 'optionalInputPolicy', 'ambiguous', 'notMatched', 'matched', 'improperPermissions' }, ...
            { '_id', 'gear_id', 'state', 'origin', 'config', 'created', 'modified', 'optional_input_policy', 'ambiguous', 'not_matched', 'matched', 'improper_permissions' });
    end
    properties(Dependent)
        id
        gearId
        state
        origin
        config
        created
        modified
        optionalInputPolicy
        ambiguous
        notMatched
        matched
        improperPermissions
    end
    methods
        function obj = ClassicBatchProposalOutput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ClassicBatchProposalOutput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'gearId', []);
                addParameter(p, 'state', []);
                addParameter(p, 'origin', []);
                addParameter(p, 'config', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'optionalInputPolicy', []);
                addParameter(p, 'ambiguous', []);
                addParameter(p, 'notMatched', []);
                addParameter(p, 'matched', []);
                addParameter(p, 'improperPermissions', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.gearId)
                    obj.props_('gear_id') = p.Results.gearId;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
                if ~isempty(p.Results.config)
                    obj.props_('config') = p.Results.config;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.optionalInputPolicy)
                    obj.props_('optional_input_policy') = p.Results.optionalInputPolicy;
                end
                if ~isempty(p.Results.ambiguous)
                    obj.props_('ambiguous') = p.Results.ambiguous;
                end
                if ~isempty(p.Results.notMatched)
                    obj.props_('not_matched') = p.Results.notMatched;
                end
                if ~isempty(p.Results.matched)
                    obj.props_('matched') = p.Results.matched;
                end
                if ~isempty(p.Results.improperPermissions)
                    obj.props_('improper_permissions') = p.Results.improperPermissions;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.gearId(obj)
            if ismethod(obj, 'get_gearId')
                result = obj.get_gearId();
            else
                if isKey(obj.props_, 'gear_id')
                    result = obj.props_('gear_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.gearId(obj, value)
            obj.props_('gear_id') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = get.config(obj)
            if ismethod(obj, 'get_config')
                result = obj.get_config();
            else
                if isKey(obj.props_, 'config')
                    result = obj.props_('config');
                else
                    result = [];
                end
            end
        end
        function obj = set.config(obj, value)
            obj.props_('config') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.optionalInputPolicy(obj)
            if ismethod(obj, 'get_optionalInputPolicy')
                result = obj.get_optionalInputPolicy();
            else
                if isKey(obj.props_, 'optional_input_policy')
                    result = obj.props_('optional_input_policy');
                else
                    result = [];
                end
            end
        end
        function obj = set.optionalInputPolicy(obj, value)
            obj.props_('optional_input_policy') = value;
        end
        function result = get.ambiguous(obj)
            if ismethod(obj, 'get_ambiguous')
                result = obj.get_ambiguous();
            else
                if isKey(obj.props_, 'ambiguous')
                    result = obj.props_('ambiguous');
                else
                    result = [];
                end
            end
        end
        function obj = set.ambiguous(obj, value)
            obj.props_('ambiguous') = value;
        end
        function result = get.notMatched(obj)
            if ismethod(obj, 'get_notMatched')
                result = obj.get_notMatched();
            else
                if isKey(obj.props_, 'not_matched')
                    result = obj.props_('not_matched');
                else
                    result = [];
                end
            end
        end
        function obj = set.notMatched(obj, value)
            obj.props_('not_matched') = value;
        end
        function result = get.matched(obj)
            if ismethod(obj, 'get_matched')
                result = obj.get_matched();
            else
                if isKey(obj.props_, 'matched')
                    result = obj.props_('matched');
                else
                    result = [];
                end
            end
        end
        function obj = set.matched(obj, value)
            obj.props_('matched') = value;
        end
        function result = get.improperPermissions(obj)
            if ismethod(obj, 'get_improperPermissions')
                result = obj.get_improperPermissions();
            else
                if isKey(obj.props_, 'improper_permissions')
                    result = obj.props_('improper_permissions');
                else
                    result = [];
                end
            end
        end
        function obj = set.improperPermissions(obj, value)
            obj.props_('improper_permissions') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'gear_id')
                result('gear_id') = flywheel.ModelBase.serializeValue(obj.props_('gear_id'), 'char');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
            if isKey(obj.props_, 'config')
                result('config') = flywheel.ModelBase.serializeValue(obj.props_('config'), 'containers.Map');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'optional_input_policy')
                result('optional_input_policy') = obj.props_('optional_input_policy').toJson();
            end
            if isKey(obj.props_, 'ambiguous')
                result('ambiguous') = obj.props_('ambiguous').toJson();
            end
            if isKey(obj.props_, 'not_matched')
                result('not_matched') = obj.props_('not_matched').toJson();
            end
            if isKey(obj.props_, 'matched')
                result('matched') = obj.props_('matched').toJson();
            end
            if isKey(obj.props_, 'improper_permissions')
                result('improper_permissions') = flywheel.ModelBase.serializeValue(obj.props_('improper_permissions'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'gear_id')
                result.gearId = obj.props_('gear_id');
            else
                result.gearId = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
            if isKey(obj.props_, 'config')
                result.config = obj.props_('config');
            else
                result.config = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'optional_input_policy')
                result.optionalInputPolicy = struct(obj.props_('optional_input_policy'));
            else
                result.optionalInputPolicy = [];
            end
            if isKey(obj.props_, 'ambiguous')
                result.ambiguous = struct(obj.props_('ambiguous'));
            else
                result.ambiguous = [];
            end
            if isKey(obj.props_, 'not_matched')
                result.notMatched = struct(obj.props_('not_matched'));
            else
                result.notMatched = [];
            end
            if isKey(obj.props_, 'matched')
                result.matched = struct(obj.props_('matched'));
            else
                result.matched = [];
            end
            if isKey(obj.props_, 'improper_permissions')
                result.improperPermissions = obj.props_('improper_permissions');
            else
                result.improperPermissions = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'gear_id')
                    propList.gearId = obj.props_('gear_id');
                else
                    propList.gearId = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                if isKey(obj.props_, 'config')
                    propList.config = obj.props_('config');
                else
                    propList.config = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'optional_input_policy')
                    propList.optionalInputPolicy = obj.props_('optional_input_policy');
                else
                    propList.optionalInputPolicy = [];
                end
                if isKey(obj.props_, 'ambiguous')
                    propList.ambiguous = obj.props_('ambiguous');
                else
                    propList.ambiguous = [];
                end
                if isKey(obj.props_, 'not_matched')
                    propList.notMatched = obj.props_('not_matched');
                else
                    propList.notMatched = [];
                end
                if isKey(obj.props_, 'matched')
                    propList.matched = obj.props_('matched');
                else
                    propList.matched = [];
                end
                if isKey(obj.props_, 'improper_permissions')
                    propList.improperPermissions = obj.props_('improper_permissions');
                else
                    propList.improperPermissions = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ClassicBatchProposalOutput;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'gear_id')
                obj.props_('gear_id') = flywheel.ModelBase.deserializeValue(json.gear_id, 'char');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.JobState.fromJson(json.state, context);
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isfield(json, 'config')
                obj.props_('config') = flywheel.ModelBase.deserializeValue(json.config, 'containers.Map');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'optional_input_policy')
                obj.props_('optional_input_policy') = flywheel.model.OptionalInputPolicy.fromJson(json.optional_input_policy, context);
            end
            if isfield(json, 'ambiguous')
                obj.props_('ambiguous') = flywheel.model.AnyOfClassicBatchProposalOutputAmbiguous.fromJson(json.ambiguous, context);
            end
            if isfield(json, 'not_matched')
                obj.props_('not_matched') = flywheel.model.AnyOfClassicBatchProposalOutputNotMatched.fromJson(json.not_matched, context);
            end
            if isfield(json, 'matched')
                obj.props_('matched') = flywheel.model.AnyOfClassicBatchProposalOutputMatched.fromJson(json.matched, context);
            end
            if isfield(json, 'improper_permissions')
                obj.props_('improper_permissions') = flywheel.ModelBase.deserializeValue(json.improper_permissions, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ClassicBatchProposalOutput')
                    obj = flywheel.model.ClassicBatchProposalOutput(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'gear_id')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.JobState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
                if isKey(obj.props_, 'config')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'optional_input_policy')
                    obj.props_('optional_input_policy') =  flywheel.model.OptionalInputPolicy.ensureIsInstance(obj.props_('optional_input_policy'));
                end
                if isKey(obj.props_, 'ambiguous')
                    obj.props_('ambiguous') =  flywheel.model.AnyOfClassicBatchProposalOutputAmbiguous.ensureIsInstance(obj.props_('ambiguous'));
                end
                if isKey(obj.props_, 'not_matched')
                    obj.props_('not_matched') =  flywheel.model.AnyOfClassicBatchProposalOutputNotMatched.ensureIsInstance(obj.props_('not_matched'));
                end
                if isKey(obj.props_, 'matched')
                    obj.props_('matched') =  flywheel.model.AnyOfClassicBatchProposalOutputMatched.ensureIsInstance(obj.props_('matched'));
                end
                if isKey(obj.props_, 'improper_permissions')
                end
            end
        end
    end
end
