% CollectionOperation
%
% CollectionOperation Properties:
%    operation 
%    nodes     
%
% CollectionOperation Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CollectionOperation < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'operation', 'nodes' }, ...
            { 'operation', 'nodes' });
    end
    properties(Dependent)
        operation
        nodes
    end
    methods
        function obj = CollectionOperation(varargin)
            obj@flywheel.ModelBase(flywheel.model.CollectionOperation.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'operation', []);
                addParameter(p, 'nodes', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.operation)
                    obj.props_('operation') = p.Results.operation;
                end
                if ~isempty(p.Results.nodes)
                    obj.props_('nodes') = p.Results.nodes;
                end
            end
        end
        function result = get.operation(obj)
            if ismethod(obj, 'get_operation')
                result = obj.get_operation();
            else
                if isKey(obj.props_, 'operation')
                    result = obj.props_('operation');
                else
                    result = [];
                end
            end
        end
        function obj = set.operation(obj, value)
            obj.props_('operation') = value;
        end
        function result = get.nodes(obj)
            if ismethod(obj, 'get_nodes')
                result = obj.get_nodes();
            else
                if isKey(obj.props_, 'nodes')
                    result = obj.props_('nodes');
                else
                    result = [];
                end
            end
        end
        function obj = set.nodes(obj, value)
            obj.props_('nodes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'operation')
                result('operation') = obj.props_('operation').toJson();
            end
            if isKey(obj.props_, 'nodes')
                result('nodes') = flywheel.ModelBase.cellmap(@toJson, obj.props_('nodes'));
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'operation')
                result.operation = struct(obj.props_('operation'));
            else
                result.operation = [];
            end
            if isKey(obj.props_, 'nodes')
                result.nodes = flywheel.ModelBase.cellmap(@struct, obj.props_('nodes'));
            else
                result.nodes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'operation')
                    propList.operation = obj.props_('operation');
                else
                    propList.operation = [];
                end
                if isKey(obj.props_, 'nodes')
                    propList.nodes = obj.props_('nodes');
                else
                    propList.nodes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CollectionOperation;
            if isfield(json, 'operation')
                obj.props_('operation') = flywheel.model.CollectionOperationType.fromJson(json.operation, context);
            end
            if isfield(json, 'nodes')
                obj.props_('nodes') = flywheel.ModelBase.cellmap(@(x) flywheel.model.CollectionNode.fromJson(x, context), json.nodes);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CollectionOperation')
                    obj = flywheel.model.CollectionOperation(obj);
                end
                if isKey(obj.props_, 'operation')
                    obj.props_('operation') =  flywheel.model.CollectionOperationType.ensureIsInstance(obj.props_('operation'));
                end
                if isKey(obj.props_, 'nodes')
                    obj.props_('nodes') = flywheel.ModelBase.cellmap(@flywheel.model.CollectionNode.ensureIsInstance, obj.props_('nodes'));
                end
            end
        end
    end
end
