% Column - Describe a column that should belong to the view
%
% Column Properties:
%    src          - The source property in the format of {container}.{field}
%    dst          - The optional destination property name
%    type        
%    expr         - An optional expression, allowing simple calculations (add, subtract, multiply, divide). Use 'x' to substitute the column
%    accumulator 
%
% Column Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef Column < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'src', 'dst', 'type', 'expr', 'accumulator' }, ...
            { 'src', 'dst', 'type', 'expr', 'accumulator' });
    end
    properties(Dependent)
        src
        dst
        type
        expr
        accumulator
    end
    methods
        function obj = Column(varargin)
            obj@flywheel.ModelBase(flywheel.model.Column.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'src', []);
                addParameter(p, 'dst', []);
                addParameter(p, 'type', []);
                addParameter(p, 'expr', []);
                addParameter(p, 'accumulator', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.src)
                    obj.props_('src') = p.Results.src;
                end
                if ~isempty(p.Results.dst)
                    obj.props_('dst') = p.Results.dst;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.expr)
                    obj.props_('expr') = p.Results.expr;
                end
                if ~isempty(p.Results.accumulator)
                    obj.props_('accumulator') = p.Results.accumulator;
                end
            end
        end
        function result = get.src(obj)
            if ismethod(obj, 'get_src')
                result = obj.get_src();
            else
                if isKey(obj.props_, 'src')
                    result = obj.props_('src');
                else
                    result = [];
                end
            end
        end
        function obj = set.src(obj, value)
            obj.props_('src') = value;
        end
        function result = get.dst(obj)
            if ismethod(obj, 'get_dst')
                result = obj.get_dst();
            else
                if isKey(obj.props_, 'dst')
                    result = obj.props_('dst');
                else
                    result = [];
                end
            end
        end
        function obj = set.dst(obj, value)
            obj.props_('dst') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.expr(obj)
            if ismethod(obj, 'get_expr')
                result = obj.get_expr();
            else
                if isKey(obj.props_, 'expr')
                    result = obj.props_('expr');
                else
                    result = [];
                end
            end
        end
        function obj = set.expr(obj, value)
            obj.props_('expr') = value;
        end
        function result = get.accumulator(obj)
            if ismethod(obj, 'get_accumulator')
                result = obj.get_accumulator();
            else
                if isKey(obj.props_, 'accumulator')
                    result = obj.props_('accumulator');
                else
                    result = [];
                end
            end
        end
        function obj = set.accumulator(obj, value)
            obj.props_('accumulator') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'src')
                result('src') = flywheel.ModelBase.serializeValue(obj.props_('src'), 'char');
            end
            if isKey(obj.props_, 'dst')
                result('dst') = flywheel.ModelBase.serializeValue(obj.props_('dst'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = obj.props_('type').toJson();
            end
            if isKey(obj.props_, 'expr')
                result('expr') = flywheel.ModelBase.serializeValue(obj.props_('expr'), 'char');
            end
            if isKey(obj.props_, 'accumulator')
                result('accumulator') = obj.props_('accumulator').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'src')
                result.src = obj.props_('src');
            else
                result.src = [];
            end
            if isKey(obj.props_, 'dst')
                result.dst = obj.props_('dst');
            else
                result.dst = [];
            end
            if isKey(obj.props_, 'type')
                result.type = struct(obj.props_('type'));
            else
                result.type = [];
            end
            if isKey(obj.props_, 'expr')
                result.expr = obj.props_('expr');
            else
                result.expr = [];
            end
            if isKey(obj.props_, 'accumulator')
                result.accumulator = struct(obj.props_('accumulator'));
            else
                result.accumulator = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'src')
                    propList.src = obj.props_('src');
                else
                    propList.src = [];
                end
                if isKey(obj.props_, 'dst')
                    propList.dst = obj.props_('dst');
                else
                    propList.dst = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'expr')
                    propList.expr = obj.props_('expr');
                else
                    propList.expr = [];
                end
                if isKey(obj.props_, 'accumulator')
                    propList.accumulator = obj.props_('accumulator');
                else
                    propList.accumulator = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.Column;
            if isfield(json, 'src')
                obj.props_('src') = flywheel.ModelBase.deserializeValue(json.src, 'char');
            end
            if isfield(json, 'dst')
                obj.props_('dst') = flywheel.ModelBase.deserializeValue(json.dst, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.model.TypeStr.fromJson(json.type, context);
            end
            if isfield(json, 'expr')
                obj.props_('expr') = flywheel.ModelBase.deserializeValue(json.expr, 'char');
            end
            if isfield(json, 'accumulator')
                obj.props_('accumulator') = flywheel.model.Accumulator.fromJson(json.accumulator, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.Column')
                    obj = flywheel.model.Column(obj);
                end
                if isKey(obj.props_, 'src')
                end
                if isKey(obj.props_, 'dst')
                end
                if isKey(obj.props_, 'type')
                    obj.props_('type') =  flywheel.model.TypeStr.ensureIsInstance(obj.props_('type'));
                end
                if isKey(obj.props_, 'expr')
                end
                if isKey(obj.props_, 'accumulator')
                    obj.props_('accumulator') =  flywheel.model.Accumulator.ensureIsInstance(obj.props_('accumulator'));
                end
            end
        end
    end
end
