% CompleteS3MultipartUploadInput - Complete S3 multipart upload input payload schema.
%
% CompleteS3MultipartUploadInput Properties:
%    providerId 
%    uuid       
%    uploadId   
%    etags      
%
% CompleteS3MultipartUploadInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CompleteS3MultipartUploadInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'providerId', 'uuid', 'uploadId', 'etags' }, ...
            { 'provider_id', 'uuid', 'upload_id', 'etags' });
    end
    properties(Dependent)
        providerId
        uuid
        uploadId
        etags
    end
    methods
        function obj = CompleteS3MultipartUploadInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.CompleteS3MultipartUploadInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'providerId', []);
                addParameter(p, 'uuid', []);
                addParameter(p, 'uploadId', []);
                addParameter(p, 'etags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.providerId)
                    obj.props_('provider_id') = p.Results.providerId;
                end
                if ~isempty(p.Results.uuid)
                    obj.props_('uuid') = p.Results.uuid;
                end
                if ~isempty(p.Results.uploadId)
                    obj.props_('upload_id') = p.Results.uploadId;
                end
                if ~isempty(p.Results.etags)
                    obj.props_('etags') = p.Results.etags;
                end
            end
        end
        function result = get.providerId(obj)
            if ismethod(obj, 'get_providerId')
                result = obj.get_providerId();
            else
                if isKey(obj.props_, 'provider_id')
                    result = obj.props_('provider_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.providerId(obj, value)
            obj.props_('provider_id') = value;
        end
        function result = get.uuid(obj)
            if ismethod(obj, 'get_uuid')
                result = obj.get_uuid();
            else
                if isKey(obj.props_, 'uuid')
                    result = obj.props_('uuid');
                else
                    result = [];
                end
            end
        end
        function obj = set.uuid(obj, value)
            obj.props_('uuid') = value;
        end
        function result = get.uploadId(obj)
            if ismethod(obj, 'get_uploadId')
                result = obj.get_uploadId();
            else
                if isKey(obj.props_, 'upload_id')
                    result = obj.props_('upload_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.uploadId(obj, value)
            obj.props_('upload_id') = value;
        end
        function result = get.etags(obj)
            if ismethod(obj, 'get_etags')
                result = obj.get_etags();
            else
                if isKey(obj.props_, 'etags')
                    result = obj.props_('etags');
                else
                    result = [];
                end
            end
        end
        function obj = set.etags(obj, value)
            obj.props_('etags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'provider_id')
                result('provider_id') = flywheel.ModelBase.serializeValue(obj.props_('provider_id'), 'char');
            end
            if isKey(obj.props_, 'uuid')
                result('uuid') = flywheel.ModelBase.serializeValue(obj.props_('uuid'), 'char');
            end
            if isKey(obj.props_, 'upload_id')
                result('upload_id') = flywheel.ModelBase.serializeValue(obj.props_('upload_id'), 'char');
            end
            if isKey(obj.props_, 'etags')
                result('etags') = flywheel.ModelBase.serializeValue(obj.props_('etags'), 'vector[char]');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'provider_id')
                result.providerId = obj.props_('provider_id');
            else
                result.providerId = [];
            end
            if isKey(obj.props_, 'uuid')
                result.uuid = obj.props_('uuid');
            else
                result.uuid = [];
            end
            if isKey(obj.props_, 'upload_id')
                result.uploadId = obj.props_('upload_id');
            else
                result.uploadId = [];
            end
            if isKey(obj.props_, 'etags')
                result.etags = obj.props_('etags');
            else
                result.etags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'provider_id')
                    propList.providerId = obj.props_('provider_id');
                else
                    propList.providerId = [];
                end
                if isKey(obj.props_, 'uuid')
                    propList.uuid = obj.props_('uuid');
                else
                    propList.uuid = [];
                end
                if isKey(obj.props_, 'upload_id')
                    propList.uploadId = obj.props_('upload_id');
                else
                    propList.uploadId = [];
                end
                if isKey(obj.props_, 'etags')
                    propList.etags = obj.props_('etags');
                else
                    propList.etags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CompleteS3MultipartUploadInput;
            if isfield(json, 'provider_id')
                obj.props_('provider_id') = flywheel.ModelBase.deserializeValue(json.provider_id, 'char');
            end
            if isfield(json, 'uuid')
                obj.props_('uuid') = flywheel.ModelBase.deserializeValue(json.uuid, 'char');
            end
            if isfield(json, 'upload_id')
                obj.props_('upload_id') = flywheel.ModelBase.deserializeValue(json.upload_id, 'char');
            end
            if isfield(json, 'etags')
                obj.props_('etags') = flywheel.ModelBase.deserializeValue(json.etags, 'vector[char]');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CompleteS3MultipartUploadInput')
                    obj = flywheel.model.CompleteS3MultipartUploadInput(obj);
                end
                if isKey(obj.props_, 'provider_id')
                end
                if isKey(obj.props_, 'uuid')
                end
                if isKey(obj.props_, 'upload_id')
                end
                if isKey(obj.props_, 'etags')
                end
            end
        end
    end
end
