% ConfigOut
%
% ConfigOut Properties:
%    lastUpdated 
%    site        
%    features    
%    wipFeatures 
%    signedUrl   
%    auth        
%    created     
%    modified    
%    central     
%
% ConfigOut Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ConfigOut < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'lastUpdated', 'site', 'features', 'wipFeatures', 'signedUrl', 'auth', 'created', 'modified', 'central' }, ...
            { 'last_updated', 'site', 'features', 'wip_features', 'signed_url', 'auth', 'created', 'modified', 'central' });
    end
    properties(Dependent)
        lastUpdated
        site
        features
        wipFeatures
        signedUrl
        auth
        created
        modified
        central
    end
    methods
        function obj = ConfigOut(varargin)
            obj@flywheel.ModelBase(flywheel.model.ConfigOut.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'lastUpdated', []);
                addParameter(p, 'site', []);
                addParameter(p, 'features', []);
                addParameter(p, 'wipFeatures', []);
                addParameter(p, 'signedUrl', false);
                addParameter(p, 'auth', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'central', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.lastUpdated)
                    obj.props_('last_updated') = p.Results.lastUpdated;
                end
                if ~isempty(p.Results.site)
                    obj.props_('site') = p.Results.site;
                end
                if ~isempty(p.Results.features)
                    obj.props_('features') = p.Results.features;
                end
                if ~isempty(p.Results.wipFeatures)
                    obj.props_('wip_features') = p.Results.wipFeatures;
                end
                if ~isempty(p.Results.signedUrl)
                    obj.props_('signed_url') = p.Results.signedUrl;
                end
                if ~isempty(p.Results.auth)
                    obj.props_('auth') = p.Results.auth;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.central)
                    obj.props_('central') = p.Results.central;
                end
            end
        end
        function result = get.lastUpdated(obj)
            if ismethod(obj, 'get_lastUpdated')
                result = obj.get_lastUpdated();
            else
                if isKey(obj.props_, 'last_updated')
                    result = obj.props_('last_updated');
                else
                    result = [];
                end
            end
        end
        function obj = set.lastUpdated(obj, value)
            obj.props_('last_updated') = value;
        end
        function result = get.site(obj)
            if ismethod(obj, 'get_site')
                result = obj.get_site();
            else
                if isKey(obj.props_, 'site')
                    result = obj.props_('site');
                else
                    result = [];
                end
            end
        end
        function obj = set.site(obj, value)
            obj.props_('site') = value;
        end
        function result = get.features(obj)
            if ismethod(obj, 'get_features')
                result = obj.get_features();
            else
                if isKey(obj.props_, 'features')
                    result = obj.props_('features');
                else
                    result = [];
                end
            end
        end
        function obj = set.features(obj, value)
            obj.props_('features') = value;
        end
        function result = get.wipFeatures(obj)
            if ismethod(obj, 'get_wipFeatures')
                result = obj.get_wipFeatures();
            else
                if isKey(obj.props_, 'wip_features')
                    result = obj.props_('wip_features');
                else
                    result = [];
                end
            end
        end
        function obj = set.wipFeatures(obj, value)
            obj.props_('wip_features') = value;
        end
        function result = get.signedUrl(obj)
            if ismethod(obj, 'get_signedUrl')
                result = obj.get_signedUrl();
            else
                if isKey(obj.props_, 'signed_url')
                    result = obj.props_('signed_url');
                else
                    result = [];
                end
            end
        end
        function obj = set.signedUrl(obj, value)
            obj.props_('signed_url') = value;
        end
        function result = get.auth(obj)
            if ismethod(obj, 'get_auth')
                result = obj.get_auth();
            else
                if isKey(obj.props_, 'auth')
                    result = obj.props_('auth');
                else
                    result = [];
                end
            end
        end
        function obj = set.auth(obj, value)
            obj.props_('auth') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.central(obj)
            if ismethod(obj, 'get_central')
                result = obj.get_central();
            else
                if isKey(obj.props_, 'central')
                    result = obj.props_('central');
                else
                    result = [];
                end
            end
        end
        function obj = set.central(obj, value)
            obj.props_('central') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'last_updated')
                result('last_updated') = flywheel.ModelBase.serializeValue(obj.props_('last_updated'), 'datetime');
            end
            if isKey(obj.props_, 'site')
                result('site') = obj.props_('site').toJson();
            end
            if isKey(obj.props_, 'features')
                result('features') = obj.props_('features').toJson();
            end
            if isKey(obj.props_, 'wip_features')
                result('wip_features') = obj.props_('wip_features').toJson();
            end
            if isKey(obj.props_, 'signed_url')
                result('signed_url') = flywheel.ModelBase.serializeValue(obj.props_('signed_url'), 'logical');
            end
            if isKey(obj.props_, 'auth')
                result('auth') = obj.props_('auth').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'central')
                result('central') = obj.props_('central').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'last_updated')
                result.lastUpdated = obj.props_('last_updated');
            else
                result.lastUpdated = [];
            end
            if isKey(obj.props_, 'site')
                result.site = struct(obj.props_('site'));
            else
                result.site = [];
            end
            if isKey(obj.props_, 'features')
                result.features = struct(obj.props_('features'));
            else
                result.features = [];
            end
            if isKey(obj.props_, 'wip_features')
                result.wipFeatures = struct(obj.props_('wip_features'));
            else
                result.wipFeatures = [];
            end
            if isKey(obj.props_, 'signed_url')
                result.signedUrl = obj.props_('signed_url');
            else
                result.signedUrl = [];
            end
            if isKey(obj.props_, 'auth')
                result.auth = struct(obj.props_('auth'));
            else
                result.auth = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'central')
                result.central = struct(obj.props_('central'));
            else
                result.central = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'last_updated')
                    propList.lastUpdated = obj.props_('last_updated');
                else
                    propList.lastUpdated = [];
                end
                if isKey(obj.props_, 'site')
                    propList.site = obj.props_('site');
                else
                    propList.site = [];
                end
                if isKey(obj.props_, 'features')
                    propList.features = obj.props_('features');
                else
                    propList.features = [];
                end
                if isKey(obj.props_, 'wip_features')
                    propList.wipFeatures = obj.props_('wip_features');
                else
                    propList.wipFeatures = [];
                end
                if isKey(obj.props_, 'signed_url')
                    propList.signedUrl = obj.props_('signed_url');
                else
                    propList.signedUrl = [];
                end
                if isKey(obj.props_, 'auth')
                    propList.auth = obj.props_('auth');
                else
                    propList.auth = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'central')
                    propList.central = obj.props_('central');
                else
                    propList.central = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ConfigOut;
            if isfield(json, 'last_updated')
                obj.props_('last_updated') = flywheel.ModelBase.deserializeValue(json.last_updated, 'datetime');
            end
            if isfield(json, 'site')
                obj.props_('site') = flywheel.model.Site.fromJson(json.site, context);
            end
            if isfield(json, 'features')
                obj.props_('features') = flywheel.model.AllOfConfigOutFeatures.fromJson(json.features, context);
            end
            if isfield(json, 'wip_features')
                obj.props_('wip_features') = flywheel.model.AllOfConfigOutWipFeatures.fromJson(json.wip_features, context);
            end
            if isfield(json, 'signed_url')
                obj.props_('signed_url') = flywheel.ModelBase.deserializeValue(json.signed_url, 'logical');
            end
            if isfield(json, 'auth')
                obj.props_('auth') = flywheel.model.AuthOut.fromJson(json.auth, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'central')
                obj.props_('central') = flywheel.model.CentralOut.fromJson(json.central, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ConfigOut')
                    obj = flywheel.model.ConfigOut(obj);
                end
                if isKey(obj.props_, 'last_updated')
                end
                if isKey(obj.props_, 'site')
                    obj.props_('site') =  flywheel.model.Site.ensureIsInstance(obj.props_('site'));
                end
                if isKey(obj.props_, 'features')
                    obj.props_('features') =  flywheel.model.AllOfConfigOutFeatures.ensureIsInstance(obj.props_('features'));
                end
                if isKey(obj.props_, 'wip_features')
                    obj.props_('wip_features') =  flywheel.model.AllOfConfigOutWipFeatures.ensureIsInstance(obj.props_('wip_features'));
                end
                if isKey(obj.props_, 'signed_url')
                end
                if isKey(obj.props_, 'auth')
                    obj.props_('auth') =  flywheel.model.AuthOut.ensureIsInstance(obj.props_('auth'));
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'central')
                    obj.props_('central') =  flywheel.model.CentralOut.ensureIsInstance(obj.props_('central'));
                end
            end
        end
    end
end
