% ContainerFilter
%
% ContainerFilter Properties:
%    type 
%    tags 
%
% ContainerFilter Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ContainerFilter < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'type', 'tags' }, ...
            { 'type', 'tags' });
    end
    properties(Dependent)
        type
        tags
    end
    methods
        function obj = ContainerFilter(varargin)
            obj@flywheel.ModelBase(flywheel.model.ContainerFilter.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'type', []);
                addParameter(p, 'tags', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.tags)
                    obj.props_('tags') = p.Results.tags;
                end
            end
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.tags(obj)
            if ismethod(obj, 'get_tags')
                result = obj.get_tags();
            else
                if isKey(obj.props_, 'tags')
                    result = obj.props_('tags');
                else
                    result = [];
                end
            end
        end
        function obj = set.tags(obj, value)
            obj.props_('tags') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'type')
                result('type') = obj.props_('type').toJson();
            end
            if isKey(obj.props_, 'tags')
                result('tags') = obj.props_('tags').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'type')
                result.type = struct(obj.props_('type'));
            else
                result.type = [];
            end
            if isKey(obj.props_, 'tags')
                result.tags = struct(obj.props_('tags'));
            else
                result.tags = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'tags')
                    propList.tags = obj.props_('tags');
                else
                    propList.tags = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ContainerFilter;
            if isfield(json, 'type')
                obj.props_('type') = flywheel.model.ContainerType.fromJson(json.type, context);
            end
            if isfield(json, 'tags')
                obj.props_('tags') = flywheel.model.FilterValues.fromJson(json.tags, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ContainerFilter')
                    obj = flywheel.model.ContainerFilter(obj);
                end
                if isKey(obj.props_, 'type')
                    obj.props_('type') =  flywheel.model.ContainerType.ensureIsInstance(obj.props_('type'));
                end
                if isKey(obj.props_, 'tags')
                    obj.props_('tags') =  flywheel.model.FilterValues.ensureIsInstance(obj.props_('tags'));
                end
            end
        end
    end
end
