% ContainerIdViewInput - View input to server
%
% ContainerIdViewInput Properties:
%    parent              
%    label               
%    description         
%    columns             
%    fileSpec            
%    filter              
%    groupBy             
%    includeIds          
%    includeLabels       
%    errorColumn         
%    missingDataStrategy 
%    sort                
%    id                  
%    origin              
%
% ContainerIdViewInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ContainerIdViewInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'parent', 'label', 'description', 'columns', 'fileSpec', 'filter', 'groupBy', 'includeIds', 'includeLabels', 'errorColumn', 'missingDataStrategy', 'sort', 'id', 'origin' }, ...
            { 'parent', 'label', 'description', 'columns', 'fileSpec', 'filter', 'groupBy', 'includeIds', 'includeLabels', 'errorColumn', 'missingDataStrategy', 'sort', '_id', 'origin' });
    end
    properties(Dependent)
        parent
        label
        description
        columns
        fileSpec
        filter
        groupBy
        includeIds
        includeLabels
        errorColumn
        missingDataStrategy
        sort
        id
        origin
    end
    methods
        function obj = ContainerIdViewInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ContainerIdViewInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'parent', []);
                addParameter(p, 'label', []);
                addParameter(p, 'description', []);
                addParameter(p, 'columns', []);
                addParameter(p, 'fileSpec', []);
                addParameter(p, 'filter', []);
                addParameter(p, 'groupBy', []);
                addParameter(p, 'includeIds', true);
                addParameter(p, 'includeLabels', true);
                addParameter(p, 'errorColumn', []);
                addParameter(p, 'missingDataStrategy', []);
                addParameter(p, 'sort', false);
                addParameter(p, 'id', []);
                addParameter(p, 'origin', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.parent)
                    obj.props_('parent') = p.Results.parent;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.columns)
                    obj.props_('columns') = p.Results.columns;
                end
                if ~isempty(p.Results.fileSpec)
                    obj.props_('fileSpec') = p.Results.fileSpec;
                end
                if ~isempty(p.Results.filter)
                    obj.props_('filter') = p.Results.filter;
                end
                if ~isempty(p.Results.groupBy)
                    obj.props_('groupBy') = p.Results.groupBy;
                end
                if ~isempty(p.Results.includeIds)
                    obj.props_('includeIds') = p.Results.includeIds;
                end
                if ~isempty(p.Results.includeLabels)
                    obj.props_('includeLabels') = p.Results.includeLabels;
                end
                if ~isempty(p.Results.errorColumn)
                    obj.props_('errorColumn') = p.Results.errorColumn;
                end
                if ~isempty(p.Results.missingDataStrategy)
                    obj.props_('missingDataStrategy') = p.Results.missingDataStrategy;
                end
                if ~isempty(p.Results.sort)
                    obj.props_('sort') = p.Results.sort;
                end
                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.origin)
                    obj.props_('origin') = p.Results.origin;
                end
            end
        end
        function result = get.parent(obj)
            if ismethod(obj, 'get_parent')
                result = obj.get_parent();
            else
                if isKey(obj.props_, 'parent')
                    result = obj.props_('parent');
                else
                    result = [];
                end
            end
        end
        function obj = set.parent(obj, value)
            obj.props_('parent') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.columns(obj)
            if ismethod(obj, 'get_columns')
                result = obj.get_columns();
            else
                if isKey(obj.props_, 'columns')
                    result = obj.props_('columns');
                else
                    result = [];
                end
            end
        end
        function obj = set.columns(obj, value)
            obj.props_('columns') = value;
        end
        function result = get.fileSpec(obj)
            if ismethod(obj, 'get_fileSpec')
                result = obj.get_fileSpec();
            else
                if isKey(obj.props_, 'fileSpec')
                    result = obj.props_('fileSpec');
                else
                    result = [];
                end
            end
        end
        function obj = set.fileSpec(obj, value)
            obj.props_('fileSpec') = value;
        end
        function result = get.filter(obj)
            if ismethod(obj, 'get_filter')
                result = obj.get_filter();
            else
                if isKey(obj.props_, 'filter')
                    result = obj.props_('filter');
                else
                    result = [];
                end
            end
        end
        function obj = set.filter(obj, value)
            obj.props_('filter') = value;
        end
        function result = get.groupBy(obj)
            if ismethod(obj, 'get_groupBy')
                result = obj.get_groupBy();
            else
                if isKey(obj.props_, 'groupBy')
                    result = obj.props_('groupBy');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupBy(obj, value)
            obj.props_('groupBy') = value;
        end
        function result = get.includeIds(obj)
            if ismethod(obj, 'get_includeIds')
                result = obj.get_includeIds();
            else
                if isKey(obj.props_, 'includeIds')
                    result = obj.props_('includeIds');
                else
                    result = [];
                end
            end
        end
        function obj = set.includeIds(obj, value)
            obj.props_('includeIds') = value;
        end
        function result = get.includeLabels(obj)
            if ismethod(obj, 'get_includeLabels')
                result = obj.get_includeLabels();
            else
                if isKey(obj.props_, 'includeLabels')
                    result = obj.props_('includeLabels');
                else
                    result = [];
                end
            end
        end
        function obj = set.includeLabels(obj, value)
            obj.props_('includeLabels') = value;
        end
        function result = get.errorColumn(obj)
            if ismethod(obj, 'get_errorColumn')
                result = obj.get_errorColumn();
            else
                if isKey(obj.props_, 'errorColumn')
                    result = obj.props_('errorColumn');
                else
                    result = [];
                end
            end
        end
        function obj = set.errorColumn(obj, value)
            obj.props_('errorColumn') = value;
        end
        function result = get.missingDataStrategy(obj)
            if ismethod(obj, 'get_missingDataStrategy')
                result = obj.get_missingDataStrategy();
            else
                if isKey(obj.props_, 'missingDataStrategy')
                    result = obj.props_('missingDataStrategy');
                else
                    result = [];
                end
            end
        end
        function obj = set.missingDataStrategy(obj, value)
            obj.props_('missingDataStrategy') = value;
        end
        function result = get.sort(obj)
            if ismethod(obj, 'get_sort')
                result = obj.get_sort();
            else
                if isKey(obj.props_, 'sort')
                    result = obj.props_('sort');
                else
                    result = [];
                end
            end
        end
        function obj = set.sort(obj, value)
            obj.props_('sort') = value;
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.origin(obj)
            if ismethod(obj, 'get_origin')
                result = obj.get_origin();
            else
                if isKey(obj.props_, 'origin')
                    result = obj.props_('origin');
                else
                    result = [];
                end
            end
        end
        function obj = set.origin(obj, value)
            obj.props_('origin') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'parent')
                result('parent') = flywheel.ModelBase.serializeValue(obj.props_('parent'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'columns')
                result('columns') = flywheel.ModelBase.cellmap(@toJson, obj.props_('columns'));
            end
            if isKey(obj.props_, 'fileSpec')
                result('fileSpec') = obj.props_('fileSpec').toJson();
            end
            if isKey(obj.props_, 'filter')
                result('filter') = flywheel.ModelBase.serializeValue(obj.props_('filter'), 'char');
            end
            if isKey(obj.props_, 'groupBy')
                result('groupBy') = obj.props_('groupBy').toJson();
            end
            if isKey(obj.props_, 'includeIds')
                result('includeIds') = flywheel.ModelBase.serializeValue(obj.props_('includeIds'), 'logical');
            end
            if isKey(obj.props_, 'includeLabels')
                result('includeLabels') = flywheel.ModelBase.serializeValue(obj.props_('includeLabels'), 'logical');
            end
            if isKey(obj.props_, 'errorColumn')
                result('errorColumn') = flywheel.ModelBase.serializeValue(obj.props_('errorColumn'), 'logical');
            end
            if isKey(obj.props_, 'missingDataStrategy')
                result('missingDataStrategy') = obj.props_('missingDataStrategy').toJson();
            end
            if isKey(obj.props_, 'sort')
                result('sort') = flywheel.ModelBase.serializeValue(obj.props_('sort'), 'logical');
            end
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'origin')
                result('origin') = obj.props_('origin').toJson();
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'parent')
                result.parent = obj.props_('parent');
            else
                result.parent = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'columns')
                result.columns = flywheel.ModelBase.cellmap(@struct, obj.props_('columns'));
            else
                result.columns = [];
            end
            if isKey(obj.props_, 'fileSpec')
                result.fileSpec = struct(obj.props_('fileSpec'));
            else
                result.fileSpec = [];
            end
            if isKey(obj.props_, 'filter')
                result.filter = obj.props_('filter');
            else
                result.filter = [];
            end
            if isKey(obj.props_, 'groupBy')
                result.groupBy = struct(obj.props_('groupBy'));
            else
                result.groupBy = [];
            end
            if isKey(obj.props_, 'includeIds')
                result.includeIds = obj.props_('includeIds');
            else
                result.includeIds = [];
            end
            if isKey(obj.props_, 'includeLabels')
                result.includeLabels = obj.props_('includeLabels');
            else
                result.includeLabels = [];
            end
            if isKey(obj.props_, 'errorColumn')
                result.errorColumn = obj.props_('errorColumn');
            else
                result.errorColumn = [];
            end
            if isKey(obj.props_, 'missingDataStrategy')
                result.missingDataStrategy = struct(obj.props_('missingDataStrategy'));
            else
                result.missingDataStrategy = [];
            end
            if isKey(obj.props_, 'sort')
                result.sort = obj.props_('sort');
            else
                result.sort = [];
            end
            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'origin')
                result.origin = struct(obj.props_('origin'));
            else
                result.origin = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'parent')
                    propList.parent = obj.props_('parent');
                else
                    propList.parent = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'columns')
                    propList.columns = obj.props_('columns');
                else
                    propList.columns = [];
                end
                if isKey(obj.props_, 'fileSpec')
                    propList.fileSpec = obj.props_('fileSpec');
                else
                    propList.fileSpec = [];
                end
                if isKey(obj.props_, 'filter')
                    propList.filter = obj.props_('filter');
                else
                    propList.filter = [];
                end
                if isKey(obj.props_, 'groupBy')
                    propList.groupBy = obj.props_('groupBy');
                else
                    propList.groupBy = [];
                end
                if isKey(obj.props_, 'includeIds')
                    propList.includeIds = obj.props_('includeIds');
                else
                    propList.includeIds = [];
                end
                if isKey(obj.props_, 'includeLabels')
                    propList.includeLabels = obj.props_('includeLabels');
                else
                    propList.includeLabels = [];
                end
                if isKey(obj.props_, 'errorColumn')
                    propList.errorColumn = obj.props_('errorColumn');
                else
                    propList.errorColumn = [];
                end
                if isKey(obj.props_, 'missingDataStrategy')
                    propList.missingDataStrategy = obj.props_('missingDataStrategy');
                else
                    propList.missingDataStrategy = [];
                end
                if isKey(obj.props_, 'sort')
                    propList.sort = obj.props_('sort');
                else
                    propList.sort = [];
                end
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'origin')
                    propList.origin = obj.props_('origin');
                else
                    propList.origin = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ContainerIdViewInput;
            if isfield(json, 'parent')
                obj.props_('parent') = flywheel.ModelBase.deserializeValue(json.parent, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'columns')
                obj.props_('columns') = flywheel.ModelBase.cellmap(@(x) flywheel.model.Column.fromJson(x, context), json.columns);
            end
            if isfield(json, 'fileSpec')
                obj.props_('fileSpec') = flywheel.model.DataViewFileSpec.fromJson(json.fileSpec, context);
            end
            if isfield(json, 'filter')
                obj.props_('filter') = flywheel.ModelBase.deserializeValue(json.filter, 'char');
            end
            if isfield(json, 'groupBy')
                obj.props_('groupBy') = flywheel.model.GroupBy.fromJson(json.groupBy, context);
            end
            if isfield(json, 'includeIds')
                obj.props_('includeIds') = flywheel.ModelBase.deserializeValue(json.includeIds, 'logical');
            end
            if isfield(json, 'includeLabels')
                obj.props_('includeLabels') = flywheel.ModelBase.deserializeValue(json.includeLabels, 'logical');
            end
            if isfield(json, 'errorColumn')
                obj.props_('errorColumn') = flywheel.ModelBase.deserializeValue(json.errorColumn, 'logical');
            end
            if isfield(json, 'missingDataStrategy')
                obj.props_('missingDataStrategy') = flywheel.model.DataStrategy.fromJson(json.missingDataStrategy, context);
            end
            if isfield(json, 'sort')
                obj.props_('sort') = flywheel.ModelBase.deserializeValue(json.sort, 'logical');
            end
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'origin')
                obj.props_('origin') = flywheel.model.Origin.fromJson(json.origin, context);
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ContainerIdViewInput')
                    obj = flywheel.model.ContainerIdViewInput(obj);
                end
                if isKey(obj.props_, 'parent')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'columns')
                    obj.props_('columns') = flywheel.ModelBase.cellmap(@flywheel.model.Column.ensureIsInstance, obj.props_('columns'));
                end
                if isKey(obj.props_, 'fileSpec')
                    obj.props_('fileSpec') =  flywheel.model.DataViewFileSpec.ensureIsInstance(obj.props_('fileSpec'));
                end
                if isKey(obj.props_, 'filter')
                end
                if isKey(obj.props_, 'groupBy')
                    obj.props_('groupBy') =  flywheel.model.GroupBy.ensureIsInstance(obj.props_('groupBy'));
                end
                if isKey(obj.props_, 'includeIds')
                end
                if isKey(obj.props_, 'includeLabels')
                end
                if isKey(obj.props_, 'errorColumn')
                end
                if isKey(obj.props_, 'missingDataStrategy')
                    obj.props_('missingDataStrategy') =  flywheel.model.DataStrategy.ensureIsInstance(obj.props_('missingDataStrategy'));
                end
                if isKey(obj.props_, 'sort')
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'origin')
                    obj.props_('origin') =  flywheel.model.Origin.ensureIsInstance(obj.props_('origin'));
                end
            end
        end
    end
end
