% ContainerNodeMin - Special case for any min container.
%
% ContainerNodeMin Properties:
%    id            
%    label         
%    name          
%    code          
%    created       
%    modified      
%    containerType 
%    nodeType      
%
% ContainerNodeMin Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ContainerNodeMin < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'label', 'name', 'code', 'created', 'modified', 'containerType', 'nodeType' }, ...
            { '_id', 'label', 'name', 'code', 'created', 'modified', 'container_type', 'node_type' });
    end
    properties(Dependent)
        id
        label
        name
        code
        created
        modified
        containerType
        nodeType
    end
    methods
        function obj = ContainerNodeMin(varargin)
            obj@flywheel.ModelBase(flywheel.model.ContainerNodeMin.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'label', []);
                addParameter(p, 'name', []);
                addParameter(p, 'code', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'containerType', &#x27;file&#x27;);
                addParameter(p, 'nodeType', &#x27;file&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.code)
                    obj.props_('code') = p.Results.code;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.containerType)
                    obj.props_('container_type') = p.Results.containerType;
                end
                if ~isempty(p.Results.nodeType)
                    obj.props_('node_type') = p.Results.nodeType;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.code(obj)
            if ismethod(obj, 'get_code')
                result = obj.get_code();
            else
                if isKey(obj.props_, 'code')
                    result = obj.props_('code');
                else
                    result = [];
                end
            end
        end
        function obj = set.code(obj, value)
            obj.props_('code') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.containerType(obj)
            if ismethod(obj, 'get_containerType')
                result = obj.get_containerType();
            else
                if isKey(obj.props_, 'container_type')
                    result = obj.props_('container_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.containerType(obj, value)
            obj.props_('container_type') = value;
        end
        function result = get.nodeType(obj)
            if ismethod(obj, 'get_nodeType')
                result = obj.get_nodeType();
            else
                if isKey(obj.props_, 'node_type')
                    result = obj.props_('node_type');
                else
                    result = [];
                end
            end
        end
        function obj = set.nodeType(obj, value)
            obj.props_('node_type') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'code')
                result('code') = flywheel.ModelBase.serializeValue(obj.props_('code'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'container_type')
                result('container_type') = flywheel.ModelBase.serializeValue(obj.props_('container_type'), 'char');
            end
            if isKey(obj.props_, 'node_type')
                result('node_type') = flywheel.ModelBase.serializeValue(obj.props_('node_type'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'code')
                result.code = obj.props_('code');
            else
                result.code = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'container_type')
                result.containerType = obj.props_('container_type');
            else
                result.containerType = [];
            end
            if isKey(obj.props_, 'node_type')
                result.nodeType = obj.props_('node_type');
            else
                result.nodeType = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'code')
                    propList.code = obj.props_('code');
                else
                    propList.code = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'container_type')
                    propList.containerType = obj.props_('container_type');
                else
                    propList.containerType = [];
                end
                if isKey(obj.props_, 'node_type')
                    propList.nodeType = obj.props_('node_type');
                else
                    propList.nodeType = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ContainerNodeMin;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'code')
                obj.props_('code') = flywheel.ModelBase.deserializeValue(json.code, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'container_type')
                obj.props_('container_type') = flywheel.ModelBase.deserializeValue(json.container_type, 'char');
            end
            if isfield(json, 'node_type')
                obj.props_('node_type') = flywheel.ModelBase.deserializeValue(json.node_type, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ContainerNodeMin')
                    obj = flywheel.model.ContainerNodeMin(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'code')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'container_type')
                end
                if isKey(obj.props_, 'node_type')
                end
            end
        end
    end
end
