% ContextInput - Represents a context-based input to a job  Attributes:     found (bool): Whether or not the context information was found     value (Any): TODO: description     base (str): The input type
%
% ContextInput Properties:
%    found 
%    value 
%    base  
%
% ContextInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef ContextInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'found', 'value', 'base' }, ...
            { 'found', 'value', 'base' });
    end
    properties(Dependent)
        found
        value
        base
    end
    methods
        function obj = ContextInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.ContextInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'found', []);
                addParameter(p, 'value', []);
                addParameter(p, 'base', &#x27;context&#x27;);

                parse(p, varargin{:});

                if ~isempty(p.Results.found)
                    obj.props_('found') = p.Results.found;
                end
                if ~isempty(p.Results.value)
                    obj.props_('value') = p.Results.value;
                end
                if ~isempty(p.Results.base)
                    obj.props_('base') = p.Results.base;
                end
            end
        end
        function result = get.found(obj)
            if ismethod(obj, 'get_found')
                result = obj.get_found();
            else
                if isKey(obj.props_, 'found')
                    result = obj.props_('found');
                else
                    result = [];
                end
            end
        end
        function obj = set.found(obj, value)
            obj.props_('found') = value;
        end
        function result = get.value(obj)
            if ismethod(obj, 'get_value')
                result = obj.get_value();
            else
                if isKey(obj.props_, 'value')
                    result = obj.props_('value');
                else
                    result = [];
                end
            end
        end
        function obj = set.value(obj, value)
            obj.props_('value') = value;
        end
        function result = get.base(obj)
            if ismethod(obj, 'get_base')
                result = obj.get_base();
            else
                if isKey(obj.props_, 'base')
                    result = obj.props_('base');
                else
                    result = [];
                end
            end
        end
        function obj = set.base(obj, value)
            obj.props_('base') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'found')
                result('found') = flywheel.ModelBase.serializeValue(obj.props_('found'), 'logical');
            end
            if isKey(obj.props_, 'value')
                result('value') = flywheel.ModelBase.serializeValue(obj.props_('value'), 'containers.Map');
            end
            if isKey(obj.props_, 'base')
                result('base') = flywheel.ModelBase.serializeValue(obj.props_('base'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'found')
                result.found = obj.props_('found');
            else
                result.found = [];
            end
            if isKey(obj.props_, 'value')
                result.value = obj.props_('value');
            else
                result.value = [];
            end
            if isKey(obj.props_, 'base')
                result.base = obj.props_('base');
            else
                result.base = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'found')
                    propList.found = obj.props_('found');
                else
                    propList.found = [];
                end
                if isKey(obj.props_, 'value')
                    propList.value = obj.props_('value');
                else
                    propList.value = [];
                end
                if isKey(obj.props_, 'base')
                    propList.base = obj.props_('base');
                else
                    propList.base = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.ContextInput;
            if isfield(json, 'found')
                obj.props_('found') = flywheel.ModelBase.deserializeValue(json.found, 'logical');
            end
            if isfield(json, 'value')
                obj.props_('value') = flywheel.ModelBase.deserializeValue(json.value, 'containers.Map');
            end
            if isfield(json, 'base')
                obj.props_('base') = flywheel.ModelBase.deserializeValue(json.base, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.ContextInput')
                    obj = flywheel.model.ContextInput(obj);
                end
                if isKey(obj.props_, 'found')
                end
                if isKey(obj.props_, 'value')
                end
                if isKey(obj.props_, 'base')
                end
            end
        end
    end
end
