% CoreModelsApiKeyApiKeyInput
%
% CoreModelsApiKeyApiKeyInput Properties:
%    label     
%    expiresAt 
%
% CoreModelsApiKeyApiKeyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CoreModelsApiKeyApiKeyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'label', 'expiresAt' }, ...
            { 'label', 'expires_at' });
    end
    properties(Dependent)
        label
        expiresAt
    end
    methods
        function obj = CoreModelsApiKeyApiKeyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.CoreModelsApiKeyApiKeyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'label', []);
                addParameter(p, 'expiresAt', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.expiresAt)
                    obj.props_('expires_at') = p.Results.expiresAt;
                end
            end
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.expiresAt(obj)
            if ismethod(obj, 'get_expiresAt')
                result = obj.get_expiresAt();
            else
                if isKey(obj.props_, 'expires_at')
                    result = obj.props_('expires_at');
                else
                    result = [];
                end
            end
        end
        function obj = set.expiresAt(obj, value)
            obj.props_('expires_at') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'expires_at')
                result('expires_at') = flywheel.ModelBase.serializeValue(obj.props_('expires_at'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'expires_at')
                result.expiresAt = obj.props_('expires_at');
            else
                result.expiresAt = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'expires_at')
                    propList.expiresAt = obj.props_('expires_at');
                else
                    propList.expiresAt = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CoreModelsApiKeyApiKeyInput;
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'expires_at')
                obj.props_('expires_at') = flywheel.ModelBase.deserializeValue(json.expires_at, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CoreModelsApiKeyApiKeyInput')
                    obj = flywheel.model.CoreModelsApiKeyApiKeyInput(obj);
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'expires_at')
                end
            end
        end
    end
end
