% CoreModelsJobsApiKeyInput - Represents an api key input for a job to use to interact with the api  Attributes:     base (str): The input type     key (Optional[str]): The key?
%
% CoreModelsJobsApiKeyInput Properties:
%    base 
%    key  
%
% CoreModelsJobsApiKeyInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CoreModelsJobsApiKeyInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'base', 'key' }, ...
            { 'base', 'key' });
    end
    properties(Dependent)
        base
        key
    end
    methods
        function obj = CoreModelsJobsApiKeyInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.CoreModelsJobsApiKeyInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'base', &#x27;api-key&#x27;);
                addParameter(p, 'key', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.base)
                    obj.props_('base') = p.Results.base;
                end
                if ~isempty(p.Results.key)
                    obj.props_('key') = p.Results.key;
                end
            end
        end
        function result = get.base(obj)
            if ismethod(obj, 'get_base')
                result = obj.get_base();
            else
                if isKey(obj.props_, 'base')
                    result = obj.props_('base');
                else
                    result = [];
                end
            end
        end
        function obj = set.base(obj, value)
            obj.props_('base') = value;
        end
        function result = get.key(obj)
            if ismethod(obj, 'get_key')
                result = obj.get_key();
            else
                if isKey(obj.props_, 'key')
                    result = obj.props_('key');
                else
                    result = [];
                end
            end
        end
        function obj = set.key(obj, value)
            obj.props_('key') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'base')
                result('base') = flywheel.ModelBase.serializeValue(obj.props_('base'), 'char');
            end
            if isKey(obj.props_, 'key')
                result('key') = flywheel.ModelBase.serializeValue(obj.props_('key'), 'char');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'base')
                result.base = obj.props_('base');
            else
                result.base = [];
            end
            if isKey(obj.props_, 'key')
                result.key = obj.props_('key');
            else
                result.key = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'base')
                    propList.base = obj.props_('base');
                else
                    propList.base = [];
                end
                if isKey(obj.props_, 'key')
                    propList.key = obj.props_('key');
                else
                    propList.key = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CoreModelsJobsApiKeyInput;
            if isfield(json, 'base')
                obj.props_('base') = flywheel.ModelBase.deserializeValue(json.base, 'char');
            end
            if isfield(json, 'key')
                obj.props_('key') = flywheel.ModelBase.deserializeValue(json.key, 'char');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CoreModelsJobsApiKeyInput')
                    obj = flywheel.model.CoreModelsJobsApiKeyInput(obj);
                end
                if isKey(obj.props_, 'base')
                end
                if isKey(obj.props_, 'key')
                end
            end
        end
    end
end
