% CreateReportInput
%
% CreateReportInput Properties:
%    projectId  
%    subjectIds 
%    label      
%    status     
%    created    
%
% CreateReportInput Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef CreateReportInput < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'projectId', 'subjectIds', 'label', 'status', 'created' }, ...
            { 'project_id', 'subject_ids', 'label', 'status', 'created' });
    end
    properties(Dependent)
        projectId
        subjectIds
        label
        status
        created
    end
    methods
        function obj = CreateReportInput(varargin)
            obj@flywheel.ModelBase(flywheel.model.CreateReportInput.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'projectId', []);
                addParameter(p, 'subjectIds', []);
                addParameter(p, 'label', []);
                addParameter(p, 'status', []);
                addParameter(p, 'created', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.subjectIds)
                    obj.props_('subject_ids') = p.Results.subjectIds;
                end
                if ~isempty(p.Results.label)
                    obj.props_('label') = p.Results.label;
                end
                if ~isempty(p.Results.status)
                    obj.props_('status') = p.Results.status;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
            end
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.subjectIds(obj)
            if ismethod(obj, 'get_subjectIds')
                result = obj.get_subjectIds();
            else
                if isKey(obj.props_, 'subject_ids')
                    result = obj.props_('subject_ids');
                else
                    result = [];
                end
            end
        end
        function obj = set.subjectIds(obj, value)
            obj.props_('subject_ids') = value;
        end
        function result = get.label(obj)
            if ismethod(obj, 'get_label')
                result = obj.get_label();
            else
                if isKey(obj.props_, 'label')
                    result = obj.props_('label');
                else
                    result = [];
                end
            end
        end
        function obj = set.label(obj, value)
            obj.props_('label') = value;
        end
        function result = get.status(obj)
            if ismethod(obj, 'get_status')
                result = obj.get_status();
            else
                if isKey(obj.props_, 'status')
                    result = obj.props_('status');
                else
                    result = [];
                end
            end
        end
        function obj = set.status(obj, value)
            obj.props_('status') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'subject_ids')
                result('subject_ids') = flywheel.ModelBase.serializeValue(obj.props_('subject_ids'), 'vector[char]');
            end
            if isKey(obj.props_, 'label')
                result('label') = flywheel.ModelBase.serializeValue(obj.props_('label'), 'char');
            end
            if isKey(obj.props_, 'status')
                result('status') = obj.props_('status').toJson();
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'subject_ids')
                result.subjectIds = obj.props_('subject_ids');
            else
                result.subjectIds = [];
            end
            if isKey(obj.props_, 'label')
                result.label = obj.props_('label');
            else
                result.label = [];
            end
            if isKey(obj.props_, 'status')
                result.status = struct(obj.props_('status'));
            else
                result.status = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'subject_ids')
                    propList.subjectIds = obj.props_('subject_ids');
                else
                    propList.subjectIds = [];
                end
                if isKey(obj.props_, 'label')
                    propList.label = obj.props_('label');
                else
                    propList.label = [];
                end
                if isKey(obj.props_, 'status')
                    propList.status = obj.props_('status');
                else
                    propList.status = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.CreateReportInput;
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'subject_ids')
                obj.props_('subject_ids') = flywheel.ModelBase.deserializeValue(json.subject_ids, 'vector[char]');
            end
            if isfield(json, 'label')
                obj.props_('label') = flywheel.ModelBase.deserializeValue(json.label, 'char');
            end
            if isfield(json, 'status')
                obj.props_('status') = flywheel.model.AllOfCreateReportInputStatus.fromJson(json.status, context);
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.CreateReportInput')
                    obj = flywheel.model.CreateReportInput(obj);
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'subject_ids')
                end
                if isKey(obj.props_, 'label')
                end
                if isKey(obj.props_, 'status')
                    obj.props_('status') =  flywheel.model.AllOfCreateReportInputStatus.ensureIsInstance(obj.props_('status'));
                end
                if isKey(obj.props_, 'created')
                end
            end
        end
    end
end
