% DailyReportUsage - An entry in the usage report, describing storage and gear usage by group
%
% DailyReportUsage Properties:
%    year                           - The year that this record represents
%    month                          - The month that this record represents
%    day                            - The day that this record represents
%    projectLabel                   - Application-specific label
%    group                          - The group label
%    project                       
%    sessionCount                   - The number of sessions that existed at the last collection time
%    centerJobCount                 - The number of center-designated gear jobs that completed during the time frame (billable to the center)
%    groupJobCount                  - The number of non-center-designated (lab) gear jobs that completed during the time frame (billable to the group)
%    centerComputeMs                - The compute time of center-designated gear jobs completed during the time frame (billable to the center)
%    groupComputeMs                 - The compute time of non-center-designated (lab) gear jobs completed during the time frame (billable to the group)
%    centerStorageBytes             - The total storage used by files originating from devices or center-designated gears on this day (billable to the center)
%    centerStorageSoftDeletedBytes  - The total storage used by soft deleted files originating from devices or center-designated gears on this day (billable to the center)
%    groupStorageBytes              - The total storage used by files not originating from devices or non-center-designated (lab) gears on this day (billable to the group)
%    groupStorageSoftDeletedBytes   - The total storage used by soft deleted files not originating from devices or non-center-designated (lab) gears on this day (billable to the group)
%
% DailyReportUsage Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DailyReportUsage < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'year', 'month', 'day', 'projectLabel', 'group', 'project', 'sessionCount', 'centerJobCount', 'groupJobCount', 'centerComputeMs', 'groupComputeMs', 'centerStorageBytes', 'centerStorageSoftDeletedBytes', 'groupStorageBytes', 'groupStorageSoftDeletedBytes' }, ...
            { 'year', 'month', 'day', 'project_label', 'group', 'project', 'session_count', 'center_job_count', 'group_job_count', 'center_compute_ms', 'group_compute_ms', 'center_storage_bytes', 'center_storage_soft_deleted_bytes', 'group_storage_bytes', 'group_storage_soft_deleted_bytes' });
    end
    properties(Dependent)
        year
        month
        day
        projectLabel
        group
        project
        sessionCount
        centerJobCount
        groupJobCount
        centerComputeMs
        groupComputeMs
        centerStorageBytes
        centerStorageSoftDeletedBytes
        groupStorageBytes
        groupStorageSoftDeletedBytes
    end
    methods
        function obj = DailyReportUsage(varargin)
            obj@flywheel.ModelBase(flywheel.model.DailyReportUsage.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'year', []);
                addParameter(p, 'month', []);
                addParameter(p, 'day', []);
                addParameter(p, 'projectLabel', []);
                addParameter(p, 'group', []);
                addParameter(p, 'project', []);
                addParameter(p, 'sessionCount', 0);
                addParameter(p, 'centerJobCount', 0);
                addParameter(p, 'groupJobCount', 0);
                addParameter(p, 'centerComputeMs', 0);
                addParameter(p, 'groupComputeMs', 0);
                addParameter(p, 'centerStorageBytes', 0);
                addParameter(p, 'centerStorageSoftDeletedBytes', 0);
                addParameter(p, 'groupStorageBytes', 0);
                addParameter(p, 'groupStorageSoftDeletedBytes', 0);

                parse(p, varargin{:});

                if ~isempty(p.Results.year)
                    obj.props_('year') = p.Results.year;
                end
                if ~isempty(p.Results.month)
                    obj.props_('month') = p.Results.month;
                end
                if ~isempty(p.Results.day)
                    obj.props_('day') = p.Results.day;
                end
                if ~isempty(p.Results.projectLabel)
                    obj.props_('project_label') = p.Results.projectLabel;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.project)
                    obj.props_('project') = p.Results.project;
                end
                if ~isempty(p.Results.sessionCount)
                    obj.props_('session_count') = p.Results.sessionCount;
                end
                if ~isempty(p.Results.centerJobCount)
                    obj.props_('center_job_count') = p.Results.centerJobCount;
                end
                if ~isempty(p.Results.groupJobCount)
                    obj.props_('group_job_count') = p.Results.groupJobCount;
                end
                if ~isempty(p.Results.centerComputeMs)
                    obj.props_('center_compute_ms') = p.Results.centerComputeMs;
                end
                if ~isempty(p.Results.groupComputeMs)
                    obj.props_('group_compute_ms') = p.Results.groupComputeMs;
                end
                if ~isempty(p.Results.centerStorageBytes)
                    obj.props_('center_storage_bytes') = p.Results.centerStorageBytes;
                end
                if ~isempty(p.Results.centerStorageSoftDeletedBytes)
                    obj.props_('center_storage_soft_deleted_bytes') = p.Results.centerStorageSoftDeletedBytes;
                end
                if ~isempty(p.Results.groupStorageBytes)
                    obj.props_('group_storage_bytes') = p.Results.groupStorageBytes;
                end
                if ~isempty(p.Results.groupStorageSoftDeletedBytes)
                    obj.props_('group_storage_soft_deleted_bytes') = p.Results.groupStorageSoftDeletedBytes;
                end
            end
        end
        function result = get.year(obj)
            if ismethod(obj, 'get_year')
                result = obj.get_year();
            else
                if isKey(obj.props_, 'year')
                    result = obj.props_('year');
                else
                    result = [];
                end
            end
        end
        function obj = set.year(obj, value)
            obj.props_('year') = value;
        end
        function result = get.month(obj)
            if ismethod(obj, 'get_month')
                result = obj.get_month();
            else
                if isKey(obj.props_, 'month')
                    result = obj.props_('month');
                else
                    result = [];
                end
            end
        end
        function obj = set.month(obj, value)
            obj.props_('month') = value;
        end
        function result = get.day(obj)
            if ismethod(obj, 'get_day')
                result = obj.get_day();
            else
                if isKey(obj.props_, 'day')
                    result = obj.props_('day');
                else
                    result = [];
                end
            end
        end
        function obj = set.day(obj, value)
            obj.props_('day') = value;
        end
        function result = get.projectLabel(obj)
            if ismethod(obj, 'get_projectLabel')
                result = obj.get_projectLabel();
            else
                if isKey(obj.props_, 'project_label')
                    result = obj.props_('project_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectLabel(obj, value)
            obj.props_('project_label') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.project(obj)
            if ismethod(obj, 'get_project')
                result = obj.get_project();
            else
                if isKey(obj.props_, 'project')
                    result = obj.props_('project');
                else
                    result = [];
                end
            end
        end
        function obj = set.project(obj, value)
            obj.props_('project') = value;
        end
        function result = get.sessionCount(obj)
            if ismethod(obj, 'get_sessionCount')
                result = obj.get_sessionCount();
            else
                if isKey(obj.props_, 'session_count')
                    result = obj.props_('session_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.sessionCount(obj, value)
            obj.props_('session_count') = value;
        end
        function result = get.centerJobCount(obj)
            if ismethod(obj, 'get_centerJobCount')
                result = obj.get_centerJobCount();
            else
                if isKey(obj.props_, 'center_job_count')
                    result = obj.props_('center_job_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerJobCount(obj, value)
            obj.props_('center_job_count') = value;
        end
        function result = get.groupJobCount(obj)
            if ismethod(obj, 'get_groupJobCount')
                result = obj.get_groupJobCount();
            else
                if isKey(obj.props_, 'group_job_count')
                    result = obj.props_('group_job_count');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupJobCount(obj, value)
            obj.props_('group_job_count') = value;
        end
        function result = get.centerComputeMs(obj)
            if ismethod(obj, 'get_centerComputeMs')
                result = obj.get_centerComputeMs();
            else
                if isKey(obj.props_, 'center_compute_ms')
                    result = obj.props_('center_compute_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerComputeMs(obj, value)
            obj.props_('center_compute_ms') = value;
        end
        function result = get.groupComputeMs(obj)
            if ismethod(obj, 'get_groupComputeMs')
                result = obj.get_groupComputeMs();
            else
                if isKey(obj.props_, 'group_compute_ms')
                    result = obj.props_('group_compute_ms');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupComputeMs(obj, value)
            obj.props_('group_compute_ms') = value;
        end
        function result = get.centerStorageBytes(obj)
            if ismethod(obj, 'get_centerStorageBytes')
                result = obj.get_centerStorageBytes();
            else
                if isKey(obj.props_, 'center_storage_bytes')
                    result = obj.props_('center_storage_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerStorageBytes(obj, value)
            obj.props_('center_storage_bytes') = value;
        end
        function result = get.centerStorageSoftDeletedBytes(obj)
            if ismethod(obj, 'get_centerStorageSoftDeletedBytes')
                result = obj.get_centerStorageSoftDeletedBytes();
            else
                if isKey(obj.props_, 'center_storage_soft_deleted_bytes')
                    result = obj.props_('center_storage_soft_deleted_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.centerStorageSoftDeletedBytes(obj, value)
            obj.props_('center_storage_soft_deleted_bytes') = value;
        end
        function result = get.groupStorageBytes(obj)
            if ismethod(obj, 'get_groupStorageBytes')
                result = obj.get_groupStorageBytes();
            else
                if isKey(obj.props_, 'group_storage_bytes')
                    result = obj.props_('group_storage_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupStorageBytes(obj, value)
            obj.props_('group_storage_bytes') = value;
        end
        function result = get.groupStorageSoftDeletedBytes(obj)
            if ismethod(obj, 'get_groupStorageSoftDeletedBytes')
                result = obj.get_groupStorageSoftDeletedBytes();
            else
                if isKey(obj.props_, 'group_storage_soft_deleted_bytes')
                    result = obj.props_('group_storage_soft_deleted_bytes');
                else
                    result = [];
                end
            end
        end
        function obj = set.groupStorageSoftDeletedBytes(obj, value)
            obj.props_('group_storage_soft_deleted_bytes') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'year')
                result('year') = flywheel.ModelBase.serializeValue(obj.props_('year'), 'integer');
            end
            if isKey(obj.props_, 'month')
                result('month') = flywheel.ModelBase.serializeValue(obj.props_('month'), 'integer');
            end
            if isKey(obj.props_, 'day')
                result('day') = flywheel.ModelBase.serializeValue(obj.props_('day'), 'integer');
            end
            if isKey(obj.props_, 'project_label')
                result('project_label') = flywheel.ModelBase.serializeValue(obj.props_('project_label'), 'char');
            end
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'char');
            end
            if isKey(obj.props_, 'project')
                result('project') = flywheel.ModelBase.serializeValue(obj.props_('project'), 'char');
            end
            if isKey(obj.props_, 'session_count')
                result('session_count') = flywheel.ModelBase.serializeValue(obj.props_('session_count'), 'integer');
            end
            if isKey(obj.props_, 'center_job_count')
                result('center_job_count') = flywheel.ModelBase.serializeValue(obj.props_('center_job_count'), 'integer');
            end
            if isKey(obj.props_, 'group_job_count')
                result('group_job_count') = flywheel.ModelBase.serializeValue(obj.props_('group_job_count'), 'integer');
            end
            if isKey(obj.props_, 'center_compute_ms')
                result('center_compute_ms') = flywheel.ModelBase.serializeValue(obj.props_('center_compute_ms'), 'integer');
            end
            if isKey(obj.props_, 'group_compute_ms')
                result('group_compute_ms') = flywheel.ModelBase.serializeValue(obj.props_('group_compute_ms'), 'integer');
            end
            if isKey(obj.props_, 'center_storage_bytes')
                result('center_storage_bytes') = flywheel.ModelBase.serializeValue(obj.props_('center_storage_bytes'), 'integer');
            end
            if isKey(obj.props_, 'center_storage_soft_deleted_bytes')
                result('center_storage_soft_deleted_bytes') = flywheel.ModelBase.serializeValue(obj.props_('center_storage_soft_deleted_bytes'), 'integer');
            end
            if isKey(obj.props_, 'group_storage_bytes')
                result('group_storage_bytes') = flywheel.ModelBase.serializeValue(obj.props_('group_storage_bytes'), 'integer');
            end
            if isKey(obj.props_, 'group_storage_soft_deleted_bytes')
                result('group_storage_soft_deleted_bytes') = flywheel.ModelBase.serializeValue(obj.props_('group_storage_soft_deleted_bytes'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'year')
                result.year = obj.props_('year');
            else
                result.year = [];
            end
            if isKey(obj.props_, 'month')
                result.month = obj.props_('month');
            else
                result.month = [];
            end
            if isKey(obj.props_, 'day')
                result.day = obj.props_('day');
            else
                result.day = [];
            end
            if isKey(obj.props_, 'project_label')
                result.projectLabel = obj.props_('project_label');
            else
                result.projectLabel = [];
            end
            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'project')
                result.project = obj.props_('project');
            else
                result.project = [];
            end
            if isKey(obj.props_, 'session_count')
                result.sessionCount = obj.props_('session_count');
            else
                result.sessionCount = [];
            end
            if isKey(obj.props_, 'center_job_count')
                result.centerJobCount = obj.props_('center_job_count');
            else
                result.centerJobCount = [];
            end
            if isKey(obj.props_, 'group_job_count')
                result.groupJobCount = obj.props_('group_job_count');
            else
                result.groupJobCount = [];
            end
            if isKey(obj.props_, 'center_compute_ms')
                result.centerComputeMs = obj.props_('center_compute_ms');
            else
                result.centerComputeMs = [];
            end
            if isKey(obj.props_, 'group_compute_ms')
                result.groupComputeMs = obj.props_('group_compute_ms');
            else
                result.groupComputeMs = [];
            end
            if isKey(obj.props_, 'center_storage_bytes')
                result.centerStorageBytes = obj.props_('center_storage_bytes');
            else
                result.centerStorageBytes = [];
            end
            if isKey(obj.props_, 'center_storage_soft_deleted_bytes')
                result.centerStorageSoftDeletedBytes = obj.props_('center_storage_soft_deleted_bytes');
            else
                result.centerStorageSoftDeletedBytes = [];
            end
            if isKey(obj.props_, 'group_storage_bytes')
                result.groupStorageBytes = obj.props_('group_storage_bytes');
            else
                result.groupStorageBytes = [];
            end
            if isKey(obj.props_, 'group_storage_soft_deleted_bytes')
                result.groupStorageSoftDeletedBytes = obj.props_('group_storage_soft_deleted_bytes');
            else
                result.groupStorageSoftDeletedBytes = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'year')
                    propList.year = obj.props_('year');
                else
                    propList.year = [];
                end
                if isKey(obj.props_, 'month')
                    propList.month = obj.props_('month');
                else
                    propList.month = [];
                end
                if isKey(obj.props_, 'day')
                    propList.day = obj.props_('day');
                else
                    propList.day = [];
                end
                if isKey(obj.props_, 'project_label')
                    propList.projectLabel = obj.props_('project_label');
                else
                    propList.projectLabel = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'project')
                    propList.project = obj.props_('project');
                else
                    propList.project = [];
                end
                if isKey(obj.props_, 'session_count')
                    propList.sessionCount = obj.props_('session_count');
                else
                    propList.sessionCount = [];
                end
                if isKey(obj.props_, 'center_job_count')
                    propList.centerJobCount = obj.props_('center_job_count');
                else
                    propList.centerJobCount = [];
                end
                if isKey(obj.props_, 'group_job_count')
                    propList.groupJobCount = obj.props_('group_job_count');
                else
                    propList.groupJobCount = [];
                end
                if isKey(obj.props_, 'center_compute_ms')
                    propList.centerComputeMs = obj.props_('center_compute_ms');
                else
                    propList.centerComputeMs = [];
                end
                if isKey(obj.props_, 'group_compute_ms')
                    propList.groupComputeMs = obj.props_('group_compute_ms');
                else
                    propList.groupComputeMs = [];
                end
                if isKey(obj.props_, 'center_storage_bytes')
                    propList.centerStorageBytes = obj.props_('center_storage_bytes');
                else
                    propList.centerStorageBytes = [];
                end
                if isKey(obj.props_, 'center_storage_soft_deleted_bytes')
                    propList.centerStorageSoftDeletedBytes = obj.props_('center_storage_soft_deleted_bytes');
                else
                    propList.centerStorageSoftDeletedBytes = [];
                end
                if isKey(obj.props_, 'group_storage_bytes')
                    propList.groupStorageBytes = obj.props_('group_storage_bytes');
                else
                    propList.groupStorageBytes = [];
                end
                if isKey(obj.props_, 'group_storage_soft_deleted_bytes')
                    propList.groupStorageSoftDeletedBytes = obj.props_('group_storage_soft_deleted_bytes');
                else
                    propList.groupStorageSoftDeletedBytes = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DailyReportUsage;
            if isfield(json, 'year')
                obj.props_('year') = flywheel.ModelBase.deserializeValue(json.year, 'integer');
            end
            if isfield(json, 'month')
                obj.props_('month') = flywheel.ModelBase.deserializeValue(json.month, 'integer');
            end
            if isfield(json, 'day')
                obj.props_('day') = flywheel.ModelBase.deserializeValue(json.day, 'integer');
            end
            if isfield(json, 'project_label')
                obj.props_('project_label') = flywheel.ModelBase.deserializeValue(json.project_label, 'char');
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'char');
            end
            if isfield(json, 'project')
                obj.props_('project') = flywheel.ModelBase.deserializeValue(json.project, 'char');
            end
            if isfield(json, 'session_count')
                obj.props_('session_count') = flywheel.ModelBase.deserializeValue(json.session_count, 'integer');
            end
            if isfield(json, 'center_job_count')
                obj.props_('center_job_count') = flywheel.ModelBase.deserializeValue(json.center_job_count, 'integer');
            end
            if isfield(json, 'group_job_count')
                obj.props_('group_job_count') = flywheel.ModelBase.deserializeValue(json.group_job_count, 'integer');
            end
            if isfield(json, 'center_compute_ms')
                obj.props_('center_compute_ms') = flywheel.ModelBase.deserializeValue(json.center_compute_ms, 'integer');
            end
            if isfield(json, 'group_compute_ms')
                obj.props_('group_compute_ms') = flywheel.ModelBase.deserializeValue(json.group_compute_ms, 'integer');
            end
            if isfield(json, 'center_storage_bytes')
                obj.props_('center_storage_bytes') = flywheel.ModelBase.deserializeValue(json.center_storage_bytes, 'integer');
            end
            if isfield(json, 'center_storage_soft_deleted_bytes')
                obj.props_('center_storage_soft_deleted_bytes') = flywheel.ModelBase.deserializeValue(json.center_storage_soft_deleted_bytes, 'integer');
            end
            if isfield(json, 'group_storage_bytes')
                obj.props_('group_storage_bytes') = flywheel.ModelBase.deserializeValue(json.group_storage_bytes, 'integer');
            end
            if isfield(json, 'group_storage_soft_deleted_bytes')
                obj.props_('group_storage_soft_deleted_bytes') = flywheel.ModelBase.deserializeValue(json.group_storage_soft_deleted_bytes, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DailyReportUsage')
                    obj = flywheel.model.DailyReportUsage(obj);
                end
                if isKey(obj.props_, 'year')
                end
                if isKey(obj.props_, 'month')
                end
                if isKey(obj.props_, 'day')
                end
                if isKey(obj.props_, 'project_label')
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'project')
                end
                if isKey(obj.props_, 'session_count')
                end
                if isKey(obj.props_, 'center_job_count')
                end
                if isKey(obj.props_, 'group_job_count')
                end
                if isKey(obj.props_, 'center_compute_ms')
                end
                if isKey(obj.props_, 'group_compute_ms')
                end
                if isKey(obj.props_, 'center_storage_bytes')
                end
                if isKey(obj.props_, 'center_storage_soft_deleted_bytes')
                end
                if isKey(obj.props_, 'group_storage_bytes')
                end
                if isKey(obj.props_, 'group_storage_soft_deleted_bytes')
                end
            end
        end
    end
end
