% DataViewColumnAlias - Represents a column alias for use in data views. Maps from src to name.
%
% DataViewColumnAlias Properties:
%    name         - The column alias name
%    src          - The source for this column's data
%    group        - The list of columns that belong to this group
%    description  - A description of this field
%    type        
%    expr         - An optional expression, allowing simple calculations
%    hidden      
%
% DataViewColumnAlias Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DataViewColumnAlias < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'name', 'src', 'group', 'description', 'type', 'expr', 'hidden' }, ...
            { 'name', 'src', 'group', 'description', 'type', 'expr', 'hidden' });
    end
    properties(Dependent)
        name
        src
        group
        description
        type
        expr
        hidden
    end
    methods
        function obj = DataViewColumnAlias(varargin)
            obj@flywheel.ModelBase(flywheel.model.DataViewColumnAlias.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'name', []);
                addParameter(p, 'src', []);
                addParameter(p, 'group', []);
                addParameter(p, 'description', []);
                addParameter(p, 'type', []);
                addParameter(p, 'expr', []);
                addParameter(p, 'hidden', []);

                parse(p, varargin{:});

                if ~isempty(p.Results.name)
                    obj.props_('name') = p.Results.name;
                end
                if ~isempty(p.Results.src)
                    obj.props_('src') = p.Results.src;
                end
                if ~isempty(p.Results.group)
                    obj.props_('group') = p.Results.group;
                end
                if ~isempty(p.Results.description)
                    obj.props_('description') = p.Results.description;
                end
                if ~isempty(p.Results.type)
                    obj.props_('type') = p.Results.type;
                end
                if ~isempty(p.Results.expr)
                    obj.props_('expr') = p.Results.expr;
                end
                if ~isempty(p.Results.hidden)
                    obj.props_('hidden') = p.Results.hidden;
                end
            end
        end
        function result = get.name(obj)
            if ismethod(obj, 'get_name')
                result = obj.get_name();
            else
                if isKey(obj.props_, 'name')
                    result = obj.props_('name');
                else
                    result = [];
                end
            end
        end
        function obj = set.name(obj, value)
            obj.props_('name') = value;
        end
        function result = get.src(obj)
            if ismethod(obj, 'get_src')
                result = obj.get_src();
            else
                if isKey(obj.props_, 'src')
                    result = obj.props_('src');
                else
                    result = [];
                end
            end
        end
        function obj = set.src(obj, value)
            obj.props_('src') = value;
        end
        function result = get.group(obj)
            if ismethod(obj, 'get_group')
                result = obj.get_group();
            else
                if isKey(obj.props_, 'group')
                    result = obj.props_('group');
                else
                    result = [];
                end
            end
        end
        function obj = set.group(obj, value)
            obj.props_('group') = value;
        end
        function result = get.description(obj)
            if ismethod(obj, 'get_description')
                result = obj.get_description();
            else
                if isKey(obj.props_, 'description')
                    result = obj.props_('description');
                else
                    result = [];
                end
            end
        end
        function obj = set.description(obj, value)
            obj.props_('description') = value;
        end
        function result = get.type(obj)
            if ismethod(obj, 'get_type')
                result = obj.get_type();
            else
                if isKey(obj.props_, 'type')
                    result = obj.props_('type');
                else
                    result = [];
                end
            end
        end
        function obj = set.type(obj, value)
            obj.props_('type') = value;
        end
        function result = get.expr(obj)
            if ismethod(obj, 'get_expr')
                result = obj.get_expr();
            else
                if isKey(obj.props_, 'expr')
                    result = obj.props_('expr');
                else
                    result = [];
                end
            end
        end
        function obj = set.expr(obj, value)
            obj.props_('expr') = value;
        end
        function result = get.hidden(obj)
            if ismethod(obj, 'get_hidden')
                result = obj.get_hidden();
            else
                if isKey(obj.props_, 'hidden')
                    result = obj.props_('hidden');
                else
                    result = [];
                end
            end
        end
        function obj = set.hidden(obj, value)
            obj.props_('hidden') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, 'name')
                result('name') = flywheel.ModelBase.serializeValue(obj.props_('name'), 'char');
            end
            if isKey(obj.props_, 'src')
                result('src') = flywheel.ModelBase.serializeValue(obj.props_('src'), 'char');
            end
            if isKey(obj.props_, 'group')
                result('group') = flywheel.ModelBase.serializeValue(obj.props_('group'), 'vector[char]');
            end
            if isKey(obj.props_, 'description')
                result('description') = flywheel.ModelBase.serializeValue(obj.props_('description'), 'char');
            end
            if isKey(obj.props_, 'type')
                result('type') = obj.props_('type').toJson();
            end
            if isKey(obj.props_, 'expr')
                result('expr') = flywheel.ModelBase.serializeValue(obj.props_('expr'), 'char');
            end
            if isKey(obj.props_, 'hidden')
                result('hidden') = flywheel.ModelBase.serializeValue(obj.props_('hidden'), 'logical');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, 'name')
                result.name = obj.props_('name');
            else
                result.name = [];
            end
            if isKey(obj.props_, 'src')
                result.src = obj.props_('src');
            else
                result.src = [];
            end
            if isKey(obj.props_, 'group')
                result.group = obj.props_('group');
            else
                result.group = [];
            end
            if isKey(obj.props_, 'description')
                result.description = obj.props_('description');
            else
                result.description = [];
            end
            if isKey(obj.props_, 'type')
                result.type = struct(obj.props_('type'));
            else
                result.type = [];
            end
            if isKey(obj.props_, 'expr')
                result.expr = obj.props_('expr');
            else
                result.expr = [];
            end
            if isKey(obj.props_, 'hidden')
                result.hidden = obj.props_('hidden');
            else
                result.hidden = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, 'name')
                    propList.name = obj.props_('name');
                else
                    propList.name = [];
                end
                if isKey(obj.props_, 'src')
                    propList.src = obj.props_('src');
                else
                    propList.src = [];
                end
                if isKey(obj.props_, 'group')
                    propList.group = obj.props_('group');
                else
                    propList.group = [];
                end
                if isKey(obj.props_, 'description')
                    propList.description = obj.props_('description');
                else
                    propList.description = [];
                end
                if isKey(obj.props_, 'type')
                    propList.type = obj.props_('type');
                else
                    propList.type = [];
                end
                if isKey(obj.props_, 'expr')
                    propList.expr = obj.props_('expr');
                else
                    propList.expr = [];
                end
                if isKey(obj.props_, 'hidden')
                    propList.hidden = obj.props_('hidden');
                else
                    propList.hidden = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DataViewColumnAlias;
            if isfield(json, 'name')
                obj.props_('name') = flywheel.ModelBase.deserializeValue(json.name, 'char');
            end
            if isfield(json, 'src')
                obj.props_('src') = flywheel.ModelBase.deserializeValue(json.src, 'char');
            end
            if isfield(json, 'group')
                obj.props_('group') = flywheel.ModelBase.deserializeValue(json.group, 'vector[char]');
            end
            if isfield(json, 'description')
                obj.props_('description') = flywheel.ModelBase.deserializeValue(json.description, 'char');
            end
            if isfield(json, 'type')
                obj.props_('type') = flywheel.model.ColumnType.fromJson(json.type, context);
            end
            if isfield(json, 'expr')
                obj.props_('expr') = flywheel.ModelBase.deserializeValue(json.expr, 'char');
            end
            if isfield(json, 'hidden')
                obj.props_('hidden') = flywheel.ModelBase.deserializeValue(json.hidden, 'logical');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DataViewColumnAlias')
                    obj = flywheel.model.DataViewColumnAlias(obj);
                end
                if isKey(obj.props_, 'name')
                end
                if isKey(obj.props_, 'src')
                end
                if isKey(obj.props_, 'group')
                end
                if isKey(obj.props_, 'description')
                end
                if isKey(obj.props_, 'type')
                    obj.props_('type') =  flywheel.model.ColumnType.ensureIsInstance(obj.props_('type'));
                end
                if isKey(obj.props_, 'expr')
                end
                if isKey(obj.props_, 'hidden')
                end
            end
        end
    end
end
