% DataViewExecution
%
% DataViewExecution Properties:
%    id             - Unique database ID
%    created        - Creation time (automatically set)
%    modified       - Last modification time (automatically updated)
%    timestampRan  
%    userId         - Database ID of a user
%    projectId      - Unique database ID
%    state         
%    dataViewLabel 
%    dataViewId     - Unique database ID
%    storageFileId  - Unique database ID
%    taskId         - Hyphen-separated universally unique identifier
%    expiresOn     
%    revision       - An incremental document revision number
%
% DataViewExecution Methods:
%    toJson - Convert the object to a Map that can be encoded to json
%    struct - Convert the object to a struct
    classdef DataViewExecution < flywheel.ModelBase
    % NOTE: This file is auto generated by the swagger code generator program.
    % Do not edit the file manually.
    properties (Constant)
        propertyMap = containers.Map({ 'id', 'created', 'modified', 'timestampRan', 'userId', 'projectId', 'state', 'dataViewLabel', 'dataViewId', 'storageFileId', 'taskId', 'expiresOn', 'revision' }, ...
            { '_id', 'created', 'modified', 'timestamp_ran', 'user_id', 'project_id', 'state', 'data_view_label', 'data_view_id', 'storage_file_id', 'task_id', 'expires_on', 'revision' });
    end
    properties(Dependent)
        id
        created
        modified
        timestampRan
        userId
        projectId
        state
        dataViewLabel
        dataViewId
        storageFileId
        taskId
        expiresOn
        revision
    end
    methods
        function obj = DataViewExecution(varargin)
            obj@flywheel.ModelBase(flywheel.model.DataViewExecution.propertyMap);

            % Allow empty object creation
            if length(varargin)
                p = inputParser;
                addParameter(p, 'id', []);
                addParameter(p, 'created', []);
                addParameter(p, 'modified', []);
                addParameter(p, 'timestampRan', []);
                addParameter(p, 'userId', []);
                addParameter(p, 'projectId', []);
                addParameter(p, 'state', []);
                addParameter(p, 'dataViewLabel', &#x27;UNKNOWN&#x27;);
                addParameter(p, 'dataViewId', []);
                addParameter(p, 'storageFileId', []);
                addParameter(p, 'taskId', []);
                addParameter(p, 'expiresOn', []);
                addParameter(p, 'revision', 1);

                parse(p, varargin{:});

                if ~isempty(p.Results.id)
                    obj.props_('_id') = p.Results.id;
                end
                if ~isempty(p.Results.created)
                    obj.props_('created') = p.Results.created;
                end
                if ~isempty(p.Results.modified)
                    obj.props_('modified') = p.Results.modified;
                end
                if ~isempty(p.Results.timestampRan)
                    obj.props_('timestamp_ran') = p.Results.timestampRan;
                end
                if ~isempty(p.Results.userId)
                    obj.props_('user_id') = p.Results.userId;
                end
                if ~isempty(p.Results.projectId)
                    obj.props_('project_id') = p.Results.projectId;
                end
                if ~isempty(p.Results.state)
                    obj.props_('state') = p.Results.state;
                end
                if ~isempty(p.Results.dataViewLabel)
                    obj.props_('data_view_label') = p.Results.dataViewLabel;
                end
                if ~isempty(p.Results.dataViewId)
                    obj.props_('data_view_id') = p.Results.dataViewId;
                end
                if ~isempty(p.Results.storageFileId)
                    obj.props_('storage_file_id') = p.Results.storageFileId;
                end
                if ~isempty(p.Results.taskId)
                    obj.props_('task_id') = p.Results.taskId;
                end
                if ~isempty(p.Results.expiresOn)
                    obj.props_('expires_on') = p.Results.expiresOn;
                end
                if ~isempty(p.Results.revision)
                    obj.props_('revision') = p.Results.revision;
                end
            end
        end
        function result = get.id(obj)
            if ismethod(obj, 'get_id')
                result = obj.get_id();
            else
                if isKey(obj.props_, '_id')
                    result = obj.props_('_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.id(obj, value)
            obj.props_('_id') = value;
        end
        function result = get.created(obj)
            if ismethod(obj, 'get_created')
                result = obj.get_created();
            else
                if isKey(obj.props_, 'created')
                    result = obj.props_('created');
                else
                    result = [];
                end
            end
        end
        function obj = set.created(obj, value)
            obj.props_('created') = value;
        end
        function result = get.modified(obj)
            if ismethod(obj, 'get_modified')
                result = obj.get_modified();
            else
                if isKey(obj.props_, 'modified')
                    result = obj.props_('modified');
                else
                    result = [];
                end
            end
        end
        function obj = set.modified(obj, value)
            obj.props_('modified') = value;
        end
        function result = get.timestampRan(obj)
            if ismethod(obj, 'get_timestampRan')
                result = obj.get_timestampRan();
            else
                if isKey(obj.props_, 'timestamp_ran')
                    result = obj.props_('timestamp_ran');
                else
                    result = [];
                end
            end
        end
        function obj = set.timestampRan(obj, value)
            obj.props_('timestamp_ran') = value;
        end
        function result = get.userId(obj)
            if ismethod(obj, 'get_userId')
                result = obj.get_userId();
            else
                if isKey(obj.props_, 'user_id')
                    result = obj.props_('user_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.userId(obj, value)
            obj.props_('user_id') = value;
        end
        function result = get.projectId(obj)
            if ismethod(obj, 'get_projectId')
                result = obj.get_projectId();
            else
                if isKey(obj.props_, 'project_id')
                    result = obj.props_('project_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.projectId(obj, value)
            obj.props_('project_id') = value;
        end
        function result = get.state(obj)
            if ismethod(obj, 'get_state')
                result = obj.get_state();
            else
                if isKey(obj.props_, 'state')
                    result = obj.props_('state');
                else
                    result = [];
                end
            end
        end
        function obj = set.state(obj, value)
            obj.props_('state') = value;
        end
        function result = get.dataViewLabel(obj)
            if ismethod(obj, 'get_dataViewLabel')
                result = obj.get_dataViewLabel();
            else
                if isKey(obj.props_, 'data_view_label')
                    result = obj.props_('data_view_label');
                else
                    result = [];
                end
            end
        end
        function obj = set.dataViewLabel(obj, value)
            obj.props_('data_view_label') = value;
        end
        function result = get.dataViewId(obj)
            if ismethod(obj, 'get_dataViewId')
                result = obj.get_dataViewId();
            else
                if isKey(obj.props_, 'data_view_id')
                    result = obj.props_('data_view_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.dataViewId(obj, value)
            obj.props_('data_view_id') = value;
        end
        function result = get.storageFileId(obj)
            if ismethod(obj, 'get_storageFileId')
                result = obj.get_storageFileId();
            else
                if isKey(obj.props_, 'storage_file_id')
                    result = obj.props_('storage_file_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.storageFileId(obj, value)
            obj.props_('storage_file_id') = value;
        end
        function result = get.taskId(obj)
            if ismethod(obj, 'get_taskId')
                result = obj.get_taskId();
            else
                if isKey(obj.props_, 'task_id')
                    result = obj.props_('task_id');
                else
                    result = [];
                end
            end
        end
        function obj = set.taskId(obj, value)
            obj.props_('task_id') = value;
        end
        function result = get.expiresOn(obj)
            if ismethod(obj, 'get_expiresOn')
                result = obj.get_expiresOn();
            else
                if isKey(obj.props_, 'expires_on')
                    result = obj.props_('expires_on');
                else
                    result = [];
                end
            end
        end
        function obj = set.expiresOn(obj, value)
            obj.props_('expires_on') = value;
        end
        function result = get.revision(obj)
            if ismethod(obj, 'get_revision')
                result = obj.get_revision();
            else
                if isKey(obj.props_, 'revision')
                    result = obj.props_('revision');
                else
                    result = [];
                end
            end
        end
        function obj = set.revision(obj, value)
            obj.props_('revision') = value;
        end
        function result = toJson(obj)
            result = containers.Map;
            if isKey(obj.props_, '_id')
                result('_id') = flywheel.ModelBase.serializeValue(obj.props_('_id'), 'char');
            end
            if isKey(obj.props_, 'created')
                result('created') = flywheel.ModelBase.serializeValue(obj.props_('created'), 'datetime');
            end
            if isKey(obj.props_, 'modified')
                result('modified') = flywheel.ModelBase.serializeValue(obj.props_('modified'), 'datetime');
            end
            if isKey(obj.props_, 'timestamp_ran')
                result('timestamp_ran') = flywheel.ModelBase.serializeValue(obj.props_('timestamp_ran'), 'datetime');
            end
            if isKey(obj.props_, 'user_id')
                result('user_id') = flywheel.ModelBase.serializeValue(obj.props_('user_id'), 'char');
            end
            if isKey(obj.props_, 'project_id')
                result('project_id') = flywheel.ModelBase.serializeValue(obj.props_('project_id'), 'char');
            end
            if isKey(obj.props_, 'state')
                result('state') = obj.props_('state').toJson();
            end
            if isKey(obj.props_, 'data_view_label')
                result('data_view_label') = flywheel.ModelBase.serializeValue(obj.props_('data_view_label'), 'char');
            end
            if isKey(obj.props_, 'data_view_id')
                result('data_view_id') = flywheel.ModelBase.serializeValue(obj.props_('data_view_id'), 'char');
            end
            if isKey(obj.props_, 'storage_file_id')
                result('storage_file_id') = flywheel.ModelBase.serializeValue(obj.props_('storage_file_id'), 'char');
            end
            if isKey(obj.props_, 'task_id')
                result('task_id') = flywheel.ModelBase.serializeValue(obj.props_('task_id'), 'char');
            end
            if isKey(obj.props_, 'expires_on')
                result('expires_on') = flywheel.ModelBase.serializeValue(obj.props_('expires_on'), 'datetime');
            end
            if isKey(obj.props_, 'revision')
                result('revision') = flywheel.ModelBase.serializeValue(obj.props_('revision'), 'integer');
            end
        end
        function result = struct(obj)
            result = struct;

            if isKey(obj.props_, '_id')
                result.id = obj.props_('_id');
            else
                result.id = [];
            end
            if isKey(obj.props_, 'created')
                result.created = obj.props_('created');
            else
                result.created = [];
            end
            if isKey(obj.props_, 'modified')
                result.modified = obj.props_('modified');
            else
                result.modified = [];
            end
            if isKey(obj.props_, 'timestamp_ran')
                result.timestampRan = obj.props_('timestamp_ran');
            else
                result.timestampRan = [];
            end
            if isKey(obj.props_, 'user_id')
                result.userId = obj.props_('user_id');
            else
                result.userId = [];
            end
            if isKey(obj.props_, 'project_id')
                result.projectId = obj.props_('project_id');
            else
                result.projectId = [];
            end
            if isKey(obj.props_, 'state')
                result.state = struct(obj.props_('state'));
            else
                result.state = [];
            end
            if isKey(obj.props_, 'data_view_label')
                result.dataViewLabel = obj.props_('data_view_label');
            else
                result.dataViewLabel = [];
            end
            if isKey(obj.props_, 'data_view_id')
                result.dataViewId = obj.props_('data_view_id');
            else
                result.dataViewId = [];
            end
            if isKey(obj.props_, 'storage_file_id')
                result.storageFileId = obj.props_('storage_file_id');
            else
                result.storageFileId = [];
            end
            if isKey(obj.props_, 'task_id')
                result.taskId = obj.props_('task_id');
            else
                result.taskId = [];
            end
            if isKey(obj.props_, 'expires_on')
                result.expiresOn = obj.props_('expires_on');
            else
                result.expiresOn = [];
            end
            if isKey(obj.props_, 'revision')
                result.revision = obj.props_('revision');
            else
                result.revision = [];
            end
        end
        function result = returnValue(obj)
            result = obj;
        end
    end
    methods(Access = protected)
        function prpgrp = getPropertyGroups(obj)
            if ~isscalar(obj)
                prpgrp = getPropertyGroups@matlab.mixin.CustomDisplay(obj);
            else
                propList = struct;
                if isKey(obj.props_, '_id')
                    propList.id = obj.props_('_id');
                else
                    propList.id = [];
                end
                if isKey(obj.props_, 'created')
                    propList.created = obj.props_('created');
                else
                    propList.created = [];
                end
                if isKey(obj.props_, 'modified')
                    propList.modified = obj.props_('modified');
                else
                    propList.modified = [];
                end
                if isKey(obj.props_, 'timestamp_ran')
                    propList.timestampRan = obj.props_('timestamp_ran');
                else
                    propList.timestampRan = [];
                end
                if isKey(obj.props_, 'user_id')
                    propList.userId = obj.props_('user_id');
                else
                    propList.userId = [];
                end
                if isKey(obj.props_, 'project_id')
                    propList.projectId = obj.props_('project_id');
                else
                    propList.projectId = [];
                end
                if isKey(obj.props_, 'state')
                    propList.state = obj.props_('state');
                else
                    propList.state = [];
                end
                if isKey(obj.props_, 'data_view_label')
                    propList.dataViewLabel = obj.props_('data_view_label');
                else
                    propList.dataViewLabel = [];
                end
                if isKey(obj.props_, 'data_view_id')
                    propList.dataViewId = obj.props_('data_view_id');
                else
                    propList.dataViewId = [];
                end
                if isKey(obj.props_, 'storage_file_id')
                    propList.storageFileId = obj.props_('storage_file_id');
                else
                    propList.storageFileId = [];
                end
                if isKey(obj.props_, 'task_id')
                    propList.taskId = obj.props_('task_id');
                else
                    propList.taskId = [];
                end
                if isKey(obj.props_, 'expires_on')
                    propList.expiresOn = obj.props_('expires_on');
                else
                    propList.expiresOn = [];
                end
                if isKey(obj.props_, 'revision')
                    propList.revision = obj.props_('revision');
                else
                    propList.revision = [];
                end
                prpgrp = matlab.mixin.util.PropertyGroup(propList);
            end
        end
    end
    methods(Static)
        function obj = fromJson(json, context)
            obj =  flywheel.model.DataViewExecution;
            if isfield(json, 'x0x5Fid')
                obj.props_('_id') = flywheel.ModelBase.deserializeValue(json.x0x5Fid, 'char');
            end
            if isfield(json, 'created')
                obj.props_('created') = flywheel.ModelBase.deserializeValue(json.created, 'datetime');
            end
            if isfield(json, 'modified')
                obj.props_('modified') = flywheel.ModelBase.deserializeValue(json.modified, 'datetime');
            end
            if isfield(json, 'timestamp_ran')
                obj.props_('timestamp_ran') = flywheel.ModelBase.deserializeValue(json.timestamp_ran, 'datetime');
            end
            if isfield(json, 'user_id')
                obj.props_('user_id') = flywheel.ModelBase.deserializeValue(json.user_id, 'char');
            end
            if isfield(json, 'project_id')
                obj.props_('project_id') = flywheel.ModelBase.deserializeValue(json.project_id, 'char');
            end
            if isfield(json, 'state')
                obj.props_('state') = flywheel.model.DataViewExecutionState.fromJson(json.state, context);
            end
            if isfield(json, 'data_view_label')
                obj.props_('data_view_label') = flywheel.ModelBase.deserializeValue(json.data_view_label, 'char');
            end
            if isfield(json, 'data_view_id')
                obj.props_('data_view_id') = flywheel.ModelBase.deserializeValue(json.data_view_id, 'char');
            end
            if isfield(json, 'storage_file_id')
                obj.props_('storage_file_id') = flywheel.ModelBase.deserializeValue(json.storage_file_id, 'char');
            end
            if isfield(json, 'task_id')
                obj.props_('task_id') = flywheel.ModelBase.deserializeValue(json.task_id, 'char');
            end
            if isfield(json, 'expires_on')
                obj.props_('expires_on') = flywheel.ModelBase.deserializeValue(json.expires_on, 'datetime');
            end
            if isfield(json, 'revision')
                obj.props_('revision') = flywheel.ModelBase.deserializeValue(json.revision, 'integer');
            end
            if isprop(obj, 'context_')
                obj.setContext_(context);
            end
        end
        function obj = ensureIsInstance(obj)
            if ~isempty(obj)
                % Realistically, we only convert structs
                if ~isa(obj, 'flywheel.model.DataViewExecution')
                    obj = flywheel.model.DataViewExecution(obj);
                end
                if isKey(obj.props_, '_id')
                end
                if isKey(obj.props_, 'created')
                end
                if isKey(obj.props_, 'modified')
                end
                if isKey(obj.props_, 'timestamp_ran')
                end
                if isKey(obj.props_, 'user_id')
                end
                if isKey(obj.props_, 'project_id')
                end
                if isKey(obj.props_, 'state')
                    obj.props_('state') =  flywheel.model.DataViewExecutionState.ensureIsInstance(obj.props_('state'));
                end
                if isKey(obj.props_, 'data_view_label')
                end
                if isKey(obj.props_, 'data_view_id')
                end
                if isKey(obj.props_, 'storage_file_id')
                end
                if isKey(obj.props_, 'task_id')
                end
                if isKey(obj.props_, 'expires_on')
                end
                if isKey(obj.props_, 'revision')
                end
            end
        end
    end
end
